typedef struct
{
	unsigned char type;						/* type of network */
	char name[16];								/* network name */
	char dir[69];									/* directory for net data */
	unsigned short sysnum;				/* system number */
	void far *con;								/* ptr to callout data */
	void far *ncn;								/* ptr to contact info */
	int num_con;									/* number in array */
	int num_ncn;									/* number in array */
} net_networks_rec;

typedef struct
{
	unsigned short tosys,					/* destination system */
	 touser,											/* destination user */
	 fromsys,											/* originating system */
	 fromuser;										/* originating user */
	unsigned short main_type,			/* main message type */
	 minor_type;									/* minor message type */
	unsigned short list_len;			/* # of entries in system list */
	unsigned long daten;					/* date/time sent */
	unsigned long length;					/* # of bytes of msg after header */
	unsigned short method;				/* method of compression */
} net_header_rec;


typedef struct
{
	unsigned int sysnum;					/* system number of the system */
	char phone[13],								/* phone number of system */
	 name[41];										/* name of system */
	unsigned int speed,						/* max baud rate of system */
	 other,												/* other info about sys (bit-mapped) */
	 forsys;											/* how to get there */
	int numhops;									/* how long to get there */
	float cost;										/* how much it costs to get there */
} net_system_list_rec;


// #define DEBUG 1
#ifdef DEBUG
char *types[] = {
	"undefined_type",
	"net_info      ",
	"email         ",
	"post          ",
	"file          ",
	"pre_post      ",
	"external      ",
	"email_name    ",
	"net_edit      ",							/* 0x08 network editor packet */
	"sub_list      ",							/* 0x09 subs.lst update */
	"Old_Extern    ",							/* 0x0a Linker or PS 2.30 packet, others */
	"group_bbslist ",							/* 0x0b network update from GC */
	"group_connect ",							/* network update from GC */
	"unsed_1       ",							/* unused */
	"group_info    ",							/* misc update from GC */
	"ssm           ",							/* 0x0f so-and-so read your mail */
	"sub_add_req   ",							/* 0x10 add me to your subboard */
	"sub_drop_req  ",							/* remove me from your subboard */
	"sub_add_resp  ",							/* status of add, 0=ok */
	"sub_drop_resp ",							/* status of drop, 0=ok */
	"sub_list_info ",							/* 0x14 info for subs.lst file */
	"unknown       ",							/* unknown type 0x0015 */
	"unknown       ",
	"unknown       ",
	"unknown       ",							/* unknown type 0x0018 */
	"unknown       ",
	"post_by_name  ",							/* 0x001a */
	"new_extern    "							/* 0x1b packscan 2.31 & others */
};
#endif


void read_ini(void);
void ssm(unsigned sys, char *msg);
int get_net_info(int num, net_networks_rec * rec);
unsigned char *daten_to_date(long dt);
void parse_unwanted_pings(char *unwanted, char *main, char *minor, char *tfile);
void checklocal(void);
int is_sys_wanted(unsigned sys);

void email(unsigned sys, char *fname, unsigned from_sys, unsigned from_user);
int sub_type_allowed(unsigned main_type, unsigned minor_type, unsigned sys, unsigned user);
