v4.24a diffs [1/2]:
Random #1 @1


diff -ub 424/BBS.C 424a/BBS.C
--- 424/BBS.C	Thu May 11 17:43:26 1995
+++ 424a/BBS.C	Sat Jul 15 10:02:26 1995
@@ -294,7 +294,7 @@
             usernum=1;
             holdphone(1);
             okskey=1;
-            prt(2,get_string(7));
+            prt(2,get_string(44));
             input(s,50);
             load_workspace(s,0);
             send_email();
diff -ub 424/BBSOVL3.C 424a/BBSOVL3.C
--- 424/BBSOVL3.C	Tue Apr 25 19:34:48 1995
+++ 424a/BBSOVL3.C	Sun May 28 06:08:38 1995
@@ -497,7 +497,6 @@
   long fl;
 
 
-  if(stats) stats=0;
   if(stats) outstr(get_string(1484));
 
   if ((strcmp(input, output) != 0) && (exist(input)) && (!exist(output)))
diff -ub 424/BBSUTL.C 424a/BBSUTL.C
--- 424/BBSUTL.C	Tue Apr 25 19:34:46 1995
+++ 424a/BBSUTL.C	Sun Jun 25 08:08:28 1995
@@ -851,8 +851,11 @@
   if (db)
     s1[i]=0;
   chdir(s1);
-  if (s[1]==':')
+  if (s[1]==':') {
     setdisk(s[0]-'A');
+    if (s[2]==0)
+      chdir("\\");
+  }
 }
 
 void get_dir(char *s, int be)
diff -ub 424/BBSUTL1.C 424a/BBSUTL1.C
--- 424/BBSUTL1.C	Fri May 12 10:07:32 1995
+++ 424a/BBSUTL1.C	Wed Jun 28 05:42:14 1995
@@ -462,6 +462,8 @@
       --i;
     s[i]=0;
     un=atoi(s);
+    if (strchr(s,'@'))
+      un=0;
     sy=atoi(ss);
     ss1=strchr(ss,'.');
     if (ss1)
diff -ub 424/COM.C 424a/COM.C
--- 424/COM.C	Sat May 20 13:26:26 1995
+++ 424a/COM.C	Tue May 30 18:57:16 1995
@@ -1552,7 +1552,7 @@
   ansic(1);
   if (menu_on() && rip_popup && (!rip_subset)) {
 	outstr("[s\r");
-	printmenu(330);
+        printmenu(336);
   }
   while ((!hangup) &&
          ((ch = upcase(getkey())) != *str_yes) &&
diff -ub 424/CONIO.C 424a/CONIO.C
--- 424/CONIO.C	Tue Apr 25 19:34:36 1995
+++ 424a/CONIO.C	Sun Jun 25 07:46:00 1995
@@ -848,10 +848,13 @@
               sysinfo.flags &= ~OP_FLAGS_RIPDRIVE_ON;
               rd_disable();
             } else if (ripdrive) {
-              printf("\a");
               sysinfo.flags |= OP_FLAGS_RIPDRIVE_ON;
               localrip_activate(sysinfo.ripdir, sysinfo.ripdir);
               cleared = NEEDCLEAR;
+            } else if (localrip_detect()) {
+              sysinfo.flags |= OP_FLAGS_RIPDRIVE_ON;
+              nl();
+              pl(get_string(1641));
             }
             break;
 #endif
diff -ub 424/DEFAULTS.C 424a/DEFAULTS.C
--- 424/DEFAULTS.C	Fri May 12 09:36:50 1995
+++ 424a/DEFAULTS.C	Sat Jul 15 07:39:28 1995
@@ -125,10 +125,8 @@
     ansic_x(1); outstr(get_string(1493));
     ansic_x(2); pl((thisuser.sysstatus & sysstatus_no_msgs)?str_no:str_yes);
   }
-  if (rip) {
     ansic_x(1); outstr(get_string(1494));
     ansic_x(2); pl((thisuser.sysstatus & sysstatus_disable_rip)?str_no:str_yes);
-  }
   ansic_x(1); pl(get_string(403));
 }
 
@@ -386,7 +384,7 @@
       abort=0;
       strcpy(s1," ");
       nl();
-      pl(get_string(1150));
+      pl(get_string(1081));
       nl();
       i=0;
       while ((i<subconfnum) && (uconfsub[i].confnum!=-1) && (!abort)) {
@@ -766,6 +764,7 @@
         break;
       case '3':
         thisuser.sysstatus ^= sysstatus_pause_on_page;
+        if (menu_on()==0)
         print_cur_stat();
         break;
       case '4':
@@ -788,6 +787,7 @@
         break;
       case 'A':
         thisuser.sysstatus ^= sysstatus_extra_color;
+        if (menu_on()==0)
         print_cur_stat();
         break;
       case 'B':
@@ -796,6 +796,7 @@
       case 'C':
         thisuser.sysstatus ^= sysstatus_conference;
         changedsl();
+        if (menu_on()==0)
         print_cur_stat();
         break;
       case 'W':
@@ -815,14 +816,12 @@
         }
         break;
       case 'R':
-        if (rip) {
           thisuser.sysstatus &= ~sysstatus_disable_rip;
           nl();
           prt(5, get_string(1496));
           if (!yn()) {
             thisuser.sysstatus |= sysstatus_disable_rip;
             rip_cls();
-          }
         }
         break;
     }
diff -ub 424/EXTRN1.C 424a/EXTRN1.C
--- 424/EXTRN1.C	Sat May 06 12:46:06 1995
+++ 424a/EXTRN1.C	Sat Jun 17 08:15:32 1995
@@ -215,7 +215,14 @@
 
   /* make shrink files, if needed */
   if (eflags & EFLAG_FILES) {
+    if (eflags & EFLAG_NOPAUSE) {
+      osysstatus=thisuser.sysstatus;
+      thisuser.sysstatus &= ~sysstatus_pause_on_page;
     save_state(0, eflags&EFLAG_ABORT, restorefn, statfn);
+      thisuser.sysstatus=osysstatus;
+    } else {
+      save_state(0, eflags&EFLAG_ABORT, restorefn, statfn);
+    }
   }
 
   /* extra processing for net programs */
diff -ub 424/LILO.C 424a/LILO.C
--- 424/LILO.C	Fri May 12 09:31:36 1995
+++ 424a/LILO.C	Sun Jun 25 08:02:36 1995
@@ -70,6 +70,8 @@
   long l;
   FILE *f;
 
+  write_inst(INST_LOC_GETUSER, 0, INST_FLAGS_NONE);
+
   net_only=1;
   if (syscfg.netlowtime!=syscfg.nethightime) {
     if (syscfg.nethightime>syscfg.netlowtime) {
@@ -138,9 +140,9 @@
 
       outstr(get_string(356));
       if (rip) {
-        if (rip_subset) {
+        if (rip_subset || (count>0)) {
           printmenu(353);
-          pl("[30;47m");
+          pl("\x1b[30;47m");
         } else {
           sprintf(s,"\1|1\x1b""0000$%s_ID$^m|#\r ", sysinfo.ripbbsid);
           comstr(s);
@@ -156,7 +158,7 @@
       }
 
       input(s,30);
-      if (rip && rip_subset) {
+      if (rip && (rip_subset || (count>0))) {
         rip_rtwpcb();
         comstr("\x1b[37;40m");
         comnl(get_string(1435));
@@ -169,8 +171,10 @@
 #endif
 
 	usernum=finduser(s);
-	if ((net_only) && (usernum!=-2))
+        if (net_only && (usernum!=-2)) {
+          if ((usernum!=-4) || (strcmp(s,"DNM")))
 	  usernum=0;
+        }
 	if (usernum>0) {
 	  read_user(usernum,&thisuser);
 	  read_qscn(usernum,qsc,0);
@@ -233,9 +237,9 @@
 		  } 
 		  echo=0;
 		  input(s2,4);
-                  if (rip_on() && rip_subset) {
+                  if (rip_on() && (rip_subset || (count>0))) {
 			rip_rtwpcb();
-			comstr("[37;40m");
+                        comstr("\x1b[37;40m");
 			comnl(get_string(1437));     //ripstring(3));
 		  }
 #ifdef RIPDRIVE
diff -ub 424/MENUSLCL.MSG 424a/MENUSLCL.MSG
--- 424/MENUSLCL.MSG	Fri Mar 03 17:04:04 1995
+++ 424a/MENUSLCL.MSG	Sat May 20 14:25:24 1995
@@ -8,6 +8,9 @@
 !|#
 `335==========================================================================
 !|#
+`336==========================================================================
+!|10000((*Your Choice:::N@_N_o,Y@_Y_es))
+!|#
 `350==========================================================================
 !|*|c00|S0107|1B00000000LC0100000B01090000000B000000|1U0101HQ0S0000
 !|1B00000000LC0100000F080700000007000000|1U030XHO9M0000
diff -ub 424/MENUSSOF.MSG 424a/MENUSSOF.MSG
--- 424/MENUSSOF.MSG	Fri Mar 17 19:20:22 1995
+++ 424a/MENUSSOF.MSG	Sat May 20 14:32:18 1995
@@ -306,23 +306,27 @@
 `330==========================================================================
 !|c00|S0107|1B00000000LC0100000B090300000007000000
 !|1UD09BHR9P0000|1B00000202ZM01080F0F080700000807000000|Y00000100
-!|1UG09CGP9N3D00<>Yes<>Y|1UGU9CHG9N3200<>No<>N|c09|@D39EYour Choice:|#|#|#
+!|1UG09CGP9N2H20<>Yes<>Y|1UGU9CHG9N2600<>No<>N|c09|@D39EYour Choice:|#|#|#
 `331==========================================================================
 !|c00|S0107|1B00000000LC0100000B090300000007000000
 !|1UC09BHR9P0000|1B00000202ZM01080F0F080700000807000000|Y00000100
-!|1UG09CGP9N3D00<>Yes<>Y|1UGU9CHG9N3200<>No<>N
+!|1UG09CGP9N2H20<>Yes<>Y|1UGU9CHG9N2600<>No<>N
 !|1B00000202ZQ010F040F08040000040C000000
-!|1UEV9CFU9N3500<>Quit<>Q|c09|@C39EYour Choice:|#|#|#
+!|1UEV9CFU9N2900<>Quit<>Q|c09|@C39EYour Choice:|#|#|#
 `332==========================================================================
 !|c00|S0107|1B00000000LC0100000B090300000007000000
 !|1UF29BHR9P0000|1B00000202ZM01080F0F080700000807000000|Y00000100
-!|1UF59CHO9N0000<>Continue<>C|#|#|#
+!|1UF59CHO9N1V00<>Continue<>C|#|#|#
 `333==========================================================================
 !|1K|c00|S0100|BBZ9AHS9Q|#|#|#
 `334==========================================================================
 !|1K|*|c07|W00|=00000001|w000B271610|#
 `335==========================================================================
 !|1K|c00|S0100|BBZ9AHS9Q|#|#|#
+`336==========================================================================
+!|c00|S0107|1B00000000LC0100000B090300000007000000
+!|1UD09BHR9P0000|1B00000202ZM01080F0F080700000807000000|Y00000100
+!|1UG09CGP9N2620<>No<>N|1UGU9CHG9N2H00<>Yes<>Y|c09|@D39EYour Choice:|#|#|#
 `340==========================================================================
 !|10000$ETW$^M|#
 `351==========================================================================
diff -ub 424/MINIESM.C 424a/MINIESM.C
--- 424/MINIESM.C	Tue Apr 25 19:34:12 1995
+++ 424a/MINIESM.C	Tue Jul 11 18:53:14 1995
@@ -109,11 +109,12 @@
 
 /****************************************************************************/
 
-void descr_str(FILE *f, char *s)
+void descr_str(FILE *f, unsigned char *s)
 {
   putc('\"', f);
   for (; *s; s++) {
-    if ((*s>=' ') && (*s<='~')) {
+    /* if ((*s>=' ') && (*s<='~')) { */
+    if (*s>=' ') {
       if ((*s=='"') || (*s=='\\'))
         putc('\\', f);
       putc(*s, f);
diff -ub 424/MISCCMD.C 424a/MISCCMD.C
--- 424/MISCCMD.C	Fri May 12 16:18:46 1995
+++ 424a/MISCCMD.C	Fri Jul 21 17:18:34 1995
@@ -579,9 +579,11 @@
     }
   }
   pla(s1,&abort);
-  if (abort)
+  if (abort) {
     if (num>0)
       num--;
+    nln(2);
+  }
   npr("1%d 2%s.\r\n",num,(num==1) ? get_string(1630) : get_string(1631));
 }
 
diff -ub 424/MMENU.C 424a/MMENU.C
--- 424/MMENU.C	Sat May 27 05:01:46 1995
+++ 424a/MMENU.C	Thu Jul 27 06:49:10 1995
@@ -224,14 +224,23 @@
       if (checkpw()) {
         write_inst(INST_LOC_DOS,0,INST_FLAGS_NONE);
         sysoplog(get_stringx(1,6));
+#ifdef RIPDRIVE
+        if (rd_on())
+          localrip_deactivate();
+#endif
         extern_prog(getenv("COMSPEC"), EFLAG_SHRINK|EFLAG_COMIO|EFLAG_ABORT);
+#ifdef RIPDRIVE
+        if (rd_on())
+          localrip_deactivate();
+#endif
+        topscreen();
       }
     }
     if ((strcmp(s,"EDIT")==0)) {
       if (checkpw()) {
         write_inst(INST_LOC_TEDIT,0,INST_FLAGS_NONE);
         nl();
-        prt(2,get_string(7));
+        prt(2,get_string(44));
         input(s1,50);
         if (s1[0]) {
           if ((okansi()) && (thisuser.defed))
@@ -248,7 +257,7 @@
     }
     if (strcmp(s,"LOAD")==0) {
       nl();
-      prt(2,get_string(7));
+      prt(2,get_string(44));
       input(s1,50);
       if (s1[0]) {
         nl();
@@ -306,7 +315,7 @@
                  syscfg.qscn_len - 4*(1+((max_dirs+31)/32)+((max_subs+31)/32)));
           write_qscn(i, qsc, 1);
         }
-        read_qscn(1, qsc, 0);
+        read_qscn(usernum, qsc, 0);
         close_qscn();
       }
     }
@@ -467,12 +476,12 @@
       outstr(get_string(1324));
       if (ny())
         batchdl(1);
-      else
         hangup=1;
     } else
       hangup=1;
   }
-  if (strcmp(s,"/R")==0) {
+  if ((strcmp(s,"/R")==0) && (sysinfo.flags & OP_FLAGS_RIP_SUPPORT)) {
+    thisuser.sysstatus &= ~sysstatus_disable_rip;
     if (using_modem) {
       rip = rip_check();
       if (rip_on()) {
@@ -492,10 +501,6 @@
             && !(thisuser.sysstatus & sysstatus_disable_rip)) {
           if (rip_on()==0)
             localrip_activate(sysinfo.ripdir, sysinfo.ripdir);
-          strcpy(sysinfo.ripdir,languagedir);
-          pos = strlen(sysinfo.ripdir) - 2;
-          while ((sysinfo.ripdir[--pos] != '\\') && pos >= 0);  /* Find first \ */
-          sysinfo.ripdir[++pos] = 0;
           strcat(sysinfo.ripdir, "RIPMENUS\\");
           rip = -1;
           ripdrive = -1;
@@ -984,7 +989,7 @@
   if (strcmp(s,"/A")==0) {
     nl();
     ac=0;
-    if ((uconfsub[1].confnum!=-1) && (okconf(&thisuser))) {
+    if ((uconfdir[1].confnum!=-1) && (okconf(&thisuser))) {
       ac=1;
       tmp_disable_conf(1);
     }
@@ -1013,7 +1018,6 @@
       outstr(get_string(1324));
       if (ny())
         batchdl(1);
-      else
         hangup=1;
     } else
       hangup=1;
@@ -1108,7 +1112,7 @@
       ch=onek("Q12");
       nl();
       if (ch!='Q') {
-        outstr(get_string(7));
+        outstr(get_string(44));
         inputl(s2,80);
         switch(ch) {
           case '1': i2=2; break;
@@ -1134,7 +1138,15 @@
     if (strcmp(s,"DOS")==0) {
       if (checkpw()) {
         sysoplog(get_stringx(1,6));
+#ifdef RIPDRIVE
+        if (rd_on())
+          localrip_deactivate();
+#endif
         extern_prog(getenv("COMSPEC"), EFLAG_SHRINK|EFLAG_COMIO|EFLAG_ABORT);
+#ifdef RIPDRIVE
+        if (rd_on())
+          localrip_deactivate();
+#endif
         topscreen();
       }
     }
diff -ub 424/MODEM.C 424a/MODEM.C
--- 424/MODEM.C	Tue Apr 25 19:34:08 1995
+++ 424a/MODEM.C	Tue Jul 25 17:14:06 1995
@@ -226,11 +226,17 @@
     initport(syscfgovr.primaryport);
     pr1(is);
     dump();
-    if (mode_switch(5.0,0)==mode_norm) {
+    if (mode_switch(3.0,0)==mode_norm) {
       done=1;
     } else {
       ++i;
-      sprintf(s,"(%d)...",modem_mode);
+      switch(modem_mode) {
+      case 0: strcpy(s, "(No Response)..."); break;
+      case mode_ring: strcpy(s, "(Ring)..."); break;
+      case mode_dis: strcpy(s, "(Disconnect)..."); break;
+      case mode_err: strcpy(s, "(Error)..."); break;
+      default: sprintf(s,"(%d)...",modem_mode); break;
+      }
       outs(s);
     }
     if (i>5)
diff -ub 424/MSGBASE.C 424a/MSGBASE.C
--- 424/MSGBASE.C	Sun May 14 12:01:16 1995
+++ 424a/MSGBASE.C	Fri Jul 14 18:25:58 1995
@@ -567,6 +567,7 @@
      else {
        sprintf(s,"%sEDIT%d.RIP",languagedir,thisuser.defed);
        ripcode = 1;
+       if (exist(s))
        maybeprint(s,2);
        ripcode = 0;
      }
@@ -881,6 +882,8 @@
     if (fsed) {
       i5=sh_open1(fnx,O_RDONLY | O_BINARY);
       l1=filelength(i5);
+      if (l1>32760)
+        l1=32760;
     } else {
       l1=0;
       for (i5=0; i5<curli; i5++) {
@@ -938,7 +941,7 @@
         sprintf(s,"%s%s", get_string(1509), irt_sub);
         addline(b,s,&l1);
       }
-      if (irt_name[0]) {
+      if (irt_name[0] && strcmp(aux, "EMAIL")) {
         sprintf(s,"%s%s",get_string(941),irt_name);
         addline(b,s,&l1);
       }
@@ -1134,7 +1137,7 @@
   mailrec m,m1;
   net_header_rec nh;
   int f,len,i,i1;
-  char *b,*b1,s[256],s2[200],s1[200];
+  char *b,*b1,s[256],s1[200];
   long len1;
   userrec ur;
 
@@ -1237,7 +1240,6 @@
     bbsfree(b);
     bbsfree(b1);
   }
-  s2[0]=0;
   strcpy(s,get_string(647));
   if (sy==0) {
     read_user(un,&ur);
@@ -1260,14 +1262,14 @@
   } else {
     if (net_num_max>1) {
       if (un==0)
-        sprintf(s1,"%s %s @%u",net_name, net_email_name,sy);
+        sprintf(s1,"%s @%u.%s",net_email_name, sy, net_name);
       else
-        sprintf(s1,"%s %u @%u",net_name, un,sy);
+        sprintf(s1,"#%u @%u.%s", un, sy, net_name);
     } else {
       if (un==0)
         sprintf(s1,"%s @%u",net_email_name,sy);
       else
-        sprintf(s1,"%u @%u",un,sy);
+        sprintf(s1,"#%u @%u",un,sy);
     }
     strcat(s,s1);
     sysoplog(s);
@@ -1291,8 +1293,6 @@
   if (!wfc)
     topscreen();
   pl(s);
-  if (s2[0])
-    pl(s2);
 }
 
 
@@ -1409,14 +1409,14 @@
   } else {
     if (net_num_max>1) {
       if (un==0)
-        sprintf(s2,"%s %s @%u",net_name, net_email_name,sy);
+        sprintf(s2,"%s @%u.%s", net_email_name, sy, net_name);
       else
-        sprintf(s2,"%s %u @%u",net_name, un,sy);
+        sprintf(s2,"#%u @%u.%s", un, sy, net_name);
     } else {
       if (un==0)
         sprintf(s2,"%s @%u",net_email_name,sy);
       else
-        sprintf(s2,"%u @%u",un,sy);
+        sprintf(s2,"#%u @%u",un,sy);
     }
   }
   outstr(get_string(653));
@@ -1677,6 +1677,9 @@
   } else {
     g_flags &= ~g_flag_disable_mci;
   }
+#ifdef RIPDRIVE
+  rd_coff();
+#endif
   nl();
   p=0;
   p1=0;
@@ -1863,6 +1866,9 @@
   if ((ansi) && (topdata) && (useron))
     topscreen();
   g_flags &= ~g_flag_disable_mci;
+#ifdef RIPDRIVE
+  rd_con();
+#endif
 }
 
 
diff -ub 424/MSGBASE1.C 424a/MSGBASE1.C
--- 424/MSGBASE1.C	Wed May 17 06:43:16 1995
+++ 424a/MSGBASE1.C	Sat Jul 15 10:02:56 1995
@@ -772,7 +772,7 @@
                 if (!so())
                   break;
                 nl();
-                prt(2,get_string(7));
+                prt(2,get_string(44));
                 input(s,50);
                 if (s[0]) {
                   nl();
diff -ub 424/MULTINST.C 424a/MULTINST.C
--- 424/MULTINST.C	Sun May 21 16:59:48 1995
+++ 424a/MULTINST.C	Sun Jun 25 07:42:58 1995
@@ -213,6 +213,9 @@
     case INST_LOC_QWK:
       sprintf(s1,"%-25.25s",get_string(1639));
       break;
+    case INST_LOC_GETUSER:
+      sprintf(s1,"%-25.25s",get_string(1640));
+      break;
     case INST_LOC_WFC:
       sprintf(s1,"%-25.25s",get_string(1402));
       break;
diff -ub 424/NETSUP.C 424a/NETSUP.C
--- 424/NETSUP.C	Sun May 21 06:41:02 1995
+++ 424a/NETSUP.C	Wed Jun 28 05:48:38 1995
@@ -1037,12 +1037,21 @@
         if ((on[0]==0) && (nh->fromuser==0)) {
           strcpy(on,nm+i);
         }
+        if (status.net_version>=35) {
+          if (on[0])
+            sprintf(newname, "%s%s@%u.%s\r\n", qn, on, nh->fromsys,
+                    net_networks[fnn].name);
+          else
+            sprintf(newname, "%s#%u@%u.%s\r\n", qn, nh->fromuser, nh->fromsys,
+                    net_networks[fnn].name);
+        } else {
         if (on[0])
           sprintf(newname,"%s%s %s AT %u\r\n",qn, net_networks[fnn].name,
                   on, nh->fromsys);
         else
           sprintf(newname,"%s%s #%u AT %u\r\n",qn, net_networks[fnn].name,
                   nh->fromuser, nh->fromsys);
+        }
 
         nh->fromsys=net_networks[nn].sysnum;
         nh->fromuser=0;
diff -ub 424/NEWUSER.C 424a/NEWUSER.C
--- 424/NEWUSER.C	Sat May 06 07:52:08 1995
+++ 424a/NEWUSER.C	Sat Jul 01 06:53:08 1995
@@ -1064,11 +1064,13 @@
   char s[81];
   userrec u;
 
+  if (phone[0]) {
   npr(get_string(1524));
   for (i=0;i<status.users;i++) {
     if ((i % 10)==0)
       outstr("3.0");
     read_user(i,&u);
+      if (!(u.inact & inact_deleted)) {
     if ((strcmp(phone,u.phone)==0) || (strcmp(phone,u.dataphone)==0)) {
       if ((i!=usernum) && (strcmp(thisuser.name,u.name)!=0)
         && (u.inact & inact_deleted)) {
@@ -1079,6 +1081,8 @@
         sl1(0,s);
         ssm(1,0,s);
         dupe=1;
+          }
+        }
       }
     }
   }
diff -ub 424/QWK.C 424a/QWK.C
--- 424/QWK.C	Fri May 12 16:27:40 1995
+++ 424a/QWK.C	Wed Jul 12 07:08:20 1995
@@ -1007,7 +1007,7 @@
   qwk_percent=0.0;
   qwk_bi_mode=0;
 
-  while(!done)
+  while(!done && !hangup)
   {
     if (rip_on()) {
       if (so())
@@ -1647,7 +1647,7 @@
         qwk_info->abort=1;
     }
   }
-  else while(!done)
+  else while(!done && !hangup)
   {
     char new_dir[61];
     char nfile[81];
diff -ub 424/QWK1.C 424a/QWK1.C
--- 424/QWK1.C	Sat May 27 05:06:40 1995
+++ 424a/QWK1.C	Wed Jul 12 07:07:20 1995
@@ -550,9 +550,9 @@
       if (net_num_max>1)
       {
         if (un==0)
-          sprintf(s2,"%s %s @%u",net_name, net_email_name,sy);
+          sprintf(s2,"%s @%u.%s",net_email_name,sy, net_name);
         else
-          sprintf(s2,"%s %u @%u",net_name, un,sy);
+          sprintf(s2,"%u @%u.%s", un, sy, net_name);
       }
       else
       {
@@ -825,14 +825,14 @@
   char user_name[101];
 
 
-  while(!done)
+  while(!done && !hangup)
   {
     if(pass>0)
     {
       int done5=0;
       char substr[5];
 
-      while(!done5)
+      while(!done5 && !hangup)
       {
         nl();
         outstr(get_string(1570));
@@ -862,7 +862,7 @@
     cursub=sub;
 
     // Busy files... allow to retry
-    while(1)
+    while(!hangup)
     {
       if (!qwk_iscan_literal(cursub))
       {
@@ -979,7 +979,7 @@
   {
     char s[201];
 
-    while(1)
+    while(!hangup)
     {
       f=qwk_iscan_literal(curlsub);
 
@@ -1216,7 +1216,7 @@
   int x, abort=0, key, done=0;
   char s[101], t[101];
 
-  while(!done)
+  while(!done && !hangup)
   {
     nl();
     outstr(get_string(1586));
@@ -1283,7 +1283,7 @@
       case '?':
         abort=0;
         x=0;
-        while(x<qwk_cfg->amount_blts && !abort)
+        while(x<qwk_cfg->amount_blts && !abort && !hangup)
         {
           npr("[%d] %s %s", x+1, qwk_cfg->bltname[x], get_string(1592));
           nl();
@@ -1305,7 +1305,7 @@
   int done=0, key;
 
 
-  while(!done)
+  while(!done && !hangup)
   {
     npr(get_string(1593));
     npr(qwk_current_text(0, text));
@@ -1427,7 +1427,7 @@
   int done=0, key;
 
 
-  while(!done)
+  while(!done && !hangup)
   {
     printmenu(367);
 


diff -ub 424/READ.ME 424a/READ.ME
--- 424/READ.ME	Sun May 21 12:53:18 1995
+++ 424a/READ.ME	Mon Jul 31 06:28:20 1995
@@ -127,7 +127,7 @@
 The authorized source distribution systems are:
 
 Node #  Name                    Phone #         Modem type              State
-1       Amber                   310-798-9993    28.8+HST                CA
+1       Amber                    310-798-9993    33.6+HST                CA
                                 310-798-8283    14.4+HST
 4       Caesar's Palace         805-494-3003    14.4+HST                CA
 1250    The Clone Builder BBS   619-728-0541    28.8+HST    (2 lines)   CA
@@ -138,11 +138,16 @@
 4020    The Dragon's Den II     210-631-9417    28.8+HST                TX
 4051    Sam's BBS               409-729-1319    28.8                    TX
                                 409-729-1418    28.8(V.fc)
+4190    Adventurer's Corner OS/2 309-664-0881    33.6+HST                IN
 4340    The Resource Center     812-877-4342    28.8+HST                IN
 5150    Murphy's Law            910-649-7004    28.8                    NC
 6000    The Funny Farm (East)   704-553-8090    28.8+HST                NC
 6050    The Sandbox ][          704-480-0456    28.8+HST                NC
+6100    The Trading Post [SOUTH] 803-731-0690    28.8+HST                SC
+8213    Eagle's Dare             301-498-1984    28.8                    MD
 8412    Colossus                703-532-1438    14.4                    VA
+9200    The Bear's Cave          508-795-7672    28.8                    MA
+                                 508-791-8437    14.4
 11000   Maxie's Toy             209-526-5899    14.4                    CA
 11314   Erana's Peace           303-755-1884    28.8+HST                CO
 12170   Paragon                 716-592-5910    28.8+HST                NY
@@ -150,10 +155,15 @@
 20358   Permanent Vacation      514-487-7467    28.8                    QC-CAN
 20750   Purgatory BBS           306-665-0274    28.8                    SAS-CAN
 
-And in Japan (011-81):
+In Japan (011-81):
 
 4411    Blazing Inferno         611-733-1165    28.8+HST                Okinawa
                                 611-733-4807    28.8
+
+In Spain (011-34):
+
+15902   Zruspa's BBS             1-413-8423      28.8                    Spain
+                                 1-413-9290      28.8
 
 *************************************************************************
 
diff -ub 424/READMAIL.C 424a/READMAIL.C
--- 424/READMAIL.C	Tue Apr 25 19:33:52 1995
+++ 424a/READMAIL.C	Sat Jul 15 10:03:06 1995
@@ -428,6 +428,10 @@
 #endif
     helpl=10;
     pl(get_string(705));
+#ifdef RIPDRIVE
+    if (rd_on())
+      printf("\n\x1b[A");
+#endif
     outstr(":");
     input(s,3);
     if (strchr(s,'Q')!=NULL) {
@@ -473,9 +477,6 @@
       abort=0;
       i=((ability_read_email_anony & ss.ability)!=0);
       okmail=1;
-#ifdef RIPDRIVE
-      rd_coff();
-#endif
       pla(s,&abort);
       if ((m.fromsys) && (!m.fromuser))
         grab_user_name(&(m.msg),"EMAIL");
@@ -715,9 +716,9 @@
               if (sy) {
                 if (net_num_max>1) {
                   if (un) {
-                    sprintf(s1,"%s #%u @%u",net_name, un, sy);
+                    sprintf(s1,"#%u @%u.%s", un, sy, net_name);
                   } else {
-                    sprintf(s1,"%s %s @%u",net_name, net_email_name, sy);
+                    sprintf(s1,"%s @%u.%s",net_email_name, sy, net_name);
                   }
                 } else {
                   if (un) {
@@ -889,7 +890,7 @@
           if (!so())
             break;
           nl();
-          prt(2,get_string(7));
+          prt(2,get_string(44));
           input(s,50);
           if (s[0]) {
             nl();
diff -ub 424/RIPOVL.C 424a/RIPOVL.C
--- 424/RIPOVL.C	Sun May 14 11:58:00 1995
+++ 424a/RIPOVL.C	Thu Jul 13 06:06:42 1995
@@ -69,28 +69,25 @@
 
 				if (rip_ver == 15410)
 				  pl(get_string(1460));
-				else if (rip_ver == 15420)
+                                else if (rip_ver == 15420) {
 				  pl(get_string(1461));
-				else if (rip_ver == 15430) {
+                                  rip_subset = -1;
+                                  user_menus = 2;
+                                } else if (rip_ver == 15430) {
 				  pl(get_string(1609));
 				  rip_subset = -1;                        /* partial support */
 				  user_menus = 2;
-				} else if (rip_ver == 15400)
-				  pl(get_string(1462));
-				else if (rip_ver >= 20000) {
+                                } else if (rip_ver >= 20000) {
 				  pl(get_string(1610));
 				  strcpy(icon_extension,"BMP");
+                                } else { /* if (rip_ver == 15400) { */
+				  pl(get_string(1462));
+                                  rip_subset = -1;
+                                  user_menus = 2;
 				}
 			}
 		}
 
-		strcpy(sysinfo.ripdir,languagedir);
-		pos = strlen(sysinfo.ripdir) - 2;
-		while ((sysinfo.ripdir[--pos] != '\\') && pos >= 0);  /* Find first \ */
-		sysinfo.ripdir[++pos] = 0;
-		
-		//rip_ver = 15410;
-		strcat(sysinfo.ripdir, "RIPMENUS\\");
 #ifdef RIPDRIVE
 		if (ripdrive) {
 		  topdata = 0;
@@ -103,7 +100,7 @@
 		return (-1);
 	  }
   }
-  ripdrive = 0;
+  ripdrive=0;
   return (0);
 }
 
@@ -166,6 +163,7 @@
 			  delay(1);
 			  out_cport(4);
 			  out_cport(26);
+                          while (((ch = delaykey(5)) != 0) && (ch != 6) && (!hangup));
 			}
 			return 1;
 		}
@@ -219,6 +217,7 @@
 	  delay(1);
 	  out_cport(4);
 	  out_cport(26);
+          while (((ch = delaykey(5)) != 0) && (ch != 6) && (!hangup));
 
 	  if (iconflag)
 		return 2;
@@ -236,6 +235,7 @@
 		delay(1);
 		out_cport(4);
 		out_cport(26);
+                while (((ch = delaykey(5)) != 0) && (ch != 6) && (!hangup));
 	  }
 
 	  sprintf(f,"|1F000000ICLOSE.IC%c|#\r\r", menutype);
@@ -630,12 +630,13 @@
 
 	if (rip_subset)
 	  ch = '0';
-	else {
+        else if (using_modem) {
 	  sprintf(s, "|1F000000%s|#\r\r", f); /* Check for file on user's machine */
 	  comstr(s);
 	  ch = delaykey(2);
-	}
-	lines_listed = -50;
+        } else
+          ch=0;
+        tmp_disable_pause(1);
 	if (ch == '1') {                /* Exists on user's machine */
 	  sprintf(s, "|1R00000000%s\r\r", f);
 	  comstr(s);
@@ -643,7 +644,7 @@
 	  rip_show(f);
 	}
 	ripcode = 0;
-	lines_listed = 0;
+        tmp_disable_pause(0);
 
 	cleared = HYPCLEAR;     /* Signify hypertext image which may need cls */
 }
@@ -1160,6 +1161,7 @@
 {
   static char s[80];
 
+  s[0]=0;
   if (g_flags & g_flag_disable_mci)
     return("");
 
diff -ub 424/RIPSPEED.C 424a/RIPSPEED.C
--- 424/RIPSPEED.C	Sun Mar 19 15:48:22 1995
+++ 424a/RIPSPEED.C	Sun Jun 25 08:03:36 1995
@@ -68,26 +68,26 @@
    to the user's hard disk */
 void rip_saveall(void)
 {
-    comstr("\1|1\x1b""0000$SAVEALL$\r");
+    comr("\1|1\x1b""0000$SAVEALL$");
 }
 
 /* Function: restore the screen, mouse field, and clipboard info to the user's
    screen */
 void rip_restoreall(void)
 {
-    comstr("\1|1\x1b""0000$RESTOREALL$\r ");
+    comr("\1|1\x1b""0000$RESTOREALL$");
 }
 
 /* Function: paste whatever was captured to the clipboard back in place */
 void rip_pcb(void)
 {
-    comstr("\1|1\x1b""0000$PCB$\r ");
+    comr("\1|1\x1b""0000$PCB$");
 }
 
 /* Function: cursor on */
 void rip_con(void)
 {
-    comstr("\1|1\x1b""0000$CON$|\r ");
+    comr("\1|1\x1b""0000$CON$|");
 }
 
 #ifdef RIPDRIVE
@@ -111,25 +111,25 @@
 /* Function: cursor off */
 void rip_coff(void)
 {
-    comstr("\1|1\x1b""0000$COFF$|\r ");
+    comr("\1|1\x1b""0000$COFF$|");
 }
 
 /* Function: save the mouse fields */
 void rip_smf(void)
 {
-    comstr("\1|1\x1b""0000$SMF$|\r ");
+    comr("\1|1\x1b""0000$SMF$|");
 }
 
 /* Function: restore mouse fields */
 void rip_rmf(void)
 {
-    comstr("\1|1\x1b""0000$RMF$|\r ");
+    comr("\1|1\x1b""0000$RMF$|");
 }
 
 /* Function: restore text window, and then paste clipboard */
 void rip_rtwpcb(void)
 {
-    comstr("\1|1\x1b""0000$RTW$$PCB$|#\r ");
+    comr("\1|1\x1b""0000$RTW$$PCB$|#");
 }
 
 /* Function:  show a file in the RIP directory. */
@@ -168,7 +168,7 @@
 void rip_cls(void)
 {
     if (rip_on())
-      comstr("\1|*\r ");
+      comr("\1|*");
 }
 
 void out_cport(char c)
@@ -227,6 +227,9 @@
 void comr(char *s)
 {
     comstr(s);
+    if (rip_ver >= 20000)
+      comstr("\r");
+    else
     comstr("\r ");
 }
 
@@ -250,6 +253,10 @@
   while (((time(&t2) - t1 <= tm)) && (!hangup)) {
     if ((c = inkey())!=0)
       break;
+    else {
+      checkhangup();
+      giveup_timeslice();
+    }
   }
   return c;
 }
diff -ub 424/SUBEDIT.C 424a/SUBEDIT.C
--- 424/SUBEDIT.C	Tue Apr 25 19:33:28 1995
+++ 424a/SUBEDIT.C	Tue Jul 11 19:00:18 1995
@@ -187,7 +187,7 @@
     outstr(get_string(62)); pl(r.name);
     outstr(get_string(63)); pl(r.filename);
     if (r.key==0)
-      strcpy(s,get_string(168));
+      strcpy(s,get_string(5));
     else {
       s[0]=r.key;
       s[1]=0;
diff -ub 424/SYSOPF.C 424a/SYSOPF.C
--- 424/SYSOPF.C	Fri May 12 10:09:50 1995
+++ 424a/SYSOPF.C	Sat Jul 22 09:19:06 1995
@@ -141,8 +141,7 @@
   if (!sysop2())
     outstr(get_string(112));
   pl(get_string(315));
-  if (num_instances() < 1)
-    return;
+  if (num_instances() > 1)
   multi_instance();
 }
 
@@ -588,8 +587,9 @@
     f=sh_close(f);
     if ((!abort) && (slist)) {
       nl();
-      npr("%s%d\r\n",get_string(1306),slist);
+      npr("%s%d",get_string(1306),slist);
     }
+    nln(2);
     pausescr();
   }
   if (tp)
@@ -607,7 +607,7 @@
     zap_call_out_list();
     zap_contacts();
   }
-  set_language(0);
+  set_language_1(cur_lang);
 }
 
 
diff -ub 424/UEDIT.C 424a/UEDIT.C
--- 424/UEDIT.C	Tue Apr 25 19:33:20 1995
+++ 424a/UEDIT.C	Sun Jun 25 07:45:50 1995
@@ -485,11 +485,14 @@
           }
           break;
         case 'G':
+          prt(5,get_string(1642));
+          if (yn()) {
           nl();
           outstr(get_string(274));
           npr("%02d/%02d/%02d\r\n",(int) u.month, (int) u.day, (int) u.year);
           input_age(&u);
           write_user(un,&u);
+          }
           break;
         case 'I':
           nl();
diff -ub 424/VARDEC.H 424a/VARDEC.H
--- 424/VARDEC.H	Sat May 20 13:33:26 1995
+++ 424a/VARDEC.H	Sun Jun 25 07:41:04 1995
@@ -97,6 +97,7 @@
 #define INST_LOC_NETLIST      45
 #define INST_LOC_TERM         46
 #define INST_LOC_QWK          47
+#define INST_LOC_GETUSER      48
 #define INST_LOC_WFC       65535
 
 /* DATA FOR EVERY USER */
diff -ub 424/VERSION.C 424a/VERSION.C
--- 424/VERSION.C	Sat May 27 08:08:58 1995
+++ 424a/VERSION.C	Fri Jul 14 08:40:40 1995
@@ -13,7 +13,7 @@
 *****************************************************************************/
 
 
-char *wwiv_version = "WWIV v4.24";
+char *wwiv_version = "WWIV v4.24a";
 
 unsigned int wwiv_num_version=424;
 
diff -ub 424/WWIV.INI 424a/WWIV.INI
--- 424/WWIV.INI	Wed Apr 19 06:52:20 1995
+++ 424a/WWIV.INI	Sun Jun 25 07:52:26 1995
@@ -127,9 +127,13 @@
 RIP_MENU_DATE  = 03/03/95
 ; If pull-down menus don't align properly, adjust this offset:
 RIP_ADJUST     = 0
+; Path to RIP data files
+RIP_DIR        = RIPMENUS
 
 ;
 ; System flags
+; Un-comment out lines (remove leading semicolon) and set
+; to Y or N for Yes or No
 ;
 ;FORCE_FBACK            =               ; force newusers to send fback
 ;CHECK_DUP_PHONES       =               ; check newuser dupe phones
diff -ub 424/XFER.C 424a/XFER.C
--- 424/XFER.C	Fri May 12 09:52:50 1995
+++ 424a/XFER.C	Sun Jul 16 13:12:40 1995
@@ -867,7 +867,7 @@
       npr("%s%s\r\n",ss,get_string(1311));
     else
       npr("%s%s\r\n",ss,get_string(1312));
-  } else {
+  } else if (lines_listed) {
     if ((titled!=2) && (tagging == 1)
       && !(thisuser.sysstatus & sysstatus_no_tag)) {
       if (okansi())
diff -ub 424/XFEROVL.C 424a/XFEROVL.C
--- 424/XFEROVL.C	Tue Apr 25 19:33:06 1995
+++ 424a/XFEROVL.C	Sat Jul 15 07:39:38 1995
@@ -575,13 +575,13 @@
             do {
               desc++;
             } while ((*desc==' ') || (*desc=='\t'));
+          }
             fn1=strchr(desc,'\n');
             if (fn1)
               *fn1=0;
             strcat(ext, desc);
             strcat(ext,"\r\n");
           }
-        }
       } else {
         ok1=0;
         fn1=strtok(s," \t\n");
@@ -678,7 +678,7 @@
 {
   char s[85],s1[40],s2[81];
   int i,i1,next,abort=0,fc;
-  int tcd=-1, otag;
+  int tcd=-1, otag, tcdi;
 
   if (!filelist)
     return;
@@ -690,7 +690,7 @@
   if (sysinfo.flags & OP_FLAGS_FAST_TAG_RELIST) {
     ansic(fc ? FRAME : 0);
     if (okansi())
-      pl(get_string(1354));
+      pl(get_string(1317));
     else
       pl(get_string(1355));
   }
@@ -700,14 +700,24 @@
         ansic(fc ? FRAME : 0);
         if (tcd!=-1) {
           if (okansi())
-            npr("\r%s\r\n",get_string(1356));
+            npr("\r%s\r\n",get_string(1313));
           else
             npr("\r%s\r\n",get_string(1357));
         }
         tcd=filelist[i].directory;
+        tcdi=-1;
+        for (i1=0; i1<num_dirs; i1++) {
+          if (udir[i1].subnum==tcd) {
+            tcdi=i1;
+            break;
+          }
+        }
         if (fc)
           ansic(2);
-        npr("%s - #%s.\r\n",directories[tcd].name,udir[tcd].keys);
+        if (tcdi==-1)
+          npr("%s.\r\n", directories[tcd].name);
+        else
+          npr("%s - #%s.\r\n",directories[tcd].name,udir[tcdi].keys);
         ansic(fc ? FRAME : 0);
         if (okansi())
           npr("%s\r\n",get_string(1317));
@@ -771,7 +781,7 @@
   }
   ansic(fc ? FRAME : 0);
   if (okansi())
-    npr("\r%s\r\n",get_string(1356));
+    npr("\r%s\r\n",get_string(1313));
   else
     npr("\r%s\r\n",get_string(1357));
   tagging=otag;
@@ -1027,7 +1037,7 @@
       abort=0;
       strcpy(s1," ");
       nl();
-      pl(get_string(1358));
+      pl(get_string(1081));
       nl();
       i=0;
       while ((i<dirconfnum) && (uconfdir[i].confnum!=-1) && (!abort)) {
diff -ub 424/XFEROVL2.C 424a/XFEROVL2.C
--- 424/XFEROVL2.C	Fri May 12 09:53:34 1995
+++ 424a/XFEROVL2.C	Sat Jul 15 10:02:10 1995
@@ -140,7 +140,7 @@
           strcat(*sss,s1);
           i4 += strlen(s1);
         }
-      } while ((i++<10) && (s1[0]));
+      } while ((i++<sysinfo.max_extend_lines) && (s1[0]));
       thisuser.screenchars=i1;
       if (*sss[0]==0) {
         bbsfree(*sss);
@@ -724,7 +724,7 @@
 
 void tag_files(void)
 {
-  int i, i1, done=0, abort, had, oh, fc, ohl;
+  int i, i1, i2, done=0, abort, had, oh, fc, ohl;
   char s[161],s1[161],s2[81],ch;
   double d;
 
@@ -744,7 +744,7 @@
       pausescr();
     ansic(fc ? FRAME : 0);
     if (okansi())
-      npr("\r%s\r\n",get_string(1337));
+      npr("\r%s\r\n",get_string(1315));
     else
       npr("\r%s\r\n",get_string(1338));
     tagptr=0;
@@ -756,7 +756,7 @@
   lines_listed=0;
   ansic(fc ? FRAME : 0);
   if (okansi())
-    npr("\r%s\r\n",get_string(1339));
+    npr("\r%s\r\n",get_string(1313));
   else
     npr("\r%s\r\n",get_string(1340));
 
@@ -811,14 +811,25 @@
           d=XFER_TIME(filelist[i].u.numbytes);
           nl();
           if (menu_on()) {
-            i1 = rip_printfileinfo(&filelist[i].u,filelist[i].directory);
+            rip_printfileinfo(&filelist[i].u,filelist[i].directory);
             getkey();
             rip_restoreall();
           } else {
+	    for (i2=0; i2<num_dirs; i2++) {
+	      if (udir[i2].subnum==filelist[i].directory)
+		break;
+	    }
+	    if (i2<num_dirs) {
+	      npr("%s%s, %s\r\n",
+		  get_string(1343),
+		  udir[i2].keys,
+		  directories[filelist[i].directory].name);
+	    } else {
             npr("%s%s, %s\r\n",
               get_string(1343),
-              udir[filelist[i].directory].keys,
+		  "??",
               directories[filelist[i].directory].name);
+	    }
             ansic(1);
             outstr(get_string(746));
             ansic(2);
@@ -870,10 +881,10 @@
             }
             nl();
             pausescr();
-            tagging=i1;
             relist();
           }
         }
+        tagging=i1;
       break;
       case 'N':
         tagging=2;
@@ -1091,7 +1102,7 @@
     nl();
     pl(get_string(788));
     nl();
-    prt(2,get_string(44));
+    prt(2,get_string(7));
     input(s,12);
   }
   if (s[0]==0)
@@ -1185,12 +1196,12 @@
         if ((titled!=2) && (tagging==1)
           && !(thisuser.sysstatus & sysstatus_no_tag)) {
           if (okansi())
-            npr("\r%s\r\n",get_string(1348));
+            npr("\r%s\r\n",get_string(1313));
           else
             npr("\r%s\r\n",get_string(1349));
         } else {
           if (okansi())
-            npr("\r%s\r\n",get_string(1350));
+            npr("\r%s\r\n",get_string(1315));
           else
             npr("\r%s\r\n",get_string(1351));
         }
diff -ub 424/XINIT.C 424a/XINIT.C
--- 424/XINIT.C	Fri May 12 10:07:28 1995
+++ 424a/XINIT.C	Sun Jun 25 08:10:32 1995
@@ -250,6 +250,7 @@
 #define INI_STR_EXTENDED_USERINFO 69
 #define INI_STR_RIPDRIVE_ON       70
 #define INI_STR_MAX_EXTEND_LINES  71
+#define INI_STR_RIP_DIR           72
 
 static char *get_key_str(int n)
 {
@@ -379,7 +380,8 @@
   }
 
   /* put in default sysinfo.flags */
-  sysinfo.flags = OP_FLAGS_FIDO_PROCESS | OP_FLAGS_RIP_SUPPORT;
+  sysinfo.flags = OP_FLAGS_FIDO_PROCESS | OP_FLAGS_RIP_SUPPORT |
+                  OP_FLAGS_RIPDRIVE_ON;
 
   if (ok_modem_stuff)
     sysinfo.flags |= OP_FLAGS_NET_CALLOUT;
@@ -451,6 +453,10 @@
 
     set_string(INI_STR_RIP_BBS_ID, sysinfo.ripbbsid, sizeof(sysinfo.ripbbsid), 0);
     set_string(INI_STR_RIP_MENU_DATE, sysinfo.ripmenudate, sizeof(sysinfo.ripmenudate), 0);
+    strcpy(sysinfo.ripdir, "ripmenus\\");
+    set_string(INI_STR_RIP_DIR, sysinfo.ripdir, sizeof(sysinfo.ripdir), 0);
+    if (sysinfo.ripdir[strlen(sysinfo.ripdir)-1] != '\\')
+      strcat(sysinfo.ripdir, "\\");
     INI_INIT_N(INI_STR_RIP_ADJUST, rip_rm_adjust);
 
     /* pull out sysinfo flags */
@@ -458,7 +464,7 @@
                               NEL(sysinfo_flags), sysinfo.flags);
 
 
-    /* allow override of msg_color
+    /* allow override of msg_color */
     INI_INIT(INI_STR_MSG_COLOR,     msg_color);
 
     /* get asv values */
@@ -1045,7 +1051,8 @@
   strcpy(cdir,"X:\\");
   cdir[0]='A'+getdisk();
   getcurdir(0,&(cdir[3]));
-
+  if (cdir[3]==0)
+    cdir[2]=0;
 
 #ifdef EMS_XMS
   if (_OvrInitEms(0,0,16)!=0)

/****************************************************************************/

ENGLISH.STR CHANGES:

String #168:
FROM: "None"
TO  : ""

String #194:
FROM: "Which (A-O,Q) ? "
TO  : "Which (A-O,[,],Q) ? "

String #232:
FROM: "Allow auto sub info? "
TO  : "Make this sub public (in subs.lst)?"

String #676:
FROM: "\x030O\x031)verwrite, \x030A\x031)ppend, \x030N\x031)ew name, \x030Q\x031)uit? "
TO  : "\x030O\x031)verwrite, \x030A\x031)ppend, \x030N\x031)ew name, \x030Q\x031)uit? \x030"

String #1150:
FROM: "Select Conference: "
TO  : ""

String #1337:
FROM: ""
TO  : ""

String #1339:
FROM: ""
TO  : ""

String #1348:
FROM: ""
TO  : ""

String #1350:
FROM: ""
TO  : ""

String #1354:
FROM: ""
TO  : ""

String #1356:
FROM: ""
TO  : ""

String #1358:
FROM: "Select Conference:"
TO  : ""

Add string #1640: "Getting User ID"

Add string #1641: "RIPdrive enabled; use /R to activate"

Add string #1642: "Are you sure you want to re-enter the birthday?"

/****************************************************************************/

CHANGES TO INI.STR:

String #72:
FROM: ""
TO  : "RIP_DIR"

