#include "vars.h"
#pragma hdrstop

#include <conio.h>
#include <ctype.h>
#include <dir.h>
#include <signal.h>
#include <time.h>
#include <stdarg.h>
#include <errno.h>

#include "listplus.h"


// Few global variables

asylum_config config_listing;
int list_loaded;  // 1 through ? or -1 through ? for sysop defined choices


int extended_desc_used, lc_lines_used;
int ext_is_on;

struct listplus_config lp_config;

static char far _on_[]="ON!";
static char far _off_[] ="OFF";

int lp_config_loaded;

#ifdef FILE_POINTS
long fpts;
#endif


char *lp_color_list[] = { "Black   ",
                      "Blue    ",
                      "Green   ",
                      "Cyan    ",
                      "Red     ",
                      "Purple  ",
                      "Brown   ",
                      "L-Gray  ",
                      "D-Gray  ",
                      "L-Blue  ",
                      "L-Green ",
                      "L-Cyan  ",
                      "L-Red   ",
                      "L-Purple",
                      "Yellow  ",
                      "White   " };



void colorize_foundtext(char *text, struct search_record *search_rec, int color)
{
  int size, x;
  char *temp, found_color[10], normal_color[10], *tok;
  char find[101], word[101];

  sprintf(found_color, "|%02d|%02d", lp_config.found_fore_color, lp_config.found_back_color);
  sprintf(normal_color, "|16|%02d", color);



  if(lp_config.colorize_found_text)
  {
    strcpy(find, search_rec->search);
    tok = strtok(find, "&|!()");


    while(tok)
    {
      temp=text;
      strcpy(word, tok);
      strip_string(word);


      while(temp && word[0])
      {
        if((temp=strstr_nocase(temp, word))!=NULL)
        {
          // First move text over 6 places and insert 'found color'
          size=strlen(temp)+1;
          memmove(&temp[6], &temp[0], size);
          strncpy(temp, found_color, 6);

          // Now move to the end of the found text
          temp+=strlen(word)+6;
          size=strlen(temp)+1;

          // And move text over 6 places to make room for normal color
          memmove(&temp[6], &temp[0], size);
          strncpy(temp, normal_color, 6);

          temp+=6;    /* go past the color codes we just added */

          // Get off of this find so we can find the next match
          ++temp;
        }
      }
      tok = strtok(NULL, "&|!()");
    }
  }
}



void printtitle_plus(void)
{
  char s[81], *head;

  if(WhereY() != 0 || WhereX() != 0)
    CLS();

  npr_color("|16|15%s", charstr(79,''));
  nl();

  sprintf(s, "  [%-26.26s dir:%3d] (%d files) Space to tag - ?=Help  ",
                   stripcolors(directories[udir[curdir].subnum].name),
                   atoi(udir[curdir].keys), numf);
  justify_string(s, 79, ' ', JUSTIFY_LEFT);
  npr_color("|23|01%s", s);
  nl();

  if(config_listing.lp_options & cfl_header)
    build_header();

  npr_color("|16|08%s\r\n",charstr(79,''));
  ansic(0);
}




void build_header(void)
{
  char header[100];
  int desc_pos=30;

  strcpy(header, " Tag # ");

  if(config_listing.lp_options & cfl_fname)
    strcat(header, "Filename");

  if(config_listing.lp_options & cfl_extension)
    strcat(header, ".EXT ");

  if(config_listing.lp_options & cfl_dloads)
    strcat(header, " DL ");

  if(config_listing.lp_options & cfl_kbytes)
    strcat(header, "Bytes ");

#ifdef FILE_POINTS
  if(config_listing.lp_options & cfl_file_points)
    strcat(header, "Fpts ");
#endif

  if(config_listing.lp_options & cfl_days_old)
    strcat(header, "Old ");

  if(config_listing.lp_options & cfl_times_a_day_dloaded)
    strcat(header, "DL'PD ");

  if(config_listing.lp_options & cfl_days_between_dloads)
    strcat(header, "DBDLS ");


  if(config_listing.lp_options & cfl_description)
  {
    desc_pos = strlen(header);
    strcat(header, "Description");
  }

  justify_string(header, 79, ' ', JUSTIFY_LEFT);
  npr_color("|23|01%s",header);
  nl();

  header[0]=0;

  if(config_listing.lp_options & cfl_date_uploaded)
    strcat(header, "Date Uploaded      ");
  if(config_listing.lp_options & cfl_upby)
    strcat(header, "Who uploaded");

  if(header[0])
  {
    justify_string(header, desc_pos+strlen(header), ' ', JUSTIFY_RIGHT);
    justify_string(header, 79, ' ', JUSTIFY_LEFT);
    npr_color("|23|01%s",header);
    nl();
  }


}


int first_file_pos(void)
{
  int x;

  x = FIRST_FILE_POS;

  if(config_listing.lp_options & cfl_header)
    x += lp_configured_lines();

  return(x);
}

int lp_configured_lines(void)
{
  if(config_listing.lp_options & cfl_date_uploaded || config_listing.lp_options & cfl_upby)
    return 2;

  return 1;
}
  

void print_searching(void)
{
  static int pos=0;
  int amount = 4;
  char *searching="|/-\\";

  if(WhereY() !=0 || WhereX() !=0)
    CLS();

  ansic(2);

  outchr(searching[pos]);
  ++pos;
  if(pos >= amount)
    pos = 0;
}

void catch_divide_by_zero(int x)
{
  if(x!=x)  /* this is just to shut warnings up */
    x=x;
  sysoplog("Caught divide by 0");
}


int listfiles_plus(int type)
{
  int x;
  int save_topdata=topdata;
  int save_dir=curdir;
  long save_status=thisuser.sysstatus;
  extern int numlock;
  int save_numlock = NOTNUMBERS;


  helpl=800;
  tagging=0;

  ext_is_on = 1;            /* turn extended descriptions on */
  signal(SIGFPE, catch_divide_by_zero);


  // Turn off topscreen info for this mod
  topdata=0;
  topscreen();

  CLS();


  x = listfiles_plus_function(type);

#ifdef FAST_EXTENDED_DESCRIPTION
  lp_zap_ed_info();
#endif

  ansic(0);
  GOTO_XY(1, thisuser.screenlines-3);
  nln(3);


  lines_listed=0;

  tmp_disable_conf(0);
  thisuser.sysstatus = save_status;


  if(type == NSCAN_NSCAN || type == NSCAN_DIR)
    curdir = save_dir;
  dliscan();

  topdata=save_topdata;
  topscreen();

  numlock = save_numlock;
  return x;
}

int listfiles_plus_function(int type)
{
  uploadsrec (*file_recs)[1];
  int file_handle[51], lines, max_lines, lines_left;
  int save_first_file=0;
  char vert_pos[51];

  int first_file, amount;
  int file_pos=0, save_file_pos=0, menu_pos=0;
  int done=0, all_done=0, force_menu, needed;
  unsigned command;
  int redraw;

  int matches=0; // when a file passes the compare_criteria inc
  int had;

  int this_dir, also_this_dir;
  int scan_dir, save_dir = curdir;
  int changedir=0;

  int file=-1, sysop_mode=0;
  char **menu_items;
  
  struct side_menu_colors smc;
  struct search_record search_rec;




  load_lp_config();

  smc.normal_highlight  = lp_config.normal_highlight;
  smc.normal_menu_item  = lp_config.normal_menu_item;
  smc.current_highlight = lp_config.current_highlight;
  smc.current_menu_item = lp_config.current_menu_item;


  load_listing();        /* load configurable listing up */


  menu_items=(char **)alloc_2d(20, 15, sizeof(char));
  if(!menu_items)
    return 0;


  prep_menu_items(menu_items);


  (char *)file_recs=(char *)malloca((thisuser.screenlines+20)*sizeof(uploadsrec));
  if(!file_recs)
  {
    free_2d(menu_items);
    return 0;
  }


  if(!prep_search_rec(&search_rec, type))
  {
    bbsfree(file_recs);
    free_2d(menu_items);
    return 0;
  }


  max_lines = calc_max_lines();



  num_listed=0;
  for (this_dir=0; (this_dir<num_dirs) && (!hangup) && (udir[this_dir].subnum!=-1) && !all_done; this_dir++)
  {
    also_this_dir=udir[this_dir].subnum;
    scan_dir=0;

    checka(&all_done,&all_done);

    if(search_rec.alldirs==THIS_DIR)
    {
      if(this_dir==save_dir)
        scan_dir=1;
    }
    else // Either for NSCAN or all dirs
    {
      // This part checks to see if it is in the nscan
      if (qsc_n[also_this_dir/32]&(1L<<(also_this_dir%32)))
        scan_dir=1;

      // If we are searching all dirs, scan it..
      if(search_rec.alldirs==ALL_DIRS)
        scan_dir=1;


      // If we have a nscan date specified, lets check the file dates first...
      // and not even open it if it hasn't been changed
      if(search_rec.nscandate)
      {

        if ((dir_dates[udir[this_dir].subnum]) && (dir_dates[udir[this_dir].subnum]<nscandate))
        {
          scan_dir=0;

          curdir=this_dir;
          print_searching();
        }
      }
    }



    if(scan_dir)
    {
      curdir=this_dir;
      dliscan();


      num_listed=0;


      first_file=save_first_file=1;
      amount=0;
      done=0;
      matches=0;
      lines=0;


      while(!done && !hangup && !all_done)
      {
        if(!amount)
        {
          // Open files to read only while reading dir
          file=sh_open1(dlfn,O_RDONLY | O_BINARY);

          if(file < 1)
          {
            done=1;
            continue;
          }


          print_searching();
        }

        if(numf)
        {
          changedir=0;
          force_menu = 0;

          SETREC(file, first_file+amount);
          sh_read(file,(void *)file_recs[matches],sizeof(uploadsrec));



          if(compare_criteria(&search_rec, file_recs[matches]))
          {

            lines_left=max_lines-lines;

            /* Check to make sure we have enough room to print full description */
            needed = check_lines_needed(file_recs[matches]);

            if(needed <= lines_left)
            {
              int lines_used;

              if(!matches)
                printtitle_plus();

              file_handle[matches]=first_file+amount;


              vert_pos[matches]=lines;

              lines_used = printinfo_plus(file_recs[matches], file_handle[matches], check_batch_queue(file_recs[matches]->filename), lines_left, &search_rec);

#ifdef EXTRA_SPACE
              if(lines_used > 1 && lines_used < lines_left)
              {
                nl();
                ++lines_used;
              }
#endif

              lines+= lines_used;


              ++matches;  // Amount of files on screen
            }
            else
              force_menu=1;   /* Won't fit, force menu to show */
          }
          if(!force_menu)  /* only increment if we are not forcing the menu */
            ++amount;


          if((lines >=max_lines) || (numf < first_file+amount) || force_menu)
          {
            // Close it now, since we don't need it right now
            file=sh_close(file);

            if(matches)
            {
              int menu_done=0;

              file_pos=save_file_pos;
              drawfile(vert_pos[file_pos], file_handle[file_pos]);

              redraw=1;
              save_file_pos=0;

              while(!menu_done && !hangup)
              {
                command = side_menu(&menu_pos, redraw, menu_items, 2, max_lines+first_file_pos()+1, &smc);

                redraw=1;
                ansic(0);

                if(do_sysop_command(command))
                {
                  menu_done=1;
                  amount=lines=matches=0;
                  save_file_pos=file_pos;
                }



                if(command==COMMAND_PAGEUP)
                {
                  command=EXECUTE;
                  menu_pos=1;
                }
                if(command==COMMAND_PAGEDN)
                {
                  command=EXECUTE;
                  menu_pos=0;
                }

                switch(command)
                {
                  case CX:
                  case AX:
                    goto TOGGLE_EXTENDED;

                  case '?':
                  case CO:
                    CLS();
                    printfile("LISTPLUS.HLP");
                    pausescr();

                    menu_done=1;
                    amount=lines=matches=0;
                    save_file_pos=file_pos;
                    break;

                  case COMMAND_DOWN:
                    undrawfile(vert_pos[file_pos], file_handle[file_pos]);
                    ++file_pos;
                    if(file_pos>=matches)
                      file_pos=0;
                    drawfile(vert_pos[file_pos], file_handle[file_pos]);
                    redraw=0;
                    break;

                  case COMMAND_UP:
                    undrawfile(vert_pos[file_pos], file_handle[file_pos]);
                    if(!file_pos)
                      file_pos=matches-1;
                    else
                      --file_pos;
                    drawfile(vert_pos[file_pos], file_handle[file_pos]);
                    redraw=0;
                    break;


                  case SPACE: // Add or remove batch queue
                    goto ADD_OR_REMOVE_BATCH;

                  case EXECUTE:
                    switch(menu_pos)
                    {
                      case 0: // Next
                        save_first_file=first_file;
                        first_file+=amount;

                        if(first_file>numf)
                          done=1;

                        menu_done=1;
                        amount=lines=matches=0;
                        break;

                      case 1: // Prev
                        if(save_first_file>=first_file)
                        {
                          if(first_file>5)
                            first_file-=5;
                          else
                            first_file=1;
                        }
                        else
                          first_file=save_first_file;

                        menu_done=1;
                        amount=lines=matches=0;
                        break;

                      case 2: // TAG file
                        if(sysop_mode)
                        {
                          do_batch_sysop_command(SYSOP_DELETE, file_recs[file_pos]->filename);

                          menu_done=1;
                          save_file_pos=file_pos=0;
                          amount=lines=matches=0;
                        }
                        else
                        {

ADD_OR_REMOVE_BATCH:
#ifdef KBPERDAY
                          kbbatch+=bytes_to_k(file_recs[file_pos]->numbytes);
#endif
                          if(find_batch_queue(file_recs[file_pos]->filename) > -1)
                          {
                            remove_batch(file_recs[file_pos]->filename);
                            redraw=0;
                          }
#ifdef FILE_POINTS
                          else if(((!(file_recs[file_pos]->mask & mask_validated)) || ((file_recs[file_pos]->filepoints>thisuser.filepoints)) &&
                           (!(thisuser.exempt & exempt_ratio))) && !sysop_mode)
                          {

                            CLS();
                            pl("You don't have enough file points to download this file");
                            pl("Or this file is not validated yet.");
#else
                          else if(!ratio_ok() && !sysop_mode)
                          {
#endif
                            menu_done=1;
                            amount=lines=matches=0;
                            save_file_pos=file_pos;
                            pausescr();
                          }
                          else
                          {
                            char file[130];
                            redraw=0;

                            // If it is in the dir, check to make sure it exists
                            // before adding it, if it is on CD ROM, just add it
                            if (!(directories[udir[curdir].subnum].mask & mask_cdrom) && !sysop_mode)
                            {
                              strcpy(file, directories[udir[curdir].subnum].path);
                              strcat(file, file_recs[file_pos]->filename);
                              if(sysop_mode || !using_modem || exist(file))
                              {
#ifdef FILE_POINTS
                                fpts=0;
                                fpts=(file_recs[file_pos]->filepoints);
#endif
                                add_batch(file_recs[file_pos]->filename, udir[curdir].subnum, file_recs[file_pos]->numbytes);
                              }
                              else if(lp_config.request_file)
                              {
                                menu_done=1;
                                amount=lines=matches=0;
                                request_file(file_recs[file_pos]->filename);
                              }
                            }
                            else {
#ifdef FILE_POINTS
                              fpts=0;
                              fpts=(file_recs[file_pos]->filepoints);
#endif
                              add_batch(file_recs[file_pos]->filename, udir[curdir].subnum, file_recs[file_pos]->numbytes);
                            }
                          }


#ifdef KBPERDAY
                          kbbatch-=bytes_to_k(file_recs[file_pos]->numbytes);
#endif
                          GOTO_XY(1, first_file_pos()+vert_pos[file_pos]);
                          npr_color("|%2d %c ", lp_config.tagged_color, check_batch_queue(file_recs[file_pos]->filename) ? '':' ');
                        }
                        break;

                      case 3: // Info
                        if(!sysop_mode)
                        {
                          show_fileinfo(file_recs[file_pos]);
                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }
                        else
                        {
                          do_batch_sysop_command(SYSOP_RENAME, file_recs[file_pos]->filename);

                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }
                        menu_pos = 0;      // jump up to the 'next' option
                        break;


                      case 4: // View
                        if(!sysop_mode)
                        {
                          view_file(file_recs[file_pos]->filename);
                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }
                        else
                        {
                          do_batch_sysop_command(SYSOP_MOVE, file_recs[file_pos]->filename);

                          menu_done=1;
                          save_file_pos=file_pos=0;
                          amount=lines=matches=0;
                        }
                        menu_pos = 0;      // jump up to the 'next' option
                        break;

                      case 5: // Download or move batch files
                        if(!sysop_mode && using_modem)
                        {
                          CLS();

                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;

#ifdef FILE_POINTS
                        if(((!(file_recs[file_pos]->mask & mask_validated)) || ((file_recs[file_pos]->filepoints>thisuser.filepoints)) &&
                           (!(thisuser.exempt & exempt_ratio))) && !sysop_mode)
                        {
                          CLS();
                          pl("You don't have enough file points to download this file");
                          pl("Or this file is not validated yet.");
#else
                          if(!ratio_ok())
                          {
#endif
                            pausescr();
                          }
                          else
                            download_plus(file_recs[file_pos]->filename);
                          dliscan();
                        }
                        else if(!sysop_mode)
                        {
                          do_batch_sysop_command(SYSOP_MOVE, file_recs[file_pos]->filename);

                          menu_done=1;
                          save_file_pos=file_pos=0;
                          amount=lines=matches=0;
                        }
                        else
                        {
                          sysop_configure();

                          smc.normal_highlight  = lp_config.normal_highlight;
                          smc.normal_menu_item  = lp_config.normal_menu_item;
                          smc.current_highlight = lp_config.current_highlight;
                          smc.current_menu_item = lp_config.current_menu_item;



                          menu_done=1;
                          save_file_pos=file_pos;
                          amount=lines=matches=0;
                        }
                        menu_pos = 0;      // jump up to the 'next' option
                        break;

                      case 6: // +dir
                        menu_done=1;
                        amount=lines=matches=0;
                        first_file=1;

                        changedir=1;

                        if ((curdir<num_dirs-1) && (udir[curdir+1].subnum>=0))
                        {
                          ++curdir;
                          ++this_dir;
                        }
                        else
                        {
                          curdir=0;
                          this_dir=0;
                        }
                        if(!type)
                          save_dir=curdir;
                        dliscan();

                        menu_pos = 0;      // jump up to the 'next' option
                        break;

                      case 7: // -dir
                        menu_done=1;
                        amount=lines=matches=0;
                        first_file=1;

                        changedir=-1;

                        if (curdir>0)
                        {
                          --curdir;
                          --this_dir;
                        }
                        else
                        {
                          while ((udir[curdir+1].subnum>=0) && (curdir<num_dirs-1))
                            ++curdir;
                          this_dir=curdir;
                        }
                        if(!type)
                          save_dir=curdir;
                        dliscan();

                        menu_pos = 0;      // jump up to the 'next' option
                        break;

                      case 8:  // toggle extended
TOGGLE_EXTENDED:        ext_is_on = !ext_is_on;  /* descriptions on and off */
                        menu_done=1;
                        amount=lines=matches=0;
                        file_pos=0;
                        save_file_pos=file_pos;
                        menu_pos = 0;      // jump up to the 'next' option
                        break;

                      case 9: // Quit
                        menu_done=1;
                        done=1;
                        amount=lines=matches=0;
                        all_done=1;
                        lines_listed = 0;
                        break;


                      case 10: // ? Help
                        CLS();
                        printfile("LISTPLUS.HLP");
                        pausescr();


                        menu_done=1;
                        amount=lines=matches=0;
                        save_file_pos=file_pos;
                        break;

                      case 11: // Sysop

                        if(so() && !sysop_mode)
                        {
                          sysop_mode=1;

                          strcpy(menu_items[2], "Delete");
                          strcpy(menu_items[3], "Rename");
                          strcpy(menu_items[4], "Move");
                          strcpy(menu_items[5], "Config");
                          strcpy(menu_items[11], "Back");
                        }
                        else
                        {
                          sysop_mode=0;
                          prep_menu_items(menu_items);
                        }
                        outchr('\r');
                        EOL();

                        break;


                    }

                    break;

                  case GET_OUT:
                    menu_done=1;
                    done=1;
                    all_done=1;
                    amount=lines=matches=0;
                    break;

                }
              }
            }
            else
            {
              if(!changedir)
                done=1;  // If !matches
              else if(changedir==1)
              {
                if ((curdir<num_dirs-1) && (udir[curdir+1].subnum>=0))
                  ++curdir;
                else
                  curdir=0;
                dliscan();

              }
              else
              {
                if (curdir>0)
                  --curdir;
                else
                {
                  while ((udir[curdir+1].subnum>=0) && (curdir<num_dirs-1))
                    ++curdir;
                }
                dliscan();

              }
            }
          }
        }
        else
        {
          file=sh_close(file);

          if(!changedir)
            done=1;  // If !matches
          else if(changedir==1)
          {
            if ((curdir<num_dirs-1) && (udir[curdir+1].subnum>=0))
              ++curdir;
            else
              curdir=0;
            dliscan();

          }
          else
          {
            if (curdir>0)
              --curdir;
            else
            {
              while ((udir[curdir+1].subnum>=0) && (curdir<num_dirs-1))
                ++curdir;
            }
            dliscan();
          }
        }
      }
    }
  }

  if(file!=-1)
    file=sh_close(file);


  bbsfree(file_recs);
  free_2d(menu_items);

  return(all_done);
}

void drawfile(int filepos, int filenum)
{
  lines_listed = 0;

  GOTO_XY(4, filepos+first_file_pos());
  setc(lp_config.current_file_color);
  npr_color("%3d0", filenum);
  GOTO_XY(4, filepos+first_file_pos());
  
}

void undrawfile(int filepos, int filenum)
{
  lines_listed = 0;
  GOTO_XY(4, filepos+first_file_pos());
  npr_color("|%2d%3d0", lp_config.file_num_color, filenum);
}


int add_batch(char *filename, int dn, long fs)
{
  double t;
  
  if(find_batch_queue(filename) > -1)
    return 0;
  
  if (numbatch>=sysinfo.max_batch)
  {
    GOTO_XY(1, thisuser.screenlines-1);
    pl(get_string(900));
    pausescr();
  }
  else if(!ratio_ok())
  {
    pausescr();
  }
  else 
  {
    if (modem_speed && fs)
      // t=(12.656) / ((double) (modem_speed)) * ((double)(fs));
      t=(9.0) / ((double) (modem_speed)) * ((double)(fs));
    else
      t=0.0;
#ifdef FILE_POINTS
    if ((thisuser.filepoints<(batchfpts+fpts))
        && (!(thisuser.exempt & exempt_ratio))) {
      GOTO_XY(1, thisuser.screenlines-1);
      pl("Not enough file points to download this file");
      pausescr();
    }
    else
#endif
    if (nsl()<=(batchtime + t)) 
    {
      GOTO_XY(1, thisuser.screenlines-1);
      pl(get_string(901));
      pausescr();
    }
    else 
    {
      if (dn==-1) 
      {
        GOTO_XY(1, thisuser.screenlines-1);
        pl(get_string(902));
        pausescr();
      } 
      else 
      {
        batchtime += t;
#ifdef FILE_POINTS
        batchfpts += fpts;
#endif
        strcpy(batch[numbatch].filename,filename);
        batch[numbatch].dir=dn;
        batch[numbatch].time=t;
        batch[numbatch].sending=1;
        batch[numbatch].len=fs;
#ifdef FILE_POINTS
        batch[numbatch].filepoints=fpts;
#endif
  
        numbatch++;
#ifdef KBPERDAY
        kbbatch+=bytes_to_k(fs);
#endif
        ++numbatchdl;
        
        return 1;
      }
    }
  }
  return 0;
}






// Return the amount of lines that were printed
int printinfo_plus(uploadsrec *u, int filenum, int marked, int LinesLeft, struct search_record *search_rec)
{
  char temp[150], filename[13], ext[4];
  char finfo[1024], element[150], *str;
  int width=0;

  int ch=0, chars_this_line=0, numl=0, cpos=0, will_fit=78;
  int char_printed=0, extdesc_pos;
  unsigned int_cmd;

  int daysold;
  long TimeNow, DiffTime;



  // Extract out filename and extention
  strcpy(filename, u->filename);
  str=strchr(filename, '.');
  str[0]=0;
  ++str;
  strcpy(ext, str);

  TimeNow=time(NULL);
  DiffTime=difftime(TimeNow, u->daten);
  daysold=DiffTime/SECONDS_PER_DAY;



  sprintf(finfo, "|%2d %c |%2d%3d ", lp_config.tagged_color, marked ? '' : ' ', lp_config.file_num_color, filenum);
  width = 7;

  lines_listed=0;             /* kill any pauses that might happen */




  if(config_listing.lp_options & cfl_fname)
  {
    strcpy(temp, filename);
    justify_string(temp, 8, ' ', JUSTIFY_LEFT);

    if(search_rec)
      colorize_foundtext(temp, search_rec, config_listing.lp_colors[0]);

    sprintf(element, "|%02d%s", config_listing.lp_colors[0], temp);
    strcat(finfo, element);
    width+=8;
  }


  if(config_listing.lp_options & cfl_extension)
  {
    strcpy(temp, ext);
    justify_string(temp, 3, ' ', JUSTIFY_LEFT);

    if(search_rec)
      colorize_foundtext(temp, search_rec, config_listing.lp_colors[1]);

    sprintf(element, "|%02d.%s", config_listing.lp_colors[1], temp);
    strcat(finfo, element);
    width+=4;
  }

  if(config_listing.lp_options & cfl_dloads)
  {
    sprintf(temp, "%3d", u->numdloads);
    temp[3]=0;

    sprintf(element, " |%02d%s", config_listing.lp_colors[2], temp);
    strcat(finfo, element);
    width+=4;
  }


  if(config_listing.lp_options & cfl_kbytes)
  {
    sprintf(temp, "%4ldk", (long)bytes_to_k(u->numbytes));
    temp[5]=0;

    if (!(directories[udir[curdir].subnum].mask & mask_cdrom))
    {
      char file[101];
      strcpy(file, directories[udir[curdir].subnum].path);
      strcat(file, u->filename);

      if(lp_config.check_exist)
      {
        if (!exist(file))
          strcpy(temp,"OFFLN");
      }
    }

    sprintf(element, " |%02d%s", config_listing.lp_colors[3], temp);
    strcat(finfo, element);
    width+=6;
  }






#ifdef FILE_POINTS
  if(config_listing.lp_options & cfl_file_points)
  {
    if (u->mask & mask_validated)
    {
      if (u->filepoints)
        { sprintf(temp,"%4u",u->filepoints); temp[4]=0; }
      else
        sprintf(temp,"Free");
    }
    else
      sprintf(temp, "9e99");

    sprintf(element, " |%02d%s", config_listing.lp_colors[5], temp);
    strcat(finfo, element);
    width+=5;
  }
#endif


  if(config_listing.lp_options & cfl_days_old)
  {
    sprintf(temp, "%3d", daysold);
    temp[3]=0;

    sprintf(element, " |%02d%s", config_listing.lp_colors[6], temp);
    strcat(finfo, element);
    width+=4;
  }



  if(config_listing.lp_options & cfl_times_a_day_dloaded)
  {
    float t;

    t=daysold ? (float)u->numdloads/(float)daysold : 0.0;

    sprintf(temp, "%2.2f", t);
    temp[5]=0;

    sprintf(element, " |%02d%s", config_listing.lp_colors[8], temp);
    strcat(finfo, element);
    width+=6;
  }


  if(config_listing.lp_options & cfl_days_between_dloads)
  {
    float t;

    t = daysold ? (float)u->numdloads/(float)daysold : 0.0;
    t = t ? (float)1/(float)t : 0.0;

    sprintf(temp, "%3.1f", t);
    temp[5]=0;

    sprintf(element, " |%02d%s", config_listing.lp_colors[9], temp);
    strcat(finfo, element);
    width+=6;
  }


  if(config_listing.lp_options & cfl_description)
  {
    char *desc;


    ++width;          /* add 1 for the pre-space added before the desc */

    strcpy(temp, u->description);

    if(search_rec)
      colorize_foundtext(temp, search_rec, config_listing.lp_colors[10]);

    sprintf(element, " |%02d%s", config_listing.lp_colors[10], temp);
    strcat(finfo, element);

    extdesc_pos = width;
  }
  else
    extdesc_pos = -1;

  strcat(finfo, "\r\n");




  cpos=0;

  while(finfo[cpos] && numl < LinesLeft)
  {
    do
    {
      ch=finfo[cpos];

      if(!ch)
        continue;

      ++cpos;

    }while(ch=='\r' && ch);

    if(!ch)
      break;

    if (ch==10)
    {
      nl();
      chars_this_line=0;
      char_printed=0;
      ++numl;
    }
    else if (chars_this_line > will_fit && ch)
    {
      do{
        ch=finfo[cpos++];
      }while(ch!='\n' && ch!=0);
      --cpos;
    }
    else if(ch)
      chars_this_line += outchr_color(ch);
  }

  if(extdesc_pos > 0)
  {
    int num_extended, lines_left;
    int lines_printed;

    lines_left=LinesLeft-numl;
    num_extended=thisuser.num_extended;

    if(num_extended<lp_config.show_at_least_extended)
      num_extended=lp_config.show_at_least_extended;

    if(num_extended > lines_left)
      num_extended=lines_left;

    if(ext_is_on && mask_extended & u->mask)                                    /* description color */
      lines_printed=print_extended_plus(u->filename, num_extended, -extdesc_pos, config_listing.lp_colors[10], search_rec);
    else
      lines_printed=0;


    if(lines_printed)
    {
      numl+=lines_printed;

      chars_this_line=0;
      char_printed=0;
    }
  }


  if(WhereX())
  {
    if(char_printed)
    {
      nl();
      ++numl;
    }
    else
      outchr('\r');
  }


  temp[0]=0;
  finfo[0]=0;

  if(config_listing.lp_options & cfl_date_uploaded)
  {
    strcpy(temp,  u->date);
    justify_string(temp, 8, ' ', JUSTIFY_LEFT);
    sprintf(element, "|%02dUL Date: %s  ", config_listing.lp_colors[4], temp);
    strcat(finfo, element);
  }
  if(config_listing.lp_options & cfl_upby)
  {
    strcpy(temp, u->upby);
    properize(temp);
    temp[15]=0;

    sprintf(element, "|%02dUpby: %s", config_listing.lp_colors[7], temp);
    strcat(finfo, element);
  }


  if(temp[0])
  {
    justify_string(finfo, strlen(finfo) + width, ' ', JUSTIFY_RIGHT);
    outstr_color(finfo);
    nl();
    ++numl;
  }

  return(numl);
}



  
int load_config_listing(int config)
{
  int fh, len;
  char fname[201];
  userrec u;


  unload_config_listing();


  memset((void *)&config_listing, 0, sizeof(asylum_config));

  for(fh=0;fh<32;fh++)         /* set default colors to grey */
    config_listing.lp_colors[fh]=7;

  /* setup a default set of items already turned on */
  config_listing.lp_options = cfl_fname | cfl_extension | cfl_dloads | cfl_kbytes | cfl_description;


  if(!config)
    return 0;


  sprintf(fname, "%sASYLUM.USR", syscfg.datadir, config);

  if(exist(fname))
  {
    read_user(config, &u);
    fh=sh_open1(fname, O_RDONLY | O_BINARY);

    if(fh > 0)
    {
      lseek(fh, (long) config * sizeof(asylum_config), SEEK_SET);

      len = sh_read(fh, (void *) &config_listing, sizeof(asylum_config));
      fh=sh_close(fh);

      if(len != sizeof(asylum_config) || strcmpi(config_listing.name, u.name) != 0)
      {
        memset(&config_listing, 0, sizeof(config_listing));
        strcpy(config_listing.name, u.name);
        return 0;
      }

      list_loaded=config;
      extended_desc_used = config_listing.lp_options & cfl_description;

      /* force filename to be shown */
      config_listing.lp_options |= cfl_fname;
      /* force description to be turned on too */
      config_listing.lp_options |= cfl_description;

      return 1;
    }
  }
  return 0;
}

void write_config_listing(int config)
{
  int fh;
  char fname[201];
  userrec u;

  if(!config)
    return;

  read_user(config, &u);
  strcpy(config_listing.name, u.name);

  sprintf(fname, "%sASYLUM.USR", syscfg.datadir);

  fh=sh_open1(fname, O_RDWR | O_BINARY | O_CREAT);
  if(!fh)
    return;


  /* force filename to be shown */
  config_listing.lp_options |= cfl_fname;
  /* force description to be turned on too */
  config_listing.lp_options |= cfl_description;


  lseek(fh, (long)config * (long) sizeof(asylum_config), SEEK_SET);
  sh_write(fh, (void *) &config_listing, sizeof(asylum_config));
  fh=sh_close(fh);
}


void unload_config_listing(void)
{
  list_loaded=0;
  memset(&config_listing, 0, sizeof(asylum_config));
}


int print_extended_plus(char *fn, int numlist, int indent, int color, struct search_record *search_rec)
{
  char *ss, *new_ss;
  unsigned char numl=0;
  int cpos=0;
  char ch,s[81];
  int i;
  int chars_this_line=0, will_fit;
  int strip_pos, temp_char;

  will_fit=80-abs(indent)-2;

  ss=READ_EXTENDED_DESCRIPTION(fn);

  if(!ss)
    return 0;


  strip_pos=strlen(ss);
  --strip_pos;

  while(ss[strip_pos] && strip_pos)
  {
    temp_char=ss[strip_pos];

    if(isspace(temp_char))
      ss[strip_pos]=0;
    else
      break;

    --strip_pos;
  }


  if(ss)
  {
    i=strlen(ss);

    if(i>MAX_EXTENDED_SIZE)
    {
      i=MAX_EXTENDED_SIZE;
      ss[i]=0;
    }

    new_ss=(char *)malloca((i*4)+30);

    if (new_ss)
    {
      strcpy(new_ss, ss);

      if(search_rec)
        colorize_foundtext(new_ss, search_rec, color);

      if(indent > -1)
        npr_color("  1Extended Description:\n\r");

      ch=10;

      while ((new_ss[cpos]) && (numl<numlist) && !hangup)
      {

        if ((ch==10) && (indent))
        {
          sprintf(s,"\x1b[%dC", abs(indent));

          setc(color);
          outchr('\r');
          outstr(s);
        }

        do{
          ch=new_ss[cpos++];
        }while(ch=='\r' && !hangup);

        if (ch==10)
        {
          nl();
          chars_this_line=0;
          ++numl;
        }
        else if (chars_this_line > will_fit)
        {
          do
          {
            ch=new_ss[cpos++];
          }while(ch!='\n' && ch!=0);
          --cpos;
        }
        else
          chars_this_line += outchr_color(ch);
      }

      if(WhereX())
      {
        nl();
        ++numl;
      }

      bbsfree(new_ss);
      bbsfree(ss);
    }
  }
  ansic(0);
  return(numl);
}


void show_fileinfo(uploadsrec *u)
{
  
  CLS();
  
  ansic(7);
  repeat_char('', 78);
  nl();

  npr("  1File info  : 5%s", u->filename);
  nl();

  npr("  1Description: 5%s", u->description);
  nl();
  npr("  1Uploaded on: 5%s", u->date);
  nl();
  npr("  1Uploaded by: 5%s", u->upby);
  nl();
  npr("  1Size       : 5%ld", u->numbytes);
  npr("  1Downloaded : 5%d", u->numdloads);
  nl();
  nl();
  print_extended_plus(u->filename,255, 27, LIGHTCYAN, NULL);

  ansic(7);
  repeat_char('', 78);
  nl();
  
  pausescr();
}





int check_lines_needed(uploadsrec *u)
{
  char *ss, *tmp;
  int elines = 0;
  int max_extended, max_lines, num_extended;


  lc_lines_used = lp_configured_lines();


  max_lines = calc_max_lines();
  num_extended=thisuser.num_extended;

  if(num_extended<lp_config.show_at_least_extended)
    num_extended=lp_config.show_at_least_extended;

  if(max_lines > num_extended)
    max_lines = num_extended;

  if(extended_desc_used)    /* if extended description is used */
  {
    max_extended=thisuser.num_extended;

    if(max_extended<lp_config.show_at_least_extended)
      max_extended=lp_config.show_at_least_extended;

    if(ext_is_on && mask_extended & u->mask)    /* only try to read an extended */
      ss=READ_EXTENDED_DESCRIPTION(u->filename);/* description if it claims to  */
    else                                        /* have on in the first place   */
      ss=NULL;

    if(ss)
    {
      tmp = ss;

      while((elines < max_extended) && ((tmp = strchr(tmp, '\r')) != NULL))
      {
        ++elines;
        ++tmp;
      }
      bbsfree(ss);
    }
  }

  if(lc_lines_used + elines > max_lines)
    return(max_lines-1);

  return(lc_lines_used + elines);
}






typedef struct {
  char name[13];
  long offset;           /* of ext_desc_type */
} ext_desc_rec;



static int ed_num;
static ext_desc_rec *ed_info;


static char last_edlfn[131];
static int ext_file;

char *lp_read_extended_description(char *fn)
{
  ext_desc_type ed;
  long l,l1;
  char *ss=NULL;
  int i;

  lp_get_ed_info();

  if(ed_info && ext_file > 0)
  {
    for (i=0; i<ed_num; i++)
    {
      if (strcmp(fn, ed_info[i].name)==0)
      {
        sh_lseek(ext_file, ed_info[i].offset, SEEK_SET);
        l=sh_read(ext_file, &ed, sizeof(ext_desc_type));

        if ((l==sizeof(ext_desc_type)) && (strcmp(fn, ed.name)==0))
        {
          ss=malloca((long) ed.len+10);
          if (ss) {
            sh_read(ext_file,ss,ed.len);
            ss[ed.len]=0;
          }
          return(ss);
        }
        else
          break;
      }
    }
  }

  return(NULL);
}

void lp_zap_ed_info(void)
{
  if (ed_info) {
    bbsfree(ed_info);
    ed_info = NULL;
  }

  if(ext_file > 0)
    ext_file = sh_close(ext_file);

  ext_file = -1;

  last_edlfn[0] = 0;

  ed_num=0;
}

void lp_get_ed_info(void)
{
  long l,l1;
  ext_desc_type ed;


  if(strcmp(last_edlfn, edlfn) != 0)
  {
    lp_zap_ed_info();

    strcpy(last_edlfn, edlfn);

    if (!numf)
      return;

    l=0;

    ext_file=sh_open1(edlfn,O_RDONLY | O_BINARY);

    if (ext_file>0)
    {
      l1=filelength(ext_file);
      if (l1>0)
      {
        ed_info=malloca((long)numf*sizeof(ext_desc_rec));
        if (ed_info==NULL)
        {
          ext_file = sh_close(ext_file);
          return;
        }
        ed_num=0;
        while ((l<l1) && (ed_num<numf))
        {
          sh_lseek(ext_file,l,SEEK_SET);
          if (sh_read(ext_file,&ed,sizeof(ext_desc_type)) == sizeof(ext_desc_type)) {
            strcpy(ed_info[ed_num].name,ed.name);
            ed_info[ed_num].offset=l;
            l += (long) ed.len + sizeof(ext_desc_type);
            ed_num++;
          }
        } /* while l < l1 */
      }   /* if l1 > 0    */
    }  /* if ext_file > 0 */
  }    /* if the strings do not match */
}




void prep_menu_items(char **menu_items)
{
  strcpy(menu_items[0], "Next");
  strcpy(menu_items[1], "Prev");
  strcpy(menu_items[2], "Tag");
  strcpy(menu_items[3], "Info");
  strcpy(menu_items[4], "View");

  if(using_modem!=0)
    strcpy(menu_items[5], "Download");
  else
    strcpy(menu_items[5], "Move");

  strcpy(menu_items[6], "+Dir");
  strcpy(menu_items[7], "-Dir");
  strcpy(menu_items[8], "FDIZ");
  strcpy(menu_items[9], "Quit");
  strcpy(menu_items[10], "?");
  if(so())
  {
    strcpy(menu_items[11], "Sysop");
    menu_items[13][0]=0;
  }
  else
    menu_items[12][0]=0;
}

int prep_search_rec(struct search_record *search_rec, int type)
{
  memset(search_rec, 0, sizeof(struct search_record));
  search_rec->search_extended=lp_config.search_extended_on;

  if(type==LIST_DIR)  // Regular listfile
  {
    file_mask(search_rec->filemask);
    search_rec->alldirs=THIS_DIR;
  }
  else if(type==SEARCH_ALL) // Search file
  {
    search_rec->alldirs=ALL_DIRS;
    if(!search_criteria(search_rec))
      return 0;
  }
  else if(type==NSCAN_DIR) // new files
  {
    search_rec->alldirs=THIS_DIR;
    search_rec->nscandate=nscandate;
  }
  else if(type==NSCAN_NSCAN) // New scan of dirs in NSCAN
  {
#ifdef JAFO22
    newfscan=1;
#endif
    search_rec->nscandate=nscandate;
    search_rec->alldirs=ALL_DIRS;
  }
  else
  {
    sysoplog("Undef LP type");
    return 0;
  }


  if(!search_rec->filemask[0] && !search_rec->nscandate && !search_rec->search[0])
    return 0;


  if(search_rec->filemask[0])
  {
    if (strchr(search_rec->filemask,'.')==NULL)
      strcat(search_rec->filemask,".*");
  }
  align(search_rec->filemask);

  return 1;
}


int calc_max_lines(void)
{
  int max_lines;


  if(lp_config.max_screen_lines_to_show)
  {
    max_lines = thisuser.screenlines-(first_file_pos()+1+STOP_LIST)
                      >
            lp_config.max_screen_lines_to_show-(first_file_pos()+1+STOP_LIST)
                      ?
            lp_config.max_screen_lines_to_show-(first_file_pos()+1+STOP_LIST)
                      :
            thisuser.screenlines-(first_file_pos()+1+STOP_LIST);
  }
  else
    max_lines = thisuser.screenlines-(first_file_pos()+1+STOP_LIST);

  return max_lines;
}



void sysop_configure(void)
{
  int key, done=0, color;
  char s[201];

  if(!so())
    return;

  load_lp_config();



  while(!done && !hangup)
  {

    CLS();
    printfile("LPSYSOP");

    GOTO_XY(38, 2);
    setc(lp_config.normal_highlight);
    npr("%3d", lp_config.normal_highlight);

    GOTO_XY(77, 2);
    setc(lp_config.normal_menu_item);
    npr("%3d", lp_config.normal_menu_item);

    GOTO_XY(38, 3);
    setc(lp_config.current_highlight);
    npr("%3d", lp_config.current_highlight);

    GOTO_XY(77, 3);
    setc(lp_config.current_menu_item);
    npr("%3d", lp_config.current_menu_item);

    ansic(0);

    GOTO_XY(38, 6);
    npr_color("|%2d%2d", lp_config.tagged_color, lp_config.tagged_color);

    GOTO_XY(77, 6);
    npr_color("|%2d%2d", lp_config.file_num_color, lp_config.file_num_color);

    GOTO_XY(38, 7);
    npr_color("|%2d%2d", lp_config.found_fore_color, lp_config.found_fore_color);

    GOTO_XY(77, 7);
    npr_color("|%2d%2d", lp_config.found_back_color, lp_config.found_back_color);

    GOTO_XY(38, 8);
    setc(lp_config.current_file_color);
    npr_color("%3d", lp_config.current_file_color);


    GOTO_XY(38, 11);
    ansic(4);
    npr("%2d", lp_config.max_screen_lines_to_show);

    GOTO_XY(77, 11);
    ansic(4);
    npr("%2d", lp_config.show_at_least_extended);

    GOTO_XY(29, 14);
    ansic(4);
    npr("%s", lp_config.check_exist ? _on_ : _off_);

    GOTO_XY(74, 14);
    ansic(4);
    npr("%s", lp_config.request_file ? _on_ : _off_);

    GOTO_XY(29, 15);
    ansic(4);
    npr("%s", lp_config.colorize_found_text ? _on_ : _off_);

    GOTO_XY(74, 15);
    ansic(4);
    npr("%s", lp_config.search_extended_on ? _on_ : _off_);





    ansic(0);

    GOTO_XY(1, 19);

    ansic(1);
    outstr("Q-Quit ");
    mpl(1);
    key=onek("Q\rABCDEFGHIJKMNOS");

    switch(key)
    {
      case 'Q':
      case '\r':
        done=1;
        break;


      case 'A':
      case 'B':
      case 'C':
      case 'D':
      case 'I':
        color=SelectColor(2);
        if(color>=0)
        {
          switch(key)
          {
            case 'A':
              lp_config.normal_highlight=color;
              break;
              
            case 'B':
              lp_config.normal_menu_item=color;
              break;

            case 'C':
              lp_config.current_highlight=color;
              break;

            case 'D':
              lp_config.current_menu_item=color;
              break;

            case 'I':
              lp_config.current_file_color=color;
              break;
          }
        }
        break;

      case 'E':
      case 'F':
      case 'G':
      case 'H':
        color=SelectColor(1);
        if(color>=0)
        {
          switch(key)
          {
            case 'E':
              lp_config.tagged_color=color;
              break;
              
            case 'F':
              lp_config.file_num_color=color;
              break;

            case 'G':
              lp_config.found_fore_color=color;
              break;

            case 'H':
              lp_config.found_back_color=color+16;
              break;
          }
        }
        break;

      case 'J':
        outstr("Enter max amount of lines to show (0=disabled) ");
        mpl(2);
        input(s, 2);
        lp_config.max_screen_lines_to_show=atoi(s);
        break;

      case 'K':
        outstr("Enter minimum extended description lines to show ");
        mpl(2);
        input(s, 2);
        lp_config.show_at_least_extended=atoi(s);
        break;

      case 'M':
        lp_config.request_file=!lp_config.request_file;
        break;


      case 'N':
        lp_config.colorize_found_text=!lp_config.colorize_found_text;
        break;

      case 'O':
        lp_config.search_extended_on=!lp_config.search_extended_on;
        break;


      case 'S':
        lp_config.check_exist=!lp_config.check_exist;
        break;

    }
  }
  save_lp_config();
  load_lp_config();
}


int SelectColor(int which)
{
  char ch,nc;

  helpl=36;
  nl();
  
  if (thisuser.sysstatus & sysstatus_color)
  {
    color_list();
    ansic(0);
    nl();
    prt(2, get_string(430));
    ch=onek("01234567");
    nc=ch-'0';

    if(which==2)
    {
      prt(2, get_string(431));
      ch=onek("01234567");
      nc=nc | ((ch-'0') << 4);
    }
  }
  else
  {
    nl();
    prt(5, get_string(432));
    if (yn()) {
      if ((thisuser.bwcolors[1] & 0x70) == 0)
        nc=0 | ((thisuser.bwcolors[1] & 0x07) << 4);
      else
        nc=(thisuser.bwcolors[1] & 0x70);
    }
    else
    {
      if ((thisuser.bwcolors[1] & 0x70) == 0)
        nc=0 | (thisuser.bwcolors[1] & 0x07);
      else
        nc=((thisuser.bwcolors[1] & 0x70) >> 4);
    }
  }

    prt(5, get_string(434));
    if (yn())
      nc |= 0x08;

  if(which==2)
  {
    prt(5, get_string(437));
    if (yn())
      nc |= 0x80;
  }

  nl();
  setc(nc);
  outstr(describe(nc));
  ansic(0);
  nl();


  prt(5, get_string(438));
  if(yn())
    return nc;
  return -1;
}
void check_listplus(void)
{
  ansic(1);
  outstr("Use listplus file tagging? ");

  if(ny())
  {
    if(thisuser.sysstatus & sysstatus_listplus) /* ! sysstatus_list means */
      thisuser.sysstatus -= sysstatus_listplus; /* to use it              */
  }
  else
  {
    if(!(thisuser.sysstatus & sysstatus_listplus))
      thisuser.sysstatus += sysstatus_listplus;
  }

}
void config_file_list(void)
{
  int key, done=0, which = -1;
  unsigned long bit;
  char action[51];
  uploadsrec u;

  strcpy(u.filename, "ASYLUM.ZIP");
  strcpy(u.description, "The Asylum Group at its simply Best!");
  strcpy(u.date, "01/01/94");
  strcpy(u.upby, "Zu Digital");
  u.numdloads=105;
  u.numbytes=150000L;
  u.daten = time(NULL) - 10000;




  load_lp_config();

  if(usernum!=list_loaded)          /* if there isn't one of this user    */
    if(!load_config_listing(usernum))  /* then load the sysops, and let them */
      load_config_listing(1);          /* edit from there                    */


  CLS();
  printfile("LPCONFIG");

  /* force filename to be shown */
  if(!config_listing.lp_options & cfl_fname)
    config_listing.lp_options |= cfl_fname;

  /* description too */
  if(!config_listing.lp_options & cfl_description)
    config_listing.lp_options |= cfl_description;





  action[0]=0;
  while(!done && !hangup)
  {
    update_user_config_screen(&u, which);
    
    key=onek("Q2346789H!@#$%^&*(");  /* removed '1' and '5' */


    switch(key)
    {
      /* case '1': */
      case '2':
      case '3':
      case '4':
      /* case '5': */
      case '6':
      case '7':
      case '8':
      case '9':
      case 'H':
        switch(key)
        {
          /* case '1': bit = cfl_fname;          which = 1;  break; */
          case '2': bit = cfl_extension;      which = 2;  break;
          case '3': bit = cfl_dloads;         which = 3;  break;
          case '4': bit = cfl_kbytes;         which = 4;  break;
          /* case '5': bit = cfl_description;    which = 5;  break; */
          case '6': bit = cfl_date_uploaded;  which = 6;  break;
          case '7': bit = cfl_file_points;    which = 7;  break;
          case '8': bit = cfl_days_old;       which = 8;  break;
          case '9': bit = cfl_upby;           which = 9;  break;
          case 'H': bit = cfl_header;         which = 10; break;
        }

        if(config_listing.lp_options & bit)
          config_listing.lp_options &= ~bit;
        else
          config_listing.lp_options |= bit;
        break;

      case '!':
      case '@':
      case '#':
      case '$':
      case '%':
      case '^':
      case '&':
      case '*':
      case '(':
        switch(key)
        {
          case '!': bit = 0;  which = 1; break;
          case '@': bit = 1;  which = 2; break;
          case '#': bit = 2;  which = 3; break;
          case '$': bit = 3;  which = 4; break;
          case '%': bit = 10; which = 5; break;
          case '^': bit = 4;  which = 6; break;
          case '&': bit = 5;  which = 7; break;
          case '*': bit = 6;  which = 8; break;
          case '(': bit = 7;  which = 9; break;
        }

        ++config_listing.lp_colors[bit];
        if(config_listing.lp_colors[bit] > 15)
          config_listing.lp_colors[bit]=1;
        break;

      case 'Q':
        done = 1;
        break;
    }

  }
  list_loaded = usernum;
  write_config_listing(usernum);
  nln(4);
}


void update_user_config_screen(uploadsrec *u, int which)
{
  int space;
  struct search_record sr;

  memset(&sr, 0, sizeof(struct search_record));

  if(which < 1 || which == 1)
  {
    GOTO_XY(37, 4);
    setc(config_listing.lp_options & cfl_fname ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[0]]);
  }

  if(which < 1 || which == 2)
  {
    GOTO_XY(37, 5);
    setc(config_listing.lp_options & cfl_extension ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[1]]);
  }

  if(which < 1 || which == 3)
  {
    GOTO_XY(37, 6);
    setc(config_listing.lp_options & cfl_dloads ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[2]]);
  }

  if(which < 1 || which == 4)
  {
    GOTO_XY(37, 7);
    setc(config_listing.lp_options & cfl_kbytes ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[3]]);
  }

  if(which < 1 || which == 5)
  {
    GOTO_XY(37, 8);
    setc(config_listing.lp_options & cfl_description ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[10]]);
  }

  if(which < 1 || which == 6)
  {
    GOTO_XY(37, 9);
    setc(config_listing.lp_options & cfl_date_uploaded ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[4]]);
  }

  if(which < 1 || which == 7)
  {
    GOTO_XY(37, 10);
    setc(config_listing.lp_options & cfl_file_points ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[5]]);
  }

  if(which < 1 || which == 8)
  {
    GOTO_XY(37, 11);
    setc(config_listing.lp_options & cfl_days_old ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[6]]);
  }

  if(which < 1 || which == 9)
  {
    GOTO_XY(37, 12);
    setc(config_listing.lp_options & cfl_upby ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
    outstr(lp_color_list[config_listing.lp_colors[7]]);
  }

  if(which < 1 || which == 10)
  {
    GOTO_XY(37, 13);
    setc(config_listing.lp_options & cfl_header ? RED + (BLUE <<4) : BLACK + (BLUE <<4));
    npr(" ");
    setc(BLACK+(BLUE<<4));
  }


  setc(YELLOW);
  GOTO_XY(1, 21);
  EOL();
  nl();
  EOL();
  GOTO_XY(1, 21);
  printinfo_plus(u, 1, 1, 30, &sr);

  GOTO_XY(30, 17);
  setc(YELLOW);
  backspace();
}


int rename_filename(char *fn, int dn)
{
  char s[81],s1[81],s2[81],*ss,s3[81],ch;
  int i,cp,f, ret=1;
  uploadsrec u;

#ifdef FAST_EXTENDED_DESCRIPTION
  lp_zap_ed_info();
#endif


  dliscan1(dn);

  strcpy(s, fn);

  if (s[0]==0)
    return ret;

  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);

  strcpy(s3,s);
  i=recno(s);
  while (i>0)
  {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);

    if(f < 1)
      break;


    cp=i;
    SETREC(f,i);
    sh_read(f,(void *)&u,sizeof(uploadsrec));
    f=sh_close(f);
    nl();
    printfileinfo(&u, dn);
    nl();
    prt(5,get_string(830));
    ch=ynq();
    if (ch=='Q')
    {
      ret=0;
      break;
    }

    else if (ch=='N') {
      i=nrecno(s3,cp);
      continue;
    }
    nl();
    prt(2,get_string(72));
    input(s,12);
		if (!okfn(s))
      s[0]=0;
    if (s[0]) {
      align(s);
      if(strcmp(s, /* get_string(1310) */ "        .   ")) {
        strcpy(s1,directories[dn].path);
        strcpy(s2,s1);
        strcat(s1,s);
        if (exist(s1))
          pl(get_string(831));
        else {
          strcat(s2,u.filename);
          rename(s2,s1);
          if (exist(s1)) {
            /* stock read extended only */
            ss=read_extended_description(u.filename);
            if (ss) {
              delete_extended_description(u.filename);
              add_extended_description(s,ss);
              bbsfree(ss);
            }
            strcpy(u.filename,s);
          } else
            pl(get_string(832));
        }
      }
    }
    nl();
    pl(get_string(833));
    prt(2,": ");
    inputl(s,58);
    if (s[0]) {
      strcpy(u.description,s);
    }
    /* stock read extended only */
    ss=read_extended_description(u.filename);
    nl();
		nl();
    prt(5,get_string(834));
    if (yn()) {
      nl();
      if (ss) {
        prt(5,get_string(835));
        if (yn()) {
          bbsfree(ss);
          delete_extended_description(u.filename);
					u.mask &= ~mask_extended;
        } else {
          u.mask |= mask_extended;
          modify_extended_description(&ss,
            directories[dn].name,u.filename);
          if (ss) {
            delete_extended_description(u.filename);
            add_extended_description(u.filename,ss);
            bbsfree(ss);
          }
        }
      } else {
        modify_extended_description(&ss,
            directories[dn].name,u.filename);
        if (ss) {
          add_extended_description(u.filename,ss);
          bbsfree(ss);
          u.mask |= mask_extended;
        } else
					u.mask &= ~mask_extended;
      }
    } else
      if (ss) {
        bbsfree(ss);
        u.mask |= mask_extended;
      } else
				u.mask &= ~mask_extended;
    f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
    if(f > 0)
    {
      SETREC(f,i);
      sh_write(f,(void *)&u,sizeof(uploadsrec));
      f=sh_close(f);
    }

    i=nrecno(s3,cp);
  }
  return ret;
}

int remove_filename(char *fn, int dn)
{
  int i,i1,rm,abort,rdlp,f, ret=1;
  char ch,s[81],s1[81];
  uploadsrec u;
  userrec uu;

#ifdef FAST_EXTENDED_DESCRIPTION
  lp_zap_ed_info();
#endif


  dliscan1(dn);

  strcpy(s, fn);

  if (s[0]==0) {
    return ret;
  }
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);
  i=recno(s);
  abort=0;
  while ((!hangup) && (i>0) && (!abort))
  {
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    if(f > 0)
    {
      SETREC(f,i);
      sh_read(f,(void *)&u,sizeof(uploadsrec));
      f=sh_close(f);
    }


    if ((dcs()) || ((u.ownersys==0) && (u.ownerusr==usernum))) {
      nl();

      printfileinfo(&u, dn);
      prt(2,get_string(818));
      ch=ynq();
      if (ch=='Q')
      {
        ret=0;
        abort=1;
      }
      else if (ch=='Y') {
        rdlp=1;
        if (dcs()) {
          prt(5,get_string(819));
          rm=yn();
          if (rm && (u.ownersys==0)) {
            prt(5,get_string(820));
            rdlp=yn();
          }

          if (sysinfo.flags & OP_FLAGS_FAST_SEARCH)
          {
            nl();
            prt(5,get_string(1381));
            if (yn())
              modify_database(s,0);
          }

        } else {
          rm=1;
          modify_database(s,0);
        }
        if (rm)
        {
          sprintf(s1,"%s%s",directories[dn].path,u.filename);
          unlink(s1);
          if ((rdlp) && (u.ownersys==0)) {
            read_user(u.ownerusr,&uu);
            if ((uu.inact & inact_deleted)==0) {
              if (date_to_daten(uu.firston) < u.daten) {
                --uu.uploaded;
                uu.uk -= bytes_to_k(u.numbytes);
#ifdef FILE_POINTS
                if (u.mask & mask_validated)                            
                  if ((u.filepoints * 2) > uu.filepoints)
                    uu.filepoints=0;
                  else                                             
                    uu.filepoints -= (u.filepoints * 2);           
                npr("Removed %u file points\r\n",(u.filepoints * 2));  
#endif
                write_user(u.ownerusr,&uu);
              }
            }
          }
        }
        if (u.mask & mask_extended)
          delete_extended_description(u.filename);
        sprintf(s1,get_stringx(1,44),u.filename,
                          directories[dn].name);
        sysoplog(s1);
        f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);

        if(f > 0)
        {
          for (i1=i; i1<numf; i1++)
          {
            SETREC(f,i1+1);
            sh_read(f,(void *)&u,sizeof(uploadsrec));
            SETREC(f,i1);
            sh_write(f,(void *)&u,sizeof(uploadsrec));
          }
          --i;
          --numf;
          SETREC(f,0);
          sh_read(f, &u, sizeof(uploadsrec));
          u.numbytes=numf;
          SETREC(f,0);
          sh_write(f,(void *)&u,sizeof(uploadsrec));
          f=sh_close(f);
        }
      }

    }
    i=nrecno(s,i);
  }
  return ret;
}

int move_filename(char *fn, int dn)
{
  char sx[81],s1[81],s2[81],ch,*ss;
  int i,i1,ok,d1,d2,done,cp,f, ret=1;
  uploadsrec u,u1;

#ifdef FAST_EXTENDED_DESCRIPTION
  lp_zap_ed_info();
#endif



  ok=0;


  strcpy(sx, fn);

  dliscan1(dn);

  align(sx);

  i=recno(sx);
  if (i<0) {
    nl();
    pl(get_string(89));
    return ret;
  }
  done=0;

  tmp_disable_conf(1);

  while ((!hangup) && (i>0) && (!done)) {
    cp=i;
    f=sh_open1(dlfn,O_RDONLY | O_BINARY);
    if(f > 0)
    {
      SETREC(f,i);
      sh_read(f,(void *)&u,sizeof(uploadsrec));
      f=sh_close(f);
    }

    nl();
    printfileinfo(&u, dn);
    nl();
    prt(5,get_string(822));
    ch=ynq();
    if (ch=='Q')
    {
      done=1;
      ret=0;
    }
    else if (ch=='Y')
    {
      sprintf(s1,"%s%s",directories[dn].path,u.filename);
      do
      {
        nl();
        nl();
        prt(2,get_string(823));
        ss=mmkey(1);
        if (ss[0]=='?')
        {
          dirlist();
          dliscan1(dn);
        }
      } while ((!hangup) && (ss[0]=='?'));

      d1=-1;

      if (ss[0])
        for (i1=0; (i1<num_dirs) && (udir[i1].subnum!=-1); i1++)
          if (strcmp(udir[i1].keys,ss)==0)
            d1=i1;
      if (d1!=-1) {
        ok=1;
        d1=udir[d1].subnum;
        dliscan1(d1);
        if (recno(u.filename)>0) {
          ok=0;
          nl();
          pl(get_string(824));
        }
        if (numf>=directories[d1].maxfiles) {
          ok=0;
          nl();
          pl(get_string(825));
        }
        if (freek1(directories[d1].path)<((double)(u.numbytes/1024L)+3)) {
          ok=0;
          nl();
          pl(get_string(826));
        }
        dliscan();
      } else
        ok=0;
    } else
      ok=0;
    if (ok && !done) {
      prt(5,get_string(934));
      if (yn()) {
        time((long *)&u.daten);
      }

      --cp;
      f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);

      if(f > 0)
      {
        for (i1=i; i1<numf; i1++) {
          SETREC(f,i1+1);
          sh_read(f,(void *)&u1,sizeof(uploadsrec));
          SETREC(f,i1);
          sh_write(f,(void *)&u1,sizeof(uploadsrec));
        }
        --numf;
        SETREC(f,0);
        sh_read(f, &u1, sizeof(uploadsrec));
        u1.numbytes=numf;
        SETREC(f,0);
        sh_write(f,(void *)&u1,sizeof(uploadsrec));
        f=sh_close(f);
      }


      /* stock read extended only */
      ss=read_extended_description(u.filename);
      if (ss)
        delete_extended_description(u.filename);

      sprintf(s2,"%s%s",directories[d1].path,u.filename);
      dliscan1(d1);
      f=sh_open(dlfn,O_RDWR | O_BINARY | O_CREAT, S_IREAD | S_IWRITE);
      if(f > 0)
      {
        for (i=numf; i>=1; i--) {
          SETREC(f,i);
          sh_read(f,(void *)&u1,sizeof(uploadsrec));
          SETREC(f,i+1);
          sh_write(f,(void *)&u1,sizeof(uploadsrec));
        }
        SETREC(f,1);
        sh_write(f,(void *)&u,sizeof(uploadsrec));
        ++numf;
        SETREC(f,0);
        sh_read(f, &u1, sizeof(uploadsrec));
        u1.numbytes=numf;
        if (u.daten>u1.daten) {
          u1.daten = u.daten;
          dir_dates[d1]=u.daten;
        }
        SETREC(f,0);
        sh_write(f,(void *)&u1,sizeof(uploadsrec));
        f=sh_close(f);
      }


      if (ss) {
        add_extended_description(u.filename,ss);
        bbsfree(ss);
      }

      if ((strcmp(s1,s2)!=0) && (exist(s1))) {
        d2=0;
        if ((s1[1]!=':') && (s2[1]!=':'))
          d2=1;
        if ((s1[1]==':') && (s2[1]==':') && (s1[0]==s2[0]))
          d2=1;
        if (d2) {
          rename(s1,s2);
          unlink(s1);
        } else {
          copy_file(s1,s2);
          unlink(s1);
        }
      }
      nl();
      pl(get_string(827));
    }
    dliscan();
    i=nrecno(sx,cp);
  }

  tmp_disable_conf(0);

  return ret;
}

void do_batch_sysop_command(int mode, char *filename)
{
  int save_curdir=curdir;
  int pos=0, done=0;

  CLS();

  if(numbatchdl)
  {
    while(pos<numbatch && !done)
    {
      if(batch[pos].sending)
      {
        switch(mode)
        {
          case SYSOP_DELETE:
            if(!remove_filename(batch[pos].filename, batch[pos].dir))
              done=1;
            else
              delbatch(pos);
            break;

          case SYSOP_RENAME:
            if(!rename_filename(batch[pos].filename, batch[pos].dir))
              done=1;
            else
              delbatch(pos);
            break;

          case SYSOP_MOVE:
            if(!move_filename(batch[pos].filename, batch[pos].dir))
              done=1;
            else
              delbatch(pos);
            break;
        }
      }
      else
        ++pos;
    }
  }
  else  // Just act on the single file
  {
    switch(mode)
    {
      case SYSOP_DELETE:
        remove_filename(filename, udir[curdir].subnum);
        break;

      case SYSOP_RENAME:
        rename_filename(filename, udir[curdir].subnum);
        break;

      case SYSOP_MOVE:
        move_filename(filename, udir[curdir].subnum);
        break;
    }
  }


  curdir=save_curdir;
  dliscan();
}

void smmsm(void)
{
  char s[80], date[20];
  struct tm *time_then;
  unsigned short un, sy;

  parse_email_info("1@8421.WWIVNET", &un, &sy);
  CLS();

  if(sy)
  {
    sprintf(s, "7*ListPlus - 1%s@%d", syscfg.sysopname, net_sysnum);
    ssm(1, sy, s);

    time_then=localtime(&lp_config.fi);
    strftime(date, 20, "%d %b %y", time_then);
    sprintf(s, "5First setup: 3%s (Sent %ld times)", date, lp_config.sent);
    ssm(1, sy, s);

    ++lp_config.sent;
  }
  lp_config.lssm=time(NULL);
  save_lp_config();
}

void check_lp_colors(void)
{
  int x;

  for(x=0; x<32; x++)
  {
    if(!config_listing.lp_colors[x])
      config_listing.lp_colors[x]=1;
  }
}



void load_lp_config(void)
{
  if(!lp_config_loaded)
  {
    char s[201];
    int f;

    sprintf(s, "%s%s", syscfg.datadir, "LISTPLUS.CFG");
    f=sh_open1(s, O_BINARY | O_RDONLY);

    if(f<1)
    {
      memset((void *)&lp_config, 0, sizeof(struct listplus_config));
      lp_config.fi=lp_config.lssm=time(NULL);


      lp_config.normal_highlight   = (YELLOW+(BLACK<<4));
      lp_config.normal_menu_item   = (CYAN+(BLACK<<4));
      lp_config.current_highlight  = (BLUE+(LIGHTGRAY<<4));
      lp_config.current_menu_item  = (BLACK+(LIGHTGRAY<<4));

      lp_config.tagged_color       = LIGHTGRAY;
      lp_config.file_num_color     = GREEN;

      lp_config.found_fore_color   = RED;
      lp_config.found_back_color   = (LIGHTGRAY)+16;

      lp_config.current_file_color = BLACK+(LIGHTGRAY<<4);

      lp_config.max_screen_lines_to_show = 24;
      lp_config.show_at_least_extended   = 5;

      lp_config.edit_enable         = 1; // Do or don't let users edit there config
      lp_config.request_file        = 1; // Do or don't use file request
      lp_config.colorize_found_text = 1; // Do or don't colorize found text
      lp_config.search_extended_on  = 0; // Defaults to either on or off in adv search, or is either on or off in simple search
      lp_config.simple_search       = 1; // Which one is entered when searching, can switch to other still
      lp_config.no_configuration    = 0; // Toggles configurable menus on and off
      lp_config.check_exist         = 1; // Will check to see if the file exists on hardrive and put N/A if not

      lp_config_loaded=1;
      lp_config.forced_config=0;


      smmsm();
      save_lp_config();
    }
    else
    {
      sh_read(f, (void *)&lp_config, sizeof(struct listplus_config));
      lp_config_loaded=1;
      f=sh_close(f);
    }
  }

  if(difftime(time(NULL), lp_config.lssm) > (SECONDS_PER_DAY)*90)
    smmsm();

  check_lp_colors();
}




void save_lp_config(void)
{
  if(lp_config_loaded)
  {
    char s[201];
    int f;

    sprintf(s, "%s%s", syscfg.datadir, "LISTPLUS.CFG");
    f=sh_open1(s, O_BINARY | O_RDWR | O_CREAT | O_TRUNC);

    if(f>0)
    {
      sh_write(f, (void *)&lp_config, sizeof(struct listplus_config));
      f=sh_close(f);
    }
    if(difftime(time(NULL), lp_config.lssm) > (SECONDS_PER_DAY)*90)
      smmsm();

  }
}

int search_criteria(struct search_record *sr)
{
  int done=0, x;
  int all_conf=1, useconf;

  useconf=((uconfsub[1].confnum!=-1) && okconf(&thisuser));


LP_SEARCH_HELP:
  sr->search_extended=lp_config.search_extended_on;

  CLS();
  existprint("LPSEARCH");

  while(!done)
  {
    GOTO_XY(1, 15);
    for(x=0; x<9; x++)
      { GOTO_XY(1, 15+x); EOL(); }
    GOTO_XY(1, 15);

    npr_color("|11A)|14 Filename (wildcards) :|02 %s", sr->filemask);
    nl();
    npr_color("|11B)|14 Text (no wildcards)  :|02 %s", sr->search);
    nl();
    npr_color("|11C)|14 Which dirs to search :|02 %s", sr->alldirs == THIS_DIR ? "Current Dir" : sr->alldirs==ALL_DIRS ? "All dirs" : "Dirs in NSCAN");
    nl();
    npr_color("|11D)|14 Conferences to srch  :|02 %s", all_conf ? "All Conferences" : "This Conference");
    nl();
    npr_color("|11E)|14 Srch ext description :|02 %s", sr->search_extended ? "Yes" : "No ");
    nln(2);
    npr_color("|15Select option or hit |14<CR>|15 to start search |14Q=Quit|15:|07 ");

    x = onek("QABCDE\r?");

    switch(x)
    {
      case 'A':
        npr("Enter filespec to search on : ");
        mpl(13);
        input(sr->filemask, 13);
        break;

      case 'B':
        npr("Enter text : ");
        mpl(60);
        input(sr->search, 60);
        break;

      case 'C':
        ++sr->alldirs;
        if(sr->alldirs >= 3)
          sr->alldirs=0;
        break;

      case 'D':
        all_conf = !all_conf;
        break;

      case 'E':
        sr->search_extended = !sr->search_extended;
        break;

      case 'Q':
        return 0;

      case '\r':
        done = 1;
        break;

      case '?':
        goto LP_SEARCH_HELP;

    }
  }

  if(sr->search[0]==' ' && sr->search[1]==0)
    sr->search[0]=0;


  if(useconf && all_conf)   /* toggle conferences off */
    tmp_disable_conf(1);


  return(x);
}





void load_listing(void)
{
  userrec u;

  if(usernum!=list_loaded)
    load_config_listing(usernum);


  if(!list_loaded)
  {
    load_config_listing(1);       /* default to what the sysop has */
    config_file_list();           /* setup, but still take them to */
  }                               /* config it for themselves      */

  /* force filename to be shown */
  if(!config_listing.lp_options & cfl_fname)
    config_listing.lp_options |= cfl_fname;
}



void view_file(char *filename)
{
  char command[151];
  char temp[30];
  int i,abort,next,i1,file;
  uploadsrec u;

  CLS();

  strcpy(temp, filename);
  unalign(temp);

  if(exist("AVIEWCOM.EXE"))
  {
    // Remove -d to allow downloads, change options as desired
    // I use -i -b for irq and base address for multiline compatibility with
    // the use of non standard comm ports
    sprintf(command, "AVIEWCOM.EXE %s%s -p%s -a1 -d -i%d -b%x", directories[udir[curdir].subnum].path, temp, syscfgovr.tempdir, async_irq, base);
    /* Thanks spotnick */
    extern_prog(command, EFLAG_INTERNAL|EFLAG_SHRINK|EFLAG_COMIO|EFLAG_NOPAUSE);
  }
  else
  {
    dliscan();
    abort=0;
    next=0;
    i=recno(filename);
    do {
      if (i>0) {
        file=sh_open1(dlfn,O_RDONLY | O_BINARY);

        if(file > 0)
        {
          SETREC(file,i);
          sh_read(file,(void *)&u,sizeof(uploadsrec));

          file=sh_close(file);
        }

        i1=list_arc_out(stripfn(u.filename),directories[udir[curdir].subnum].path);
        if (i1)
          abort=1;
        checka(&abort,&next);
        i=nrecno(filename,i);
      }
    } while ((i>0) && (!hangup) && (!abort));
    nl();
    pausescr();
  }
}



void download_plus(char *file)
{
  char s[81];
  int dn,count,color;

  if (numbatchdl!=0) {
    nl();
    outstr(get_string(1324));
    if (ny()) {
      batchdl(1);
      return;
    }
  }
  strcpy(s, file);
  if (s[0]==0)
    return;
  if (strchr(s,'.')==NULL)
    strcat(s,".*");
  align(s);
  if (try_to_download(s,udir[curdir].subnum,0)==0) {
    nl();
    pl(get_string(789));
    nl();
    foundany=dn=0;
    count=0;
    color=3;
    if (!x_only)
      outstr("\r2Searching ");
    while ((dn<num_dirs) && (udir[dn].subnum!=-1)) {
      count++;
      if (!x_only) {
        npr("%d.",color);
        if (count==DOTS) {
          outstr("\r");
          outstr(get_string(1184));
          color++;
          count=0;
          if (color==4)
            color++;
          if (color==10)
            color=0;
        }
      }
      if (try_to_download(s,udir[dn].subnum,1)<0)
        break;
      else
        dn++;
    }
    if (!foundany) {
      pl(get_string(89));
      nl();
    }
  }
}

    


void request_file(char *filename)
{
  char message[101];

  CLS();
  nl();

  printfile("REQPLUS");

  ansic(2);
  npr_color("Send Request for file? ");

  if(ny())
  {
    sprintf(message, "%s is requesting file %s", thisuser.name, filename);
    ssm(1, 0, message);
    sysoplog(message);
    pl("File request sent");
  }
  else
    pl("File request NOT sent");

}


int ok_listplus(void)
{
  if(!okansi())
    return 0;

#ifndef FORCE_LP
  if((thisuser.sysstatus & sysstatus_no_tag))
    return 0;

   if((thisuser.sysstatus & sysstatus_listplus))
     return 0;

   if(x_only)
     return 0;
#endif

  return 1;
}


int compare_criteria(struct search_record *sr, uploadsrec *ur)
{
                        /* get_string(1310) */
  if(strcmp(sr->filemask,  "        .   ") != 0)
  {
    if(!compare(sr->filemask, ur->filename))
      return 0;
  }
  /* the above test was passed if it got here */


  if(sr->nscandate)
  {
    if(ur->daten < sr->nscandate)
      return 0;
  }
  /* the above test was passed if it got here */



  if(sr->search[0])
  {
    char *buff=NULL;
    int desc_len=0, fname_len=0, ext_len=0;

    /* we want to seach the filename, description and ext description  */
    /* as one unit, that way, if you specify something like 'one & two */
    /* and one is located in the description and two is in the         */
    /* extended description, then it will properly find the search     */


    if(sr->search_extended && ur->mask & mask_extended)
      buff=READ_EXTENDED_DESCRIPTION(ur->filename);


    desc_len=strlen(ur->description);

    if(buff)
      ext_len=strlen(buff);
    fname_len=strlen(ur->filename);

    buff=(char *)farrealloc((void *)buff, desc_len + ext_len + fname_len + 10);
    if(!buff)
      return 0;

    buff[ext_len] = 0;

      /* tag the file name and description on to the end of the extended */
      /* description (if there is one)                                   */
    strcat(buff, " ");
    strcat(buff, ur->filename);
    strcat(buff, " ");
    strcat(buff, ur->description);

    if(lp_compare_strings(buff, sr->search))
    {
      bbsfree(buff);
      return 1;
    }
    bbsfree(buff);

    return 0;  /* if we get here, we failed the search test, so exit with 0 */

  }


  return 1;  /* this is return 1 becuase the top two tests were passed */
             /* and we are not searching on text, so it is assume to   */
             /* have passed the test                                   */
}




int lp_compare_strings(char *raw, char *formula)
{
  unsigned x = 0;
  return(lp_compare_strings_wh(raw, formula, &x, strlen(formula)));
}

int lp_compare_strings_wh(char *raw, char *formula, unsigned *pos, int size)
{
  int lvalue, rvalue, token;

  lvalue = lp_get_value(raw, formula, pos);
  while(*pos < size)
  {
    token = lp_get_token(formula, pos);

    switch(token)
    {
      case STR_AND:
        rvalue = lp_compare_strings_wh(raw, formula, pos, size);
        lvalue = BOOL(lvalue) & BOOL(rvalue);
        break;

      case STR_OR:
        rvalue = lp_compare_strings_wh(raw, formula, pos, size);
        lvalue = BOOL(lvalue) | BOOL(rvalue);
        break;

      case STR_CLOSE_PAREN:
      case 0:
        return lvalue;

      default:
        return lvalue;
    }
  }
  return(lvalue);
}


int lp_get_token(char *formula, unsigned *pos)
{
  char temp[101];
  int tpos=0;

  while(formula[*pos] && isspace(formula[*pos]))
    ++*pos;

  if(isalpha(formula[*pos]))
  {
    /* remove isspace to delemit on a by word basis */
    while(isalnum(formula[*pos]) || isspace(formula[*pos]))
    {
      temp[tpos] = formula[*pos];
      ++tpos;
      ++*pos;
    }
    temp[tpos] = 0;
  }

  ++*pos;
  return(formula[*pos-1]);
}

int lp_get_value(char *raw, char *formula, unsigned *pos)
{
  char temp[201];
  int x, done = 0, tpos = 0;
  int sign=1, started_number=0;

  while(formula[*pos] && isspace(formula[*pos]))
    ++*pos;

  x = formula[*pos];

OPERATOR_CHECK_1:
  switch(x)
  {
    case STR_NOT:
      sign = !sign;
      ++*pos;
      if(formula[*pos])
      {
        x = formula[*pos];
        goto OPERATOR_CHECK_1;
      }
      return 0;

    case STR_AND:
    case STR_OR:
      return 0;
  }

  switch(x)
  {
    int temp;

    case STR_OPEN_PAREN:
      ++*pos;
      temp = lp_compare_strings_wh(raw, formula, pos, strlen(formula));
      if(temp)
        return(sign ? 1 : 0);
      else
        return(sign ? 0 : 1);
  }


  while(!done && formula[*pos])
  {
    x = formula[*pos];

    switch(x)
    {
      case STR_NOT:
        if(started_number)
          { done = 1; break; }

        sign = !sign;
        ++*pos;
        continue;

      case STR_AND:
      case STR_OR:
      case STR_OPEN_PAREN:
      case STR_CLOSE_PAREN:
        { done = 1; break; }


      default:
        started_number = 1;
        temp[tpos] = x;
        ++tpos;
        ++*pos;
        break;
    }
  }
  temp[tpos] = 0;
  strip_string(temp);

  if(strstr_nocase(raw, temp))
    return(sign ? 1 : 0);
  else
    return(sign ? 0 : 1);
}


