Ŀ
 Mod Name: Guest11.mod v1.1     Mod Author(s): Arc Angel    WWIVNet 1@4067  
 Difficulty: Fairly easy, nothing too bizarre                               
 WWIV Version: WWIV v4.22       Date: 10/10/93                              
 Files Affected: bbs.c,bbsutil.c,bbsutil1.c,lilo.c,newuser.c,utility.c,...  
 Description: Adds an easy to use guest account to WWIV                     


Extended:   The Guest mod allows you to make a guest account on the BBS that 
            can be used by multiple users without an account. The mod assumes 
            you will make the guest account and set it's security levels, 
            restrictions, ARs, and DARs to your liking. NOTE: to make the 
            account a guest account, it is only important that you set the G 
            (guest) restriction on the account. You should probably also edit 
            the logon prompt if your guest account is not named "GUEST". The
            mod is hard coded to allow 10 minutes per call on all guest 
            logons. Because the guest account is shared by multiple users, 
            certain restrictions are hard coded. A guest account cannot edit 
            it's defaults. A guest account cannot kill (and thus read) email 
            it has sent. It is up to the sysop to set all other restrictions 
            desired on a guest account.

            Changes from v1.0 of Guest mod:
              1) Guests are asked for their name, and their response is noted
                 at the top of any email they send. Their connect speed is
                 also noted.
              2) ssm's (one line notes) sent to guests are not shown to them
              3) I decided to let the guests upload...
              4) A rather nasty bug that let guests see all file areas that
                 user number 1 can see (if they logged on following a nup
                 entry failure) was found and fixed.

Disclaimer: I am not responsible for any problems or complications due to your
            use of this modification. I urge you to make a full backup of your
            BBS and keep it for at least a few weeks after beginning to use
            your new code.

Key         +  Add this Line



diff -H -b -p ./bbs.c Guest/bbs.c
*** ./bbs.c        Mon Jan 11 19:37:54 1993
--- guest/bbs.c        Sun Oct 10 00:14:42 1993
*************** void send_email(void)
*** 339,344 ****
--- 339,347 ----
    helpl=0;
    irt[0]=0;
    irt_name[0]=0;
+   /* Guest MOD */ if (guest())
+   /* Guest MOD */   sprintf(irt_name,"Guest (%.30s) connected at %s.",guest_name,curspeed);
+   /* Guest MOD */ else
    parse_email_info(s1,&un,&sy);
    grab_quotes(NULL, NULL);
    if (un || sy)
*************** void mainmenu(void)
*** 630,635 ****
--- 633,642 ----
          break;
        case 'D':
          helpl=4;
+         /* Guest MOD */ if (guest()) {
+         /* Guest MOD */   pl("Guests may not change default settings.");
+         /* Guest MOD */   nl();
+         /* Guest MOD */ } else
          defaults();
          break;
        case 'E':
*************** void mainmenu(void)
*** 638,643 ****
--- 645,653 ----
        case 'F':
          strcpy(irt,get_stringx(1,14));
          irt_name[0]=0;
+         /* Guest MOD */ if (guest())
+         /* Guest MOD */   sprintf(irt_name,"Guest (%.30s) connected at %.10s.",guest_name,curspeed);
+         /* Guest MOD */ else
          grab_quotes(NULL, NULL);
          email(1,0,0,0);
          break;
*************** void mainmenu(void)
*** 654,659 ****
--- 664,670 ----
          break;
        case 'K':
          helpl=8;
+         /* Guest MOD */ if (!guest())
          kill_old_email();
          break;
        case 'L':



diff -H -b -p ./bbsutl.c Guest/bbsutl.c
*** ./bbsutl.c        Fri Jan 08 21:42:12 1993
--- guest/bbsutl.c        Sun Oct 10 00:14:42 1993
*************** void reqchat(void)
*** 468,473 ****
--- 468,476 ----
      nl();
      pl(get_string(601));
      strcpy(irt,get_stringx(1,34));
+     /* Guest MOD */ if (guest())
+     /* Guest MOD */   sprintf(irt_name,"Guest (%.30s) connected at %.10s.",guest_name,curspeed);
+     /* Guest MOD */ else
      irt_name[0]=0;
      imail(1,0);
    }



diff -H -b -p ./bbsutl1.c Guest/bbsutl1.c
*** ./bbsutl1.c        Thu Dec 03 19:55:22 1992
--- guest/bbsutl1.c        Sun Oct 10 00:15:00 1993
*************** void rsm(int un, userrec *u)
*** 242,247 ****
--- 242,248 ----
        lseek(f,((long) (i1)) * sizeof(shortmsgrec),SEEK_SET);
        read(f,(void *)&sm,sizeof(shortmsgrec));
        if ((sm.touser==un) && (sm.tosys==0)) {
+         /* Guest MOD */ if (sm.touser==usernum && !guest())
          pl(sm.message);
          sm.touser=0;
          sm.tosys=0;



diff -H -b -p ./fcns.h Guest/fcns.h
*** ./fcns.h        Tue Sep 07 21:40:24 1993
--- guest/fcns.h        Sun Oct 10 00:15:14 1993
*************** void detect_multitask(void);
*** 327,332 ****
--- 327,333 ----
  void giveup_timeslice(void);
  void begin_crit(void);
  void end_crit(void);
+ int guest(void);
  
  

diff -H -b -p ./lilo.c Guest/lilo.c
*** ./lilo.c        Thu Dec 03 19:55:02 1992
--- guest/lilo.c        Sun Oct 10 00:14:46 1993
*************** void getuser(void)
*** 82,87 ****
--- 82,88 ----
        actsl = syscfg.newusersl;
        topscreen();
        ok=1;
+       /* Guest MOD */ if (!guest()) {
        outstr(get_string(357));
        echo=0;
        input(s,8);
*************** void getuser(void)
*** 108,113 ****
--- 109,115 ----
            ok=0;
        }
        echo=1;
+       /* Guest MOD */ }
        if (ok) {
          reset_act_sl();
          changedsl();
*************** void logon(void)
*** 219,225 ****
--- 221,234 ----
    char s[255],s1[181],s2[81],*ss;
    int i,i1,f;
    long len,pos;
+   /* Guest MOD */ char s3[255];
  
+   /* Guest MOD */ if (guest()) {
+   /* Guest MOD */   outstr("Who are you? ");
+   /* Guest MOD */   mpl(30);
+   /* Guest MOD */   input1(guest_name,30,1,1);
+   /* Guest MOD */   sprintf(s3,"   The guest account was being used by: %.30s",guest_name);
+   /* Guest MOD */ }
    if (usernum<1) {
      hangup=1;
      return;
*************** void logon(void)
*** 292,297 ****
--- 301,309 ----
    if ((actsl!=255) || (incom)) {
      sl1(0,"");
      sl1(0,s);
+     /* Guest MOD */ if (guest()) {
+     /* Guest MOD */   sl1(0,s3);
+     /* Guest MOD */ }
      sl1(1,"");
      sprintf(s,"%ld: %s   %s - %d\r\n",
            status.callernum1,
*************** void logon(void)
*** 390,395 ****
--- 402,408 ----
      }
  
      nl();
+     /* Guest MOD */ if (!guest())
      if (thisuser.forwardusr) {
        if (thisuser.forwardsys) {
          set_net_num(thisuser.net_num);
*************** void logoff(void)
*** 527,532 ****
--- 540,548 ----
    thisuser.daten=l;
    close_user();
    write_user(usernum,&thisuser);
+   /* Guest MOD */ if (guest())
+   /* Guest MOD */   for (i=0; i<max_subs; i++)
+   /* Guest MOD */     qsc_p[i]=0L;
    write_qscn(usernum,qsc,0);
    close_user();
  



diff -H -b -p ./newuser.c Guest/newuser.c
*** ./newuser.c        Tue Dec 08 19:35:02 1992
--- guest/newuser.c        Sun Oct 10 00:14:50 1993
*************** void newuser(void)
*** 550,555 ****
--- 550,577 ----
          sl1(0,s1);
        }
      } while ((!ok) && (!hangup) && (i++<4));
+     /* Guest MOD */ if (!ok && (usernum=finduser("GUEST"))>0) {
+     /* Guest MOD */   outstr("\nWould you like to log onto the guest account? ");
+     /* Guest MOD */   if (yn()) {
+     /* Guest MOD */     read_user(usernum,&thisuser);
+     /* Guest MOD */     read_qscn(usernum,qsc,0);
+     /* Guest MOD */     actsl = syscfg.newusersl;
+     /* Guest MOD */        reset_act_sl();
+     /* Guest MOD */        changedsl();
+     /* Guest MOD */     topscreen();
+     /* Guest MOD */     return;
+     /* Guest MOD */   }
+     /* Guest MOD */   outstr("\nWould you like to leave feedback to the sysop? ");
+     /* Guest MOD */   if (yn()) {
+     /* Guest MOD */     outstr("Who are you? ");
+     /* Guest MOD */     mpl(30);
+     /* Guest MOD */     input(guest_name,30);
+     /* Guest MOD */     sprintf(irt,"Failed to enter a valid NUP.");
+     /* Guest MOD */     sprintf(irt_name,"Guest (%.30s) connected at %.10s.",guest_name,curspeed);
+     /* Guest MOD */     grab_quotes(NULL, NULL);
+     /* Guest MOD */     email(1,0,1,0);
+     /* Guest MOD */   }
+     /* Guest MOD */ }
      if (!ok)
        hangup=1;
    }



diff -H -b -p ./utility.c Guest/utility.c
*** ./utility.c        Thu Dec 03 19:55:56 1992
--- guest/utility.c        Sun Oct 10 00:14:56 1993
*************** void frequent_init(void)
*** 440,445 ****
--- 440,446 ----
    set_x_only(0, NULL, 0);
    set_net_num(0);
    set_language(0);
+   /* Guest MOD */ guest_name[0]=0;
  }
  
  
*************** double nsl(void)
*** 706,711 ****
--- 707,714 ----
      tlt = tpd - tot - ((double) thisuser.timeontoday) + (thisuser.extratime);
  
      tlt=(((tlc)<(tlt)) ? (tlc) : (tlt));
+     /* Guest MOD */ if (guest())
+     /* Guest MOD */   tlt=10.0 * 60.0 - tot + extratimecall;
      if (tlt<0.0)
        tlt=0.0;
      if (tlt>32767.0)
*************** void end_crit(void)
*** 1141,1143 ****
--- 1144,1150 ----
      geninterrupt(0x15);
    }
  }
+ /* Guest MOD */ int guest(void)
+ /* Guest MOD */ {
+ /* Guest MOD */   return(thisuser.restrict & restrict_guest);
+ /* Guest MOD */ }



diff -H -b -p ./vardec.h Guest/vardec.h
*** ./vardec.h        Thu Dec 17 17:49:10 1992
--- guest/vardec.h        Sun Oct 10 00:15:02 1993
*************** typedef enum {
*** 488,494 ****
--- 488,498 ----
  #define restrict_net 0x0200
  #define restrict_upload 0x0400
  
+ /* Guest MOD
  #define restrict_string "LCMA*PEVKNU     "
+ Guest MOD */
+ /* Guest MOD */ #define restrict_guest 0x0800
+ /* Guest MOD */ #define restrict_string "LCMA*PEVKNUG    "
  
  /* userrec.sysstatus */
  #define sysstatus_ansi 0x0001



diff -H -b -p ./vars.h Guest/vars.h
*** ./vars.h        Wed Dec 16 15:36:48 1992
--- guest/vars.h        Sun Oct 10 00:15:02 1993
*************** __EXTRN__ char ansistr[81], cdir[81], ch
*** 74,79 ****
--- 74,80 ----
                 search_pattern[81], *sp, str_no[20], str_pause[80],
                 str_quit[20], str_yes[20], tc[81], ver_no1[51],
                 ver_no2[51],wwiv_net_no[20], xdate[9], *xenviron[50];
+ /* Guest MOD */ __EXTRN__ char guest_name[31];
  
  __EXTRN__ unsigned char actsl, andwith, checksum;



Other modifications by Arc Angel

Filename      Ver     Date     Description

1usenup.mod   1.0   09/06/93   Uses nup's from a list (deleted after 1 use)
422ml.mod     1.2   06/03/93   Adds multiline capability to WWIV v4.22
Merge.mod     1.1   10/09/93   Allows full control over WWIV network gating

