;***************************************;
;  B I O S   V E C T O R   A R E A S    ;
;***************************************;
;
;
TIMER_INT_IP		EQU	0020H	;INTERRUPT 08H
TIMER_INT_CS		EQU	0022H	;
;
VIDEO_IO_IP		EQU	0040H	;INTERRUPT 10H
VIDEO_IO_CS		EQU	0042H	;
;
BOOT_STRAP_IP		EQU	0064H	;INTERRUPT 19H
BOOT_STRAP_CS		EQU	0066H	;
;
VIDEO_GRAPHICS_IP	EQU	007CH	;INTERRUPT 1FH
VIDEO_GRAPHICS_CS	EQU	007EH	;
;
;***************************************;
;  B I O S    D A T A    A R E A S      ;
;***************************************;
;
EQUIP_FLAG		EQU	0410H	;Installed Hardware (See INT 11H)
MEMORY_SIZE		EQU	0413H	;Memory Size in K Bytes
CRT_MODE		EQU	0449H	;Current CRT Mode
CRT_COLS		EQU	044AH	;Number of Columns on Screen
CRT_LEN			EQU	044CH	;Length of REGEN in Bytes
CRT_START		EQU	044EH	;Starting Address in REGEN Buffer
CURSOR_POSN		EQU	0450H	;Cursor for each of up to 8 Pages
CURSOR_MODE		EQU	0460H	;Current Cursor Mode Setting
ACTIVE_PAGE		EQU	0462H	;Current Page being displayed
ADDR_6845		EQU	0463H	;Base Address for Active Display Card
CRT_MODE_SET		EQU	0465H	;Current Setting of the 3x8 Register
CRT_PALETTE		EQU	0466H	;Current Palette Setting (Color Card)
;
;***************************************;
;  P O R T    A S S I G N M E N T S     ;
;***************************************;
;
;	IBM PC&AT PORT ASSIGNMENTS
;
DMA			EQU	0000H	;1st DMA Ch.0 Addr. Reg Port Addr (PC)
DMA08			EQU	0008H	;1st DMA Status Reg Port Addr (PC)
INTA00			EQU	0020H	;1st 8259 Interrupt Controller 00
INTA01			EQU	0021H	;1st  "       "         "      01
TIMER0			EQU	0040H	;8253 Timer/Counter 0 Port Addr
TIM_CTL			EQU	0043H	;8253 Timer Control Port Addr
PORT_A			EQU	0060H	;8255 Port A (Keybd Scan Code Port)
PORT_B			EQU	0061H	;8255 Port B Addr (Read/Write Reg.)
PORT_C			EQU	0062H	;8255 Port C Addr
CMD_PORT		EQU	0063H	;
STATUS_PORT		EQU	0064H	;8042 Status Port
CMOS_PORT		EQU	0070H	;I/O Address of CMOS Port
INTB00			EQU	00A0H	;2nd 8259 Interrupt Controller 00
INTB01			EQU	00A1H	;2nd  "       "         "      01
DMA1			EQU	00C0H	;2nd DMA Ch.0 Base and Current Addr
DMA18			EQU	00D0H	;2nd DMA Status Reg Port Addr
;
;
;Monochrome Adapter
;
MONO_INDEX		EQU	03B4H	;6845 Index Register
MONO_DATA		EQU	03B5H	;6845 Data Register
MONO_CRT_CONTROL1	EQU	03B8H	;CRT Control Port 1
MONO_CRT_STATUS		EQU	03BAH	;CRT Status Port
MONO_PARALLEL_DATA	EQU	03BCH	;Parallel Data Port
MONO_PRINTER_STATUS	EQU	03BDH	;Printer Status Port
MONO_PRINTER_CONTROL	EQU	03BEH	;Printer Control Port
;
;Color/Graphics Adapter
;
COLOR_MODE_CONTROL	EQU	03D8H	;Mode Control Register
COLOR_SELECT		EQU	03D9H	;Color Select Register
COLOR_STATUS		EQU	03DAH	;Status Register
CLEAR_LIGHT_PEN		EQU	03DBH	;Clear Light Pen Latch
PRESET_LIGHT_PEN	EQU	03DCH	;Preset Light Pen Latch
COLOR_INDEX		EQU	03D4H	;6845 Index Register
COLOR_DATA		EQU	03D5H	;6845 Data Register
;
;HERCULES MONOCHROME GRAPHICS ADAPTER
;
HERC_MONO_INDXREG	EQU	03B4H	; 6845 Index Register (OUT)
HERC_MONO_DATAREG	EQU	03B5H	; 6845 Data Register (IN/OUT)
HERC_MONO_DSPMODE	EQU	03B8H	; Display Mode Ctrl Port (OUT)
HERC_MONO_SETLPEN	EQU	03B9H	; Set Light Pen Flip Flop (OUT)
HERC_MONO_DSPSTAT	EQU	03BAH	; Display Status Port (IN)
HERC_MONO_RSTLPEN	EQU	03BBH	; Reset Light Pen Flip Flop (OUT)
HERC_MONO_PRTDATA	EQU	03BCH	; Printer Data Port (IN/OUT)
HERC_MONO_PRTSTAT	EQU	03BDH	; Printer Status Port (IN)
HERC_MONO_PRTCNTL	EQU	03BEH	; Printer Control Port (IN/OUT)
HERC_MONO_CONFIG	EQU	03BFH	; Configuration Switch
HERC_MONO_PAGE0		EQU	0B000H	; Power On Default Display Page
HERC_MONO_PAGE1		EQU	0B800H	; Graphics Page Number
;
