	PAGE	60,132
	NAME	SIMCGA
	TITLE	SIMCGA - Simulate a CGA with a Hercules Mono/Graphics Board
	.XLIST
	INCLUDE	SIMCGA.INC
	.LIST
;
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE
SIMCGA	PROC	FAR
	ORG	0100H
BEGIN:	JMP	START
L0103	DW	0132H
OLD_INTERRUPT_10H LABEL DWORD			;VIDEO I/O
L0105	DW	0000H
L0107	DW	0000H
L0108	EQU	$-1
OLD_INTERRUPT_19H LABEL DWORD			;BOOT STRAP
L0109	DW	0000H
L010B	DW	0000H
L010D	DB	00H
L010E	DB	00H
L010F	DB	00H
L0110	DB	00H
L0111	DB	07H
L0112	DB	00H
L0113	DB	00H
L0114	DB	00H
L0115	DB	00H
L0116	DB	00H
L0117	DW	0800H
L0119	DB	02H
L011A	DB	0CDH,08H,0CFH
	DB	0CDH,09H,0CFH
	DB	0CDH,0AH,0CFH
	DB	0CDH,0BH,0CFH
	DB	0CDH,0CH,0CFH
	DB	0CDH,0DH,0CFH
	DB	0CDH,0EH,0CFH
	DB	0CDH,0FH,0CFH
ERROR1	DB	0DH,0AH,'Monochrome Graphics adapter not present',0DH,0AH,'$'
ERROR2	DB	0DH,0AH,'No emulation - CGA active',0DH,0AH,'$'
ERROR3	DB	0DH,0AH,'SIMCGA Resident already loaded!',0DH,0AH
	DB	0DH,0AH,'CGA emulation enabled',0DH,0AH,'$'
BANNER	DB	0DH,0AH,'SIMCGA 4.0',0DH,0AH
	DB	'Copyright 1986, 1987, Sydex and C. P. Guzis',0DH,0AH
	DB	'153 North Murphy Ave.',0DH,0AH
	DB	'Sunnyvale, CA  94086',0DH,0AH
	DB	'All Rights Reserved',0DH,0AH
	DB	0DH,0AH,'SIMCGA Resident loaded',0DH,0AH
	DB	'CGA emulation enabled',0DH,0AH,'$'
ERROR4	DB	0DH,0AH,'You are using a Monochrome graphics adapter',0DH,0AH
	DB	'which is not entirely compatible with the',0DH,0AH
	DB	'Hercules Display adapter.  Certain CGA text',0DH,0AH
	DB	'modes may not give accurate displays',0DH,0AH,'$'
ERROR5	DB	0DH,0AH,' ERROR - SIMCGA will not work with an '
	DB	'Enhanced Graphics Adapter.',0DH,0AH,'$'
L035B	DB	0DH,0AH,'Installation complete - Press any key to reboot$'
START:	MOV	AH,0C1H				;Has SIMCGA been Installed?
	INT	10H				;Perform Video Processing
	CMP	AX,0AAAAH			;Check Return Code
	JNE	INSTALL
	MOV	AX,0002H
	INT	10H				;Perform Video Processing
	LEA	DX,DS:[ERROR3]
	MOV	AH,09H				;Setup for Display
	INT	21H				;DOS Function Call
EXIT:	MOV	AX,4C00H			;Return to DOS with Err Code 0
	INT	21H				;DOS Function Call
INSTALL:
	MOV	AH,0FH				;Check Video Mode
	INT	10H				;Perform Video Processing
	CMP	AL,07H				;Is it Monochrome?
	JE	NEXT1				;Yes - continue
	LEA	DX,DS:[ERROR2]			;No - CGA present
	MOV	AH,09H				;Setup for Display
	INT	21H				;DOS Function Call
	JMP	SHORT EXIT
;
NEXT1:	PUSH	ES
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,03H
	OUT	DX,AL
	XOR	AX,AX
	MOV	ES,AX
	MOV	AX,WORD PTR ES:[BOOT_STRAP_IP]
	MOV	WORD PTR ES:[000CH],AX
	MOV	AX,0C000H
	MOV	ES,AX
	CMP	WORD PTR ES:[0000H],0AA55H
	JNE	L03E8
	LEA	DX,DS:[ERROR5]
	MOV	AH,09H				;Setup for Display
	INT	21H				;DOS Function Call
	MOV	AX,4C01H			;Return to DOS with Err Code 1
	INT	21H				;DOS Function Call
L03E8:	MOV	AX,HERC_MONO_PAGE0
	MOV	ES,AX
	MOV	WORD PTR ES:[3FFEH],162EH
	MOV	WORD PTR ES:[7FFEH],04D2H
	CMP	WORD PTR ES:[7FFEH],04D2H
	JNE	L041D
	CMP	WORD PTR ES:[3FFEH],162EH
	JNE	L041D
	MOV	WORD PTR ES:[8FFEH],2694H
	CMP	WORD PTR ES:[8FFEH],2694H
	JE	L047D
L041D:	MOV	DX,HERC_MONO_DSPMODE
	MOV	AL,03H
	CLI
	OUT	DX,AL
	MOV	WORD PTR ES:[3FFEH],162EH
	MOV	WORD PTR ES:[7FFEH],04D2H
	CMP	WORD PTR ES:[7FFEH],04D2H
	JNE	L046B
	CMP	WORD PTR ES:[3FFEH],162EH
	JNE	L046B
	MOV	AL,83H
	OUT	DX,AL
	MOV	WORD PTR ES:[8FFEH],1538H
	CMP	WORD PTR ES:[8FFEH],1538H
	JNE	L046B
	MOV	AL,29H
	OUT	DX,AL
	STI
	LEA	DX,DS:[ERROR4]
	MOV	AH,09H				;Setup for Display
	INT	21H				;DOS Function Call
	MOV	CS:[L010D],0FFH
	JMP	SHORT L047D
L046B:	MOV	AL,29H
	OUT	DX,AL
	STI
	POP	ES
	LEA	DX,DS:[ERROR1]
	MOV	AH,09H				;Setup for Display
	INT	21H				;DOS Function Call
	MOV	AX,4C01H			;Return to DOS with Err Code 1
	INT	21H				;DOS Function Call
L047D:	POP	ES
	CALL	L05AE
	CALL	L05D3
	TEST	CS:[L010F],0FFH
	JE	L04C4
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	BX,DS:[MEMORY_SIZE]
	LEA	AX,DS:[204CH]
	MOV	AL,AH
	XOR	AH,AH
	SHR	AX,1
	SHR	AX,1
	SUB	BX,AX
	MOV	DS:[MEMORY_SIZE],BX
	MOV	CL,06H
	SHL	BX,CL
	POP	DS
	MOV	ES,BX
	XOR	SI,SI
	XOR	DI,DI
	LEA	CX,DS:[L1C4E]
	SHR	CX,1
	CLD
	REPZ	MOVSW
	MOV	DS,BX
	PUSH	BX
	LEA	AX,DS:[L04C4]
	PUSH	AX
	RETF 
;
L04C4:	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	CLI
	TEST	CS:[L010F],0FFH
	JNE	L04D5
	CALL	L0667
L04D5:	MOV	AX,WORD PTR DS:[VIDEO_IO_IP]
	MOV	CS:[L0105],AX
	MOV	AX,WORD PTR DS:[VIDEO_IO_CS]
	MOV	CS:[L0107],AX
	LEA	AX,DS:[NEW_INTERRUPT_10H]
	MOV	WORD PTR DS:[VIDEO_IO_IP],AX
	MOV	DS:[VIDEO_IO_CS],CS
	STI
	MOV	CS:[L0110],00H
	TEST	CS:[L010F],0FFH
	JNE	L0530
	MOV	AL,BYTE PTR CS:[L0108]
	AND	AL,0F0H
	CMP	AL,0F0H
	JE	L0515
	XOR	AX,AX
	INT	33H
	TEST	AX,AX
	JE	L0515
	MOV	CS:[L0110],0FFH
L0515:	CLI
	MOV	AX,WORD PTR DS:[BOOT_STRAP_IP]
	MOV	WORD PTR CS:[L0109],AX
	MOV	AX,WORD PTR DS:[BOOT_STRAP_CS]
	MOV	WORD PTR CS:[L010B],AX
	LEA	AX,DS:[NEW_BOOT_STRAP]
	MOV	WORD PTR DS:[BOOT_STRAP_IP],AX
	MOV	DS:[BOOT_STRAP_CS],CS
	STI
L0530:	POP	DS
	TEST	CS:[L010F],0FFH
	JNE	L054E
	MOV	AX,00F2H
	XOR	BX,BX
	INT	10H				;Perform Video Processing
	CMP	BYTE PTR DS:[L0119],02H
	JE	L054E
	MOV	AH,00H
	MOV	AL,BYTE PTR DS:[L0119]
	INT	10H				;Perform Video Processing
L054E:	LEA	DX,DS:[BANNER]
	MOV	AH,09H				;Setup for Display
	INT	21H				;DOS Function Call
	TEST	CS:[L010F],0FFH
	JE	L059A
	LEA	DX,DS:[L035B]
	MOV	AH,09H				;Setup for Display
	INT	21H				;DOS Function Call
	XOR	AH,AH
	INT	16H				;Perform Keyboard I/O
	MOV	AX,00F2H
	XOR	BX,BX
	INT	10H				;Perform Video Processing
	CMP	BYTE PTR DS:[L0119],02H
	JE	L057F
	MOV	AH,00H
	MOV	AL,BYTE PTR DS:[L0119]
	INT	10H				;Perform Video Processing
L057F:	MOV	BYTE PTR DS:[L010E],0FFH
	TEST	BYTE PTR CS:[L0115],0FFH
	JE	L0594
	CALL	L0667
	MOV	BYTE PTR DS:[L010E],00H
L0594:	XOR	AX,AX
	INT	19H				;Disk Boot
	INT	18H				;Transfer to BASIC
L059A:	LEA	DX,DS:[L1C5C]
	AND	DL,0F0H
	SHR	DX,1
	SHR	DX,1
	SHR	DX,1
	SHR	DX,1
	MOV	AX,3100H			;Terminate And Stay Resident
	INT	21H				;DOS Function Call
;
L05AE:
	LEA	SI,DS:[ERROR1]
	MOV	CX,1B1BH
	NOP
	XOR	AH,AH
	CLD
L05B9:	DB	2EH				;Address off of CS:
	LODSB
	ADC	AH,AL
	LOOP	L05B9
	JE	L05C4
	JMP	SHORT L05C5
	NOP
L05C4:	DB	0C3H	;RET
L05C5:	LEA	DI,CS:[0100H]
	MOV	CX,0DA6H
	MOV	AX,20CDH
	CLD
	JMP	L1C48
;
L05D3	PROC	NEAR
	MOV	CS:[L010F],00H
	MOV	BYTE PTR CS:[L0115],00H
	MOV	BYTE PTR CS:[L0119],02H
	MOV	BYTE PTR CS:[L0113],00H
	LEA	SI,DS:[0080H]
	CLD
	LODSB
	XOR	CH,CH
	MOV	CL,AL
	TEST	AL,AL
	JE	L060A
L05F9:	LODSB
	CMP	AL,20H
	JE	L0608
	CMP	AL,2CH
	JE	L0608
	CMP	AL,09H
	JE	L0608
	JMP	SHORT L060B
L0608:	LOOP	L05F9
L060A:	RET
L060B:	MOV	AH,AL
	AND	AL,40H
	SHR	AL,1
	NOT	AL
	AND	AL,AH
	CMP	AL,53H
	JNE	L0621
	MOV	CS:[L010F],0FFH
	JMP	SHORT L0608
L0621:	CMP	AL,49H
	JNE	L062D
	XOR	BYTE PTR CS:[L0115],0FFH
	JMP	SHORT L0608
L062D:	CMP	AL,30H
	JB	L0646
	CMP	AL,39H
	JNBE	L0646
	SUB	AL,30H
	MOV	AH,AL
	MOV	CS:[L0113],AH
	MOV	BYTE PTR CS:[L0114],00H
	JMP	SHORT L0608
L0646:	CMP	AL,48H
	JNE	L0651
	MOV	BYTE PTR DS:[L0119],06H
	JMP	SHORT L0608
L0651:	CMP	AL,4DH
	JNE	L065C
	MOV	BYTE PTR DS:[L0119],04H
	JMP	SHORT L0608
L065C:	CMP	AL,54H
	JNE	L0665
	MOV	BYTE PTR DS:[L0119],02H
L0665:	JMP	SHORT L0608
L05D3	ENDP
;
L0667	PROC	NEAR
	PUSH	AX
	TEST	BYTE PTR CS:[L0115],0FFH
	JE	L06DA
	CALL	L0778
	JB	L06DA
	MOV	BYTE PTR CS:[L0116],AL
	PUSH	SI
	PUSH	DI
	PUSH	CX
	PUSH	ES
	PUSH	DS
	SHL	AX,1
	SHL	AX,1
	MOV	DI,AX
	XOR	AX,AX
	MOV	ES,AX
	MOV	AX,CS
	MOV	DS,AX
	MOV	CX,0008H
	LEA	SI,DS:[L011A]
	CLD
L0694:	MOV	AX,SI
	STOSW
	MOV	AX,CS
	STOSW
	ADD	SI,+03H
	LOOP	L0694
	MOV	AL,BYTE PTR CS:[L0116]
	XOR	AH,AH
	MOV	DI,AX
	SHL	DI,1
	SHL	DI,1
	LEA	AX,DS:[L1A7A]
	STOSW
	MOV	ES:[DI],CS
	MOV	AX,0F000H
	MOV	DS,AX
	CMP	BYTE PTR DS:[0FFFEH],0FCH
	POP	DS
	POP	ES
	JE	L06FD
	CLI
	MOV	AL,13H
	OUT	INTA00,AL
	JMP	SHORT L06C8
L06C8:
	MOV	AL,BYTE PTR CS:[L0116]
	OUT	INTA01,AL
	JMP	SHORT L06D0
L06D0:	MOV	AL,0DH
	OUT	INTA01,AL
	STI
	POP	CX
	POP	DI
	POP	SI
	POP	AX
	RET
L06DA:	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	AX,WORD PTR DS:[TIMER_INT_IP]
	MOV	WORD PTR CS:[L1B02],AX
	MOV	AX,WORD PTR DS:[TIMER_INT_CS]
	MOV	WORD PTR CS:[L1B04],AX
	LEA	AX,DS:[NEW_INTERRUPT_08H]
	CLI
	MOV	WORD PTR DS:[TIMER_INT_IP],AX
	MOV	DS:[TIMER_INT_CS],CS
L06F6	EQU	$-3
	STI
	POP	DS
	POP	AX
	RET
L06FD:	MOV	AL,11H
	CLI
	OUT	INTA00,AL
	JMP	SHORT L0704
L0704:
	MOV	AL,BYTE PTR CS:[L0116]
	OUT	INTA01,AL
	JMP	SHORT L070C
L070C:	MOV	AL,04H
	OUT	INTA01,AL
	JMP	SHORT L0712
L0712:	MOV	AL,01H
	OUT	INTA01,AL
	MOV	AL,11H
	OUT	INTB00,AL
	JMP	SHORT L071C
L071C:	MOV	AL,70H
	OUT	INTB01,AL
	JMP	SHORT L0722
L0722:	MOV	AL,02H
	OUT	INTB01,AL
	JMP	SHORT L0728
L0728:	MOV	AL,01H
	OUT	INTB01,AL
	STI
	POP	CX
	POP	DI
	POP	SI
	POP	AX
	RET
L0667	ENDP
;
L0732	PROC	NEAR
	TEST	BYTE PTR CS:[L0115],0FFH
	JE	L075F
	PUSH	AX
	CLI
	MOV	AL,13H
	OUT	INTA00,AL
	MOV	AL,08H
	OUT	INTA01,AL
	MOV	AL,09H
	OUT	INTA01,AL
	STI
	MOV	AL,BYTE PTR CS:[L0116]
	PUSH	DI
	PUSH	ES
	PUSH	CX
	XOR	AX,AX
	MOV	ES,AX
	MOV	CX,0010H
	CLD
	REPZ	STOSW
	POP	CX
	POP	ES
	POP	DI
	POP	AX
	RET
L075F:	PUSH	DS
	PUSH	AX
	XOR	AX,AX
	MOV	DS,AX
	MOV	AX,WORD PTR CS:[L1B02]
	CLI
	MOV	WORD PTR DS:[TIMER_INT_IP],AX
	MOV	AX,WORD PTR CS:[L1B04]
	MOV	WORD PTR DS:[TIMER_INT_CS],AX
	STI
	POP	AX
	POP	DS
	RET
L0732	ENDP
;
L0778	PROC	NEAR
	PUSH	CX
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	DS
	MOV	DX,0040H
	XOR	AX,AX
	MOV	DS,AX
L0784:	MOV	SI,DX
	SHL	SI,1
	SHL	SI,1
	MOV	CX,0008H
	CLD
L078E:	LODSW
	TEST	AX,AX
	JNE	L07A3
	LODSW
	JNE	L07A1
	LOOP	L078E
L0798:	CLC
	MOV	AL,DL
L079B:	POP	DS
	POP	DX
	POP	SI
	POP	DI
	POP	CX
	RET
L07A1:	DEC	SI
	DEC	SI
L07A3:	DEC	SI
	DEC	SI
	TEST	SI,001FH
	JNE	L07BC
	LODSW
	MOV	DI,AX
	MOV	CX,0007H
L07B1:	INC	SI
	INC	SI
	LODSW
	CMP	AX,DI
	JNE	L07BC
	LOOP	L07B1
	JMP	SHORT L0798
L07BC:	ADD	DX,+08H
	CMP	DX,0080H
	JNE	L0784
	STC
	JMP	SHORT L079B
L0778	ENDP
;
L07C8:					;table area starts here
	DB	8 DUP(00H)
	DB	7EH,81H,0A5H,81H,0BDH,99H,81H,7EH
	DB	7EH,0FFH,0DBH,0FFH,0C3H,0E7H,0FFH,7EH
	DB	6CH,0FEH,0FEH,0FEH,7CH,38H,10H,00H
	DB	10H,38H,7CH,0FEH,7CH,38H,10H,00H
	DB	38H,7CH,38H,0FEH,0FEH,7CH,38H,7CH
	DB	10H,10H,38H,7CH,0FEH,7CH,38H,7CH
L0800:	DB	00H,00H,18H,3CH,3CH,18H,00H,00H
	DB	0FFH,0FFH,0E7H,0C3H,0C3H,0E7H,0FFH,0FFH
	DB	00H,3CH,66H,42H,42H,66H,3CH,00H
	DB	0FFH,0C3H,99H,0BDH,0BDH,99H,0C3H,0FFH
	DB	0FH,07H,0FH,7DH,0CCH,0CCH,0CCH,78H
	DB	3CH,66H,66H,66H,3CH,18H,7EH,18H
	DB	3FH,33H,3FH,30H,30H,70H,0F0H,0E0H
	DB	7FH,63H,7FH,63H,63H,67H,0E6H,0C0H
	DB	99H,5AH,3CH,0E7H,0E7H,3CH,5AH,99H
	DB	80H,0E0H,0F8H,0FEH,0F8H,0E0H,80H,00H
	DB	02H,0EH,3EH,0FEH,03EH,0EH,02H,00H
	DB	18H,3CH,7EH,18H,18H,7EH,3CH,18H
	DB	66H,66H,66H,66H,66H,00H,66H,00H
	DB	7FH,0DBH,0DBH,7BH,1BH,1BH,1BH,00H
	DB	3EH,63H,38H,6CH,6CH,38H,0CCH,78H
	DB	00H,00H,00H,00H,7EH,7EH,7EH,00H
L0880:	DB	18H,3CH,7EH,18H,7EH,3CH,18H,0FFH
	DB	18H,3CH,7EH,18H,18H,18H,18H,00H
	DB	18H,18H,18H,18H,7EH,3CH,18H,00H
	DB	00H,18H,0CH,0FEH,0CH,18H,00H,00H
	DB	00H,30H,60H,0FEH,60H,30H,00H,00H
	DB	00H,00H,0C0H,0C0H,0C0H,0FEH,00H,00H
	DB	00H,24H,66H,0FFH,66H,24H,00H,00H
	DB	00H,18H,3CH,7EH,0FFH,0FFH,00H,00H
	DB	00H,0FFH,0FFH,7EH,3CH,18H,00H,00H
	DB	8 DUP(00H)
	DB	30H,78H,78H,78H,30H,00H,30H,00H
	DB	6CH,6CH,6CH,00H,00H,00H,00H,00H
	DB	6CH,6CH,0FEH,6CH,0FEH,6CH,6CH,00H
	DB	30H,7CH,0C0H,78H,0CH,0F8H,30H,00H
	DB	00H,0C6H,0CCH,18H,30H,66H,0C6H,00H
	DB	38H,6CH,38H,76H,0DCH,0CCH,76H,00H
L0900:	DB	60H,60H,0C0H,00H,00H,00H,00H,00H
	DB	18H,30H,60H,60H,60H,30H,18H,00H
	DB	60H,30H,18H,18H,18H,30H,60H,00H
	DB	00H,66H,3CH,0FFH,3CH,66H,00H,00H
	DB	00H,30H,30H,0FCH,30H,30H,00H,00H
	DB	00H,00H,00H,00H,00H,30H,30H,60H
	DB	00H,00H,00H,0FCH,00H,00H,00H,00H
	DB	00H,00H,00H,00H,00H,30H,30H,00H
	DB	06H,0CH,18H,30H,60H,0C0H,80H,00H
	DB	7CH,0C6H,0CEH,0DEH,0F6H,0E6H,7CH,00H
	DB	30H,70H,30H,30H,30H,30H,0FCH,00H
	DB	78H,0CCH,0CH,38H,60H,0CCH,0FCH,00H
	DB	78H,0CCH,0CH,38H,0CH,0CCH,78H,00H
	DB	1CH,3CH,6CH,0CCH,0FEH,0CH,1EH,00H
	DB	0FCH,0C0H,0F8H,0CH,0CH,0CCH,78H,00H
	DB	38H,60H,0C0H,0F8H,0CCH,0CCH,78H,00H
L0980:	DB	0FCH,0CCH,0CH,18H,30H,30H,30H,00H
	DB	78H,0CCH,0CCH,78H,0CCH,0CCH,78H,00H
	DB	78H,0CCH,0CCH,7CH,0CH,18H,70H,00H
	DB	00H,30H,30H,00H,00H,30H,30H,00H
	DB	00H,30H,30H,00H,00H,30H,30H,60H
	DB	18H,30H,60H,0C0H,60H,30H,18H,00H
	DB	00H,00H,0FCH,00H,00H,0FCH,00H,00H
	DB	60H,30H,18H,0CH,18H,30H,60H,00H
	DB	78H,0CCH,0CH,18H,30H,00H,30H,00H
	DB	7CH,0C6H,0DEH,0DEH,0DEH,0C0H,78H,00H
	DB	30H,78H,0CCH,0CCH,0FCH,0CCH,0CCH,00H
	DB	0FCH,66H,66H,7CH,66H,66H,0FCH,00H
	DB	3CH,66H,0C0H,0C0H,0C0H,66H,3CH,00H
	DB	0F8H,6CH,66H,66H,66H,6CH,0F8H,00H
	DB	7EH,60H,60H,78H,60H,60H,7EH,00H
	DB	7EH,60H,60H,78H,60H,60H,60H,00H
L0A00:	DB	3CH,66H,0C0H,0C0H,0CEH,66H,3EH,00H
	DB	0CCH,0CCH,0CCH,0FCH,0CCH,0CCH,0CCH,00H
	DB	78H,30H,30H,30H,30H,30H,78H,00H
	DB	1EH,0CH,0CH,0CH,0CCH,0CCH,78H,00H
	DB	0E6H,66H,6CH,78H,6CH,66H,0E6H,00H
	DB	60H,60H,60H,60H,60H,60H,7EH,00H
	DB	0C6H,0EEH,0FEH,0FEH,0D6H,0C6H,0C6H,00H
	DB	0C6H,0E6H,0F6H,0DEH,0CEH,0C6H,0C6H,00H
	DB	38H,6CH,0C6H,0C6H,0C6H,6CH,38H,00H
	DB	0FCH,66H,66H,7CH,60H,60H,0F0H,00H
	DB	78H,0CCH,0CCH,0CCH,0DCH,78H,1CH,00H
	DB	0FCH,66H,66H,7CH,6CH,66H,0E6H,00H
	DB	78H,0CCH,0E0H,70H,1CH,0CCH,78H,00H
	DB	0FCH,30H,30H,30H,30H,30H,30H,00H
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,0FCH,00H
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,78H,30H,00H
L0A80:	DB	0C6H,0C6H,0C6H,0D6H,0FEH,0EEH,0C6H,00H
	DB	0C6H,0C6H,06CH,38H,38H,6CH,0C6H,00H
	DB	0CCH,0CCH,0CCH,78H,30H,30H,78H,00H
	DB	0FEH,06H,0CH,18H,30H,60H,0FEH,00H
	DB	78H,60H,60H,60H,60H,60H,78H,00H
	DB	0C0H,60H,30H,18H,0CH,06H,02H,00H
	DB	78H,18H,18H,18H,18H,18H,78H,00H
	DB	10H,38H,6CH,0C6H,00H,00H,00H,00H
	DB	00H,00H,00H,00H,00H,00H,00H,0FFH
	DB	30H,30H,18H,00H,00H,00H,00H,00H
	DB	00H,00H,78H,0CH,7CH,0CCH,76H,00H
	DB	0E0H,60H,60H,7CH,66H,66H,0DCH,00H
	DB	00H,00H,78H,0CCH,0C0H,0CCH,78H,00H
	DB	1CH,0CH,0CH,7CH,0CCH,0CCH,76H,00H
	DB	00H,00H,78H,0CCH,0FCH,0C0H,78H,00H
	DB	38H,6CH,60H,0F0H,60H,60H,0F0H,00H
L0B00:	DB	00H,00H,76H,0CCH,0CCH,07CH,0CH,0F8H
	DB	0E0H,60H,6CH,76H,66H,66H,0E6H,00H
	DB	30H,00H,70H,30H,30H,30H,78H,00H
	DB	0CH,00H,0CH,0CH,0CH,0CCH,0CCH,78H
	DB	0E0H,60H,66H,6CH,78H,6CH,0E6H,00H
	DB	70H,30H,30H,30H,30H,30H,78H,00H
	DB	00H,00H,0CCH,0FEH,0FEH,0D6H,0C6H,00H
	DB	00H,00H,0F8H,0CCH,0CCH,0CCH,0CCH,00H
	DB	00H,00H,78H,0CCH,0CCH,0CCH,78H,00H
	DB	00H,00H,0DCH,66H,66H,7CH,60H,0F0H
	DB	00H,00H,76H,0CCH,0CCH,7CH,0CH,1EH
	DB	00H,00H,0DCH,76H,66H,60H,0F0H,00H
	DB	00H,00H,7CH,0C0H,78H,0CH,0F8H,00H
	DB	10H,30H,7CH,30H,30H,34H,18H,00H
	DB	00H,00H,0CCH,0CCH,0CCH,0CCH,76H,00H
	DB	00H,00H,0CCH,0CCH,0CCH,78H,30H,00H
L0B80:	DB	00H,00H,0C6H,0D6H,0FEH,0FEH,6CH,00H
	DB	00H,00H,0C6H,06CH,38H,06CH,0C6H,00H
	DB	00H,00H,0CCH,0CCH,0CCH,7CH,0CH,0F8H
	DB	00H,00H,0FCH,98H,30H,64H,0FCH,00H
	DB	1CH,30H,30H,0E0H,30H,30H,1CH,00H
	DB	18H,18H,18H,00H,18H,18H,18H,00H
	DB	0E0H,30H,30H,1CH,30H,30H,0E0H,00H
	DB	76H,0DCH,00H,00H,00H,00H,00H,00H
	DB	00H,10H,38H,6CH,0C6H,0C6H,0FEH,00H
						;End of table area
L0BC8:	DB	53H,52H,00H,00H,00H,00H
L0BCE	DW	0000H
L0BD0	DW	0000H
L0BD2	DW	0000H
L0BD4	DW	0000H
L0BD6	DW	0000H
L0BD8	DW	0000H
L0BDA	DB	29H
L0BDB	DW	0000H
L0BDD	DW	0000H
	DB	00H,00H,00H,00H,00H,00H
;
NEW_BOOT_STRAP:
	CALL	L0BEC
	XOR	AX,AX
	INT	19H				;Disk Boot
;
L0BEC	PROC	NEAR
	MOV	CS:[L0111],87H
	PUSH	DS
	PUSH	AX
	PUSH	DX
	XOR	AX,AX
	MOV	DS,AX
	CLI
	MOV	AX,WORD PTR CS:[L0105]
	MOV	WORD PTR DS:[VIDEO_IO_IP],AX
	MOV	AX,WORD PTR CS:[L0107]
	MOV	WORD PTR DS:[VIDEO_IO_CS],AX
	MOV	AX,WORD PTR CS:[L0109]
	MOV	WORD PTR DS:[BOOT_STRAP_IP],AX
	MOV	AX,WORD PTR CS:[L010B]
	MOV	WORD PTR DS:[BOOT_STRAP_CS],AX
	CALL	L0732
	STI
	MOV	AL,BYTE PTR DS:[EQUIP_FLAG]
	AND	AL,0CFH
	OR	AL,30H
	MOV	BYTE PTR DS:[EQUIP_FLAG],AL
	ADD	[BP+SI],AL
	ADD	BH,[BX+0EE03H]
	MOV	AX,0007H
	INT	10H				;Perform Video Processing
	POP	DX
	POP	AX
	POP	DS
	RET
L0BEC	ENDP
;
L0C33:
	DW	L0CC1,L10B6,L10D9,L111A,L1133,L11CB,L1221,L1366
	DW	L14B0,L15F5,L17C2,L1837,L185D,L189D,L1916,L1904
	DW	L0CC0,L0CC0,L0CC0,L19E9
;
NEW_INTERRUPT_10H PROC	NEAR
	STI
	TEST	CS:[L010E],0FFH
	JE	L0C6D
	CALL	L0667
	MOV	CS:[L010E],00H
L0C6D:	CMP	AH,0C1H				;Installation Check Request
	JE	L0C9B
	CMP	AH,0C2H
	JE	L0CA0
	CMP	AH,13H
	JNBE	L0CBB
	TEST	CS:[L0110],0FFH
	JE	L0C89
	CMP	AH,04H
	JE	L0CBB
L0C89:	PUSH	DI
	PUSH	BX
	MOV	BL,AH
	XOR	BH,BH
	SHL	BX,1
	MOV	DI,BX
	POP	BX
	CALL	WORD PTR CS:[DI+L0C33]
	POP	DI
L0C9A:	IRET
L0C9B:	MOV	AX,0AAAAH
	JMP	SHORT L0C9A
L0CA0:
	TEST	CS:[L010F],0FFH
	JNE	L0CAF
	CALL	L0BEC
	MOV	AX,CS
	JMP	SHORT L0C9A
L0CAF:	MOV	AX,00F7H
	PUSH	DI
	CALL	L0CC1
	POP	DI
	XOR	AX,AX
	JMP	SHORT L0C9A
L0CBB:
	JMP	DWORD PTR CS:[OLD_INTERRUPT_10H]
L0CC0:	RET
NEW_INTERRUPT_10H ENDP
;
L0CC1	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	MOV	WORD PTR CS:[L0BDB],0000H
	PUSH	DS
	XOR	SI,SI
	MOV	DS,SI
	CMP	AL,02H
	JE	L0CDA
	CMP	AL,03H
	JNE	L0CE5
L0CDA:	CMP	BYTE PTR DS:[CRT_MODE],07H
	JNE	L0D02
	MOV	AL,07H
	JMP	SHORT L0D02
L0CE5:	CMP	AL,07H
	JNE	L0CF4
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L0D02
	MOV	AL,02H
	JMP	SHORT L0D02
L0CF4:	CMP	AL,0F2H
	JNE	L0CFC
	MOV	AL,02H
	JMP	SHORT L0D02
L0CFC:	CMP	AL,0F7H
	JNE	L0D02
	MOV	AL,07H
L0D02:	POP	DS
	CMP	AL,07H
	JBE	L0D09
	MOV	AL,07H
L0D09:	CBW
	MOV	BX,AX
	SHL	BX,1
	CALL	WORD PTR CS:[BX+L0D19]
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
L0D19:
	DW	L0DC4,L0DC4,L0D29,L0DC4,L0E5F,L0E5F,L0EEF,L0F7F
L0CC1	ENDP
;
L0D29	PROC	NEAR
	PUSH	ES
	PUSH	DS
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	MOV	BL,DS:[EQUIP_FLAG]
	AND	BL,0CFH
	OR	BL,20H
	MOV	DS:[EQUIP_FLAG],BL
	TEST	CS:[L0110],0FFH
	JE	L0D58
	MOV	AL,BYTE PTR CS:[L0BDA]
	AND	AL,0F7H
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	POP	AX
	PUSH	AX
	PUSHF
	CALL	DWORD PTR CS:[OLD_INTERRUPT_10H]
L0D58:	POP	AX
	MOV	BYTE PTR DS:[CRT_MODE],AL
	OR	AL,80H
	MOV	CS:[L0111],AL
	MOV	WORD PTR DS:[CRT_LEN],1000H
	MOV	WORD PTR DS:[CRT_START],0000H
	MOV	BYTE PTR DS:[ACTIVE_PAGE],00H
	MOV	WORD PTR DS:[CURSOR_MODE],0607H
	MOV	WORD PTR DS:[CRT_COLS],80
	MOV	WORD PTR DS:[ADDR_6845],COLOR_INDEX
	XOR	AX,AX
	LEA	DI,DS:[CURSOR_POSN]
	MOV	[DI],AX
	MOV	[DI+02H],AX
	MOV	[DI+04H],AX
	MOV	[DI+06H],AX
	MOV	[DI+08H],AX
	MOV	[DI+0AH],AX
	MOV	[DI+0CH],AX
	MOV	[DI+0EH],AX
	CALL	L1000
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,03H
	OUT	DX,AL
	MOV	AX,HERC_MONO_PAGE1
	MOV	ES,AX
	MOV	AX,0720H
	MOV	CX,4000H
	XOR	DI,DI
	CLD
	REPZ	STOSW
	AND	CS:[L0111],7FH
	POP	DS
	POP	ES
	RET
L0D29	ENDP
;
L0DC4	PROC	NEAR
	PUSH	ES
	PUSH	DS
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	MOV	BL,DS:[EQUIP_FLAG]
	AND	BL,0CFH
	OR	BL,20H
	MOV	DS:[EQUIP_FLAG],BL
	TEST	CS:[L0110],0FFH
	JE	L0DF3
	MOV	AL,BYTE PTR CS:[L0BDA]
	AND	AL,0F7H
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	POP	AX
	PUSH	AX
	PUSHF
	CALL	DWORD PTR CS:[OLD_INTERRUPT_10H]
L0DF3:	POP	AX
	MOV	BYTE PTR DS:[CRT_MODE],AL
	OR	AL,80H
	MOV	CS:[L0111],AL
	MOV	WORD PTR DS:[CRT_LEN],1000H
	MOV	WORD PTR DS:[CRT_START],0000H
	MOV	BYTE PTR DS:[ACTIVE_PAGE],00H
	MOV	WORD PTR DS:[CURSOR_MODE],0607H
	MOV	WORD PTR DS:[CRT_COLS],80
	MOV	WORD PTR DS:[ADDR_6845],COLOR_INDEX
	XOR	AX,AX
	LEA	DI,DS:[CURSOR_POSN]
	MOV	[DI],AX
	MOV	[DI+02H],AX
	MOV	[DI+04H],AX
	MOV	[DI+06H],AX
	MOV	[DI+08H],AX
	MOV	[DI+0AH],AX
	MOV	[DI+0CH],AX
	MOV	[DI+0EH],AX
	CALL	L1000
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,03H
	OUT	DX,AL
	MOV	AX,HERC_MONO_PAGE1
	MOV	ES,AX
	MOV	AX,0720H
	MOV	CX,4000H
	XOR	DI,DI
	CLD
	REPZ	STOSW
	AND	CS:[L0111],7FH
	POP	DS
	POP	ES
	RET
L0DC4	ENDP
;
L0E5F	PROC	NEAR
	PUSH	DS
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	MOV	BL,DS:[EQUIP_FLAG]
	AND	BL,0CFH
	OR	BL,10H
	MOV	DS:[EQUIP_FLAG],BL
	TEST	CS:[L0110],0FFH
	JE	L0E8D
	MOV	AL,BYTE PTR CS:[L0BDA]
	AND	AL,0F7H
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	POP	AX
	PUSH	AX
	PUSHF
	CALL	DWORD PTR CS:[OLD_INTERRUPT_10H]
L0E8D:	POP	AX
	MOV	BYTE PTR DS:[CRT_MODE],AL
	OR	AL,80H
	MOV	CS:[L0111],AL
	MOV	WORD PTR DS:[CRT_LEN],4000H
	MOV	WORD PTR DS:[CRT_START],0000H
	MOV	BYTE PTR DS:[ACTIVE_PAGE],00H
	MOV	WORD PTR DS:[CURSOR_MODE],0607H
	MOV	WORD PTR DS:[CRT_COLS],40
	MOV	WORD PTR DS:[ADDR_6845],COLOR_INDEX
	XOR	AX,AX
	LEA	DI,DS:[CURSOR_POSN]
	MOV	[DI],AX
	MOV	[DI+02H],AX
	MOV	[DI+04H],AX
	MOV	[DI+06H],AX
	MOV	[DI+08H],AX
	MOV	[DI+0AH],AX
	MOV	[DI+0CH],AX
	MOV	[DI+0EH],AX
	CALL	L105B
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,03H
	OUT	DX,AL
	MOV	WORD PTR CS:[L0117],0800H
	AND	CS:[L0111],7FH
	POP	DS
	RET
L0E5F	ENDP
;
L0EEF	PROC	NEAR
	PUSH	DS
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	MOV	BL,DS:[EQUIP_FLAG]
	AND	BL,0CFH
	OR	BL,20H
	MOV	DS:[EQUIP_FLAG],BL
	TEST	CS:[L0110],0FFH
	JE	L0F1D
	MOV	AL,BYTE PTR CS:[L0BDA]
	AND	AL,0F7H
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	POP	AX
	PUSH	AX
	PUSHF
	CALL	DWORD PTR CS:[OLD_INTERRUPT_10H]
L0F1D:	POP	AX
	MOV	BYTE PTR DS:[CRT_MODE],AL
	OR	AL,80H
	MOV	CS:[L0111],AL
	MOV	WORD PTR DS:[CRT_LEN],4000H
	MOV	WORD PTR DS:[CRT_START],0000H
	MOV	BYTE PTR DS:[ACTIVE_PAGE],00H
	MOV	WORD PTR DS:[CURSOR_MODE],0607H
	MOV	WORD PTR DS:[CRT_COLS],80
	MOV	WORD PTR DS:[ADDR_6845],COLOR_INDEX
	XOR	AX,AX
	LEA	DI,DS:[CURSOR_POSN]
	MOV	[DI],AX
	MOV	[DI+02H],AX
	MOV	[DI+04H],AX
	MOV	[DI+06H],AX
	MOV	[DI+08H],AX
	MOV	[DI+0AH],AX
	MOV	[DI+0CH],AX
	MOV	[DI+0EH],AX
	CALL	L105B
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,03H
	OUT	DX,AL
	MOV	WORD PTR CS:[L0117],0800H
	AND	CS:[L0111],7FH
	POP	DS
	RET
L0EEF	ENDP
;
L0F7F	PROC	NEAR
	PUSH	DS
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	MOV	BL,DS:[EQUIP_FLAG]
	AND	BL,0CFH
	OR	BL,30H
	MOV	DS:[EQUIP_FLAG],BL
	TEST	CS:[L0110],0FFH
	JE	L0FAD
	MOV	AL,BYTE PTR CS:[L0BDA]
	AND	AL,0F7H
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	POP	AX
	PUSH	AX
	PUSHF
	CALL	DWORD PTR CS:[OLD_INTERRUPT_10H]
L0FAD:	POP	AX
	MOV	BYTE PTR DS:[CRT_MODE],AL
	MOV	CS:[L0111],AL
	MOV	WORD PTR DS:[CRT_LEN],1000H
	MOV	WORD PTR DS:[CRT_START],0000H
	MOV	BYTE PTR DS:[ACTIVE_PAGE],00H
	MOV	WORD PTR DS:[CURSOR_MODE],0607H
	MOV	WORD PTR DS:[CRT_COLS],80
	MOV	WORD PTR DS:[ADDR_6845],HERC_MONO_INDXREG
	XOR	AX,AX
	LEA	DI,DS:[CURSOR_POSN]
	MOV	[DI],AX
	MOV	[DI+02H],AX
	MOV	[DI+04H],AX
	MOV	[DI+06H],AX
	MOV	[DI+08H],AX
	MOV	[DI+0AH],AX
	MOV	[DI+0CH],AX
	MOV	[DI+0EH],AX
	CALL	L1000
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,01H
	OUT	DX,AL
	POP	DS
	RET
L0F7F	ENDP
;
L1000	PROC	NEAR
	PUSH	ES
	MOV	DX,HERC_MONO_DSPMODE
	MOV	AL,21H
	OUT	DX,AL
	MOV	CX,0010H
	MOV	AH,CH
	MOV	DX,HERC_MONO_INDXREG
	LEA	SI,DS:[L104B]
	CLD
	CLI
L1015:	MOV	AL,AH
	OUT	DX,AL
	INC	DX
	DB	2EH				;Address off of CS
	LODSB
	OUT	DX,AL
	INC	AH
	DEC	DX
	LOOP	L1015
	STI
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,00H
	OUT	DX,AL
	MOV	CX,0800H
	MOV	AX,HERC_MONO_PAGE0
	MOV	ES,AX
	XOR	DI,DI
	MOV	AX,0720H
	REPZ	STOSW
	XOR	AX,AX
	MOV	ES,AX
	MOV	AL,29H
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	MOV	BYTE PTR ES:[CRT_MODE_SET],AL
	MOV	BYTE PTR CS:[L0BDA],AL
	POP	ES
	RET
L104B:	DB	61H,50H,52H,0FH,19H,06H,19H,19H,02H,0DH,0BH,0CH,00H,00H,00H,00H
L1000	ENDP
;
L105B	PROC	NEAR
	PUSH	ES
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	DX,HERC_MONO_CONFIG
	MOV	AL,03H
	OUT	DX,AL
	MOV	DX,HERC_MONO_DSPMODE
	MOV	AL,83H
	OUT	DX,AL
	MOV	CX,0010H
	MOV	AH,CH
	MOV	DX,HERC_MONO_INDXREG
	LEA	SI,DS:[L10A6]
	CLD
	CLI
L107B:	MOV	AL,AH
	OUT	DX,AL
	INC	DX
	DB	2EH				;Address off of CS:
	LODSB
	OUT	DX,AL
	INC	AH
	DEC	DX
	LOOP	L107B
	STI
	MOV	CX,3000H
	MOV	AX,HERC_MONO_PAGE1
	MOV	ES,AX
	XOR	DI,DI
	MOV	AX,DI
	REPZ	STOSW
	MOV	AL,8BH
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	MOV	BYTE PTR DS:[CRT_MODE_SET],AL
	MOV	BYTE PTR CS:[L0BDA],AL
	POP	DS
	POP	ES
	RET
L10A6:	DB	35H,28H,2CH,07H,79H,02H,64H,6EH,02H,02H,00H,00H,00H,00H,00H,00H
L105B	ENDP
;
L10B6	PROC	NEAR
	PUSH	DX
	PUSH	AX
	PUSH	DS
	XOR	DI,DI
	MOV	DS,DI
	MOV	DS:[CURSOR_MODE],CX
	POP	DS
	MOV	DX,HERC_MONO_INDXREG
	CLI
	MOV	AL,0AH
	OUT	DX,AL
	INC	DX
	MOV	AL,CH
	OUT	DX,AL
	DEC	DX
	MOV	AL,0BH
	OUT	DX,AL
	INC	DX
	MOV	AL,CL
	OUT	DX,AL
	STI
	POP	AX
	POP	DX
	RET
L10B6	ENDP
;
L10D9	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	DX
	PUSH	DS
	PUSH	BX
	XOR	AX,AX
	MOV	DS,AX
	MOV	BL,BH
	XOR	BH,BH
	SHL	BX,1
	MOV	[BX+CURSOR_POSN],DX
	POP	BX
	CMP	DS:[ACTIVE_PAGE],BH
	JNE	L1115
	MOV	AL,0A0H
	MUL	DH
	SHL	DL,1
	XOR	DH,DH
	ADD	AX,DX
	SHR	AX,1
	MOV	BX,AX
	MOV	DX,HERC_MONO_INDXREG
	CLI
	MOV	AL,0EH
	OUT	DX,AL
	MOV	AL,BH
	INC	DX
	OUT	DX,AL
	DEC	DX
	MOV	AL,0FH
	OUT	DX,AL
	INC	DX
	MOV	AL,BL
	STI
	OUT	DX,AL
L1115:	POP	DS
	POP	DX
	POP	BX
	POP	AX
	RET
L10D9	ENDP
;
L111A	PROC	NEAR
	PUSH	AX
	PUSH	DS
	PUSH	BX
	XOR	AX,AX
	MOV	DS,AX
	MOV	BL,BH
	XOR	BH,BH
	SHL	BX,1
	MOV	DX,[BX+CURSOR_POSN]
	MOV	CX,DS:[CURSOR_MODE]
	POP	BX
	POP	DS
	POP	AX
	RET
L111A	ENDP
;
L1133	PROC	NEAR
	PUSH	DX
	MOV	DX,HERC_MONO_DSPSTAT
	IN	AL,DX
	TEST	AL,04H
	JE	L1142
	INC	DX
	OUT	DX,AL
	XOR	AX,AX
	POP	DX
	RET
L1142:	TEST	AL,02H
	JE	L114A
	XOR	AX,AX
	POP	DX
	RET
L114A:	POP	DX
	MOV	DX,HERC_MONO_INDXREG
	CLI
	MOV	AL,10H
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	MOV	CH,AL
	DEC	DX
	MOV	AL,11H
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	STI
	MOV	CL,AL
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	SUB	CX,+03H
	JNB	L116B
	XOR	CX,CX
L116B:	MOV	AX,CX
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L11A7
	CMP	BYTE PTR DS:[CRT_MODE],04H
	JB	L11A7
	MOV	CL,40
	DIV	CL
	MOV	DL,AL
	SHL	DL,1
	MOV	CL,AH
	XOR	CH,CH
	CMP	BYTE PTR DS:[CRT_MODE],06H
	JNE	L1192
	SHL	AH,1
	SHL	CX,1
L1192:	SHL	CX,1
	SHL	CX,1
	SHL	CX,1
	MOV	BX,CX
	MOV	CH,DL
	MOV	DH,AL
	MOV	DL,AH
	SHR	DH,1
	SHR	DH,1
	JMP	SHORT L11C1
	NOP
L11A7:	MOV	DH,80
	DIV	DH
	MOV	DH,AL
	MOV	DL,AH
	SHL	AL,1
	SHL	AL,1
	SHL	AL,1
	MOV	CH,AL
	MOV	BL,AH
	XOR	BH,BH
	SHL	BX,1
	SHL	BX,1
	SHL	BX,1
L11C1:	MOV	AH,01H
	PUSH	DX
	MOV	DX,HERC_MONO_RSTLPEN
	OUT	DX,AL
	POP	DX
	POP	DS
	RET
L1133	ENDP
;
L11CB	PROC	NEAR
	PUSH	DS
	PUSH	BX
	PUSH	AX
	PUSH	DX
	XOR	BX,BX
	MOV	DS,BX
	MOV	BYTE PTR DS:[ACTIVE_PAGE],AL
	MOV	AH,BH
	PUSH	AX
	MOV	BX,1000H
	MUL	BX
	MOV	WORD PTR DS:[CRT_START],AX
	XOR	BX,BX
	CLI
	MOV	DX,HERC_MONO_INDXREG
	MOV	AL,0CH
	OUT	DX,AL
	INC	DX
	MOV	AL,BH
	OUT	DX,AL
	DEC	DX
	MOV	AL,0DH
	OUT	DX,AL
	INC	DX
	MOV	AL,BL
	OUT	DX,AL
	STI
	POP	BX
	SHL	BX,1
	MOV	BX,[BX+CURSOR_POSN]
	MOV	AL,0A0H
	MUL	BH
	SHL	BL,1
	XOR	BH,BH
	ADD	AX,BX
	SHR	AX,1
	MOV	BX,AX
	DEC	DX
	MOV	AL,0EH
	OUT	DX,AL
	MOV	AL,BH
	INC	DX
	OUT	DX,AL
	DEC	DX
	MOV	AL,0FH
	OUT	DX,AL
	INC	DX
	MOV	AL,BL
	OUT	DX,AL
	POP	DX
	POP	AX
	POP	BX
	POP	DS
	RET
L11CB	ENDP
;
L1221	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	PUSH	DS
	MOV	BL,AL
	XOR	DI,DI
	MOV	DS,DI
	CMP	BYTE PTR DS:[CRT_MODE],04H
	JB	L1240
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L1240
	JMP	L12C9
L1240:	MOV	AL,CH
	MOV	AH,80
	MUL	AH
	ADD	AL,CL
	ADC	AH,00H
	SHL	AX,1
	ADD	AX,DS:[CRT_START]
	MOV	SI,AX
	ADD	DX,0101H
	SUB	DX,CX
	MOV	AH,0A0H
	MOV	AL,BL
	MUL	AH
	CLD
	MOV	DI,HERC_MONO_PAGE0
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L1282
	TEST	CS:[L010D],0FFH
	JNE	L1282
	MOV	DI,HERC_MONO_PAGE1
	MOV	CH,BH
	AND	CH,07H
	CMP	CH,01H
	JNE	L1282
	OR	BH,07H
L1282:	MOV	ES,DI
	MOV	DI,SI
	ADD	SI,AX
	TEST	BL,BL
	JE	L12C5
	SUB	DH,BL
	XOR	CH,CH
	PUSH	ES
	POP	DS
L1292:	MOV	CL,DL
	PUSH	DI
	PUSH	SI
	REPZ	MOVSW
	POP	SI
	POP	DI
	ADD	DI,00A0H
	ADD	SI,00A0H
	DEC	DH
	JNE	L1292
L12A6:	PUSH	ES
	POP	DS
	MOV	AH,BH
	MOV	AL,20H
	XOR	CH,CH
L12AE:	MOV	CL,DL
	MOV	SI,DI
	REPZ	STOSW
	LEA	DI,[SI+00A0H]
	DEC	BL
	JNE	L12AE
L12BC:	POP	DS
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
L12C5:	MOV	BL,DH
	JMP	SHORT L12A6
L12C9:	CLD
	MOV	DI,CX
	MOV	AL,CH
	MUL	BYTE PTR DS:[CRT_COLS]
	SHL	AX,1
	SHL	AX,1
	AND	DI,00FFH
	ADD	DI,AX
	SUB	DX,CX
	INC	DH
	INC	DL
	SHL	DH,1
	SHL	DH,1
	CMP	BYTE PTR DS:[CRT_MODE],06H
	JNB	L12F1
	SHL	DL,1
	SHL	DI,1
L12F1:	MOV	SI,HERC_MONO_PAGE1
	MOV	DS,SI
	MOV	ES,SI
	XOR	CH,CH
	TEST	BL,BL
	JE	L1362
	SHL	BL,1
	SHL	BL,1
	MOV	AL,BL
	MOV	AH,80
	MUL	AH
	MOV	SI,DI
	ADD	SI,AX
	SUB	DH,BL
L130E:	MOV	CL,DL
	PUSH	DI
	PUSH	SI
	REPZ	MOVSB
	POP	SI
	POP	DI
	PUSH	DI
	PUSH	SI
	ADD	SI,2000H
	ADD	DI,2000H
	MOV	CL,DL
	REPZ	MOVSB
	POP	SI
	POP	DI
	PUSH	DI
	PUSH	SI
	ADD	SI,4000H
	ADD	DI,4000H
	MOV	CL,DL
	REPZ	MOVSB
	POP	SI
	POP	DI
	ADD	SI,+80
	ADD	DI,+80
	DEC	DH
	JNE	L130E
L1340:	XOR	AL,AL
L1342:	MOV	CL,DL
	MOV	SI,DI
	REPZ	STOSB
	LEA	DI,[SI+2000H]
	MOV	CL,DL
	REPZ	STOSB
	LEA	DI,[SI+4000H]
	MOV	CL,DL
	REPZ	STOSB
	LEA	DI,[SI+80]
	DEC	BL
	JNE	L1342
	JMP	L12BC
L1362:	MOV	BL,DH
	JMP	SHORT L1340
L1366:	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	ES
	PUSH	DS
	MOV	BL,AL
	XOR	DI,DI
	MOV	DS,DI
	CMP	BYTE PTR DS:[CRT_MODE],04H
	JB	L1385
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L1385
	JMP	L140E
L1385:	MOV	AL,DH
	MOV	AH,80
	MUL	AH
	ADD	AL,DL
	ADC	AH,00H
	SHL	AX,1
	ADD	AX,DS:[CRT_START]
	MOV	SI,AX
	ADD	DX,0101H
	SUB	DX,CX
	MOV	AH,0A0H
	MOV	AL,BL
	MUL	AH
	STD
	MOV	DI,HERC_MONO_PAGE0
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L13C7
	TEST	CS:[L010D],0FFH
	JNE	L13C7
	MOV	DI,HERC_MONO_PAGE1
	MOV	CH,BH
	AND	CH,07H
	CMP	CH,01H
	JNE	L13C7
	OR	BH,07H
L13C7:	MOV	ES,DI
	MOV	DI,SI
	SUB	SI,AX
	TEST	BL,BL
	JE	L140A
	SUB	DH,BL
	XOR	CH,CH
	PUSH	ES
	POP	DS
L13D7:	MOV	CL,DL
	PUSH	DI
	PUSH	SI
	REPZ	MOVSW
	POP	SI
	POP	DI
	SUB	DI,00A0H
	SUB	SI,00A0H
	DEC	DH
	JNE	L13D7
L13EB:	PUSH	ES
	POP	DS
	MOV	AH,BH
	MOV	AL,20H
	XOR	CH,CH
L13F3:	MOV	CL,DL
	MOV	SI,DI
	REPZ	STOSW
	LEA	DI,[SI+0FF60H]
	DEC	BL
	JNE	L13F3
L1401:	POP	DS
	POP	ES
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
L140A:	MOV	BL,DH
	JMP	SHORT L13EB
L140E:	STD
	MOV	DI,DX
	MOV	AL,DH
	MUL	BYTE PTR DS:[CRT_COLS]
	SHL	AX,1
	SHL	AX,1
	AND	DI,00FFH
	ADD	DI,AX
	SUB	DX,CX
	INC	DH
	INC	DL
	SHL	DH,1
	SHL	DH,1
	CMP	BYTE PTR DS:[CRT_MODE],06H
	JNB	L1437
	SHL	DL,1
	SHL	DI,1
	INC	DI
L1437:	MOV	SI,HERC_MONO_PAGE1
	MOV	DS,SI
	MOV	ES,SI
	XOR	CH,CH
	ADD	DI,00F0H
	TEST	BL,BL
	JE	L14AC
	SHL	BL,1
	SHL	BL,1
	MOV	AL,BL
	MOV	AH,80
	MUL	AH
	MOV	SI,DI
	ADD	SI,AX
	SUB	DH,BL
L1458:	MOV	CL,DL
	PUSH	DI
	PUSH	SI
	REPZ	MOVSB
	POP	SI
	POP	DI
	PUSH	DI
	PUSH	SI
	ADD	SI,2000H
	ADD	DI,2000H
	MOV	CL,DL
	REPZ	MOVSB
	POP	SI
	POP	DI
	PUSH	DI
	PUSH	SI
	ADD	SI,4000H
	ADD	DI,4000H
	MOV	CL,DL
	REPZ	MOVSB
	POP	SI
	POP	DI
	SUB	SI,+80
	SUB	DI,+80
	DEC	DH
	JNE	L1458
L148A:	XOR	AL,AL
L148C:	MOV	CL,DL
	MOV	SI,DI
	REPZ	STOSB
	LEA	DI,[SI+2000H]
	MOV	CL,DL
	REPZ	STOSB
	LEA	DI,[SI+4000H]
	MOV	CL,DL
	REPZ	STOSB
	LEA	DI,[SI-80]
	DEC	BL
	JNE	L148C
	JMP	L1401
L14AC:	MOV	BL,DH
	JMP	SHORT L148A
L1221	ENDP
;
L14B0	PROC	NEAR
	PUSH	DX
	PUSH	BX
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	CMP	BYTE PTR DS:[CRT_MODE],04H
	JB	L14C8
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L14C8
	JMP	SHORT L1504
	NOP
L14C8:	MOV	BL,BH
	XOR	BH,BH
	MOV	DX,BX
	SHL	BX,1
	MOV	AX,WORD PTR DS:[CRT_LEN]
	MUL	DX
	MOV	DX,AX
	MOV	BX,[BX+CURSOR_POSN]
	MOV	AL,80
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX
	SHL	BX,1
	ADD	BX,DX
	MOV	AX,HERC_MONO_PAGE0
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L14FC
	TEST	CS:[L010D],0FFH
	JNE	L14FC
	MOV	AX,HERC_MONO_PAGE1
L14FC:	MOV	DS,AX
	MOV	AX,[BX]
	POP	DS
	POP	BX
	POP	DX
	RET
L1504:	PUSH	ES
	PUSH	SI
	PUSH	DI
	PUSH	CX
	MOV	BX,DS:[CURSOR_POSN]
	MOV	AL,BH
	MUL	BYTE PTR DS:[CRT_COLS]
	SHL	AX,1
	SHL	AX,1
	XOR	BH,BH
	ADD	AX,BX
	MOV	SI,AX
	MOV	AX,HERC_MONO_PAGE1
	MOV	ES,AX
	CMP	BYTE PTR DS:[CRT_MODE],06H
	JNE	L1548
	MOV	CX,0004H
	CLD
	LEA	DI,DS:[L0BDD]
L1530:
	MOV	AL,ES:[SI]
	MOV	CS:[DI],AL
	INC	DI
	MOV	AL,ES:[SI+2000H]
	MOV	CS:[DI],AL
	INC	DI
	ADD	SI,+80
	LOOP	L1530
	JMP	SHORT L156C
	NOP
L1548:	SHL	SI,1
	LEA	DI,DS:[L0BDD]
	MOV	CX,0004H
L1551:
	MOV	AX,ES:[SI]
	CALL	L15B6
	MOV	CS:[DI],DH
	INC	DI
	MOV	AX,ES:[SI+2000H]
	CALL	L15B6
	MOV	CS:[DI],DH
	INC	DI
	ADD	SI,+80
	LOOP	L1551
L156C:	LEA	SI,DS:[L0BDD]
	MOV	AX,CS
	MOV	ES,AX
	LEA	DI,DS:[L07C8]
	MOV	DX,0080H
	CLD
L157C:	PUSH	SI
	PUSH	DI
	MOV	CX,0004H
	DB	0F3H,2EH,0A7H			;REPZ	CMPSW CS:
;	REPZ	CMPSW
	POP	DI
	POP	SI
	JE	L15AA
	ADD	DI,+08H
	INC	DH
	DEC	DL
	JNE	L157C
	XOR	AL,AL
	TEST	DH,DH
	JS	L15AE
	XOR	AX,AX
	MOV	ES,AX
	LES	DI,DWORD PTR ES:[VIDEO_GRAPHICS_IP]
	MOV	AX,ES
	OR	AX,DI
	JE	L15AE
	MOV	DL,80H
	JMP	SHORT L157C
L15AA:	MOV	AL,DH
	XOR	AH,AH
L15AE:	POP	CX
	POP	DI
	POP	SI
	POP	ES
	POP	DS
	POP	BX
	POP	DX
	RET
L14B0	ENDP
;
L15B6	PROC	NEAR
	XOR	DH,DH
	TEST	AL,0C0H
	JE	L15BF
	OR	DH,80H
L15BF:	TEST	AL,30H
	JE	L15C6
	OR	DH,40H
L15C6:	TEST	AL,0CH
	JE	L15CD
	OR	DH,20H
L15CD:	TEST	AL,03H
	JE	L15D4
	OR	DH,10H
L15D4:	TEST	AH,0C0H
	JE	L15DC
	OR	DH,08H
L15DC:	TEST	AH,30H
	JE	L15E4
	OR	DH,04H
L15E4:	TEST	AH,0CH
	JE	L15EC
	OR	DH,02H
L15EC:	TEST	AH,03H
	JE	L15F4
	OR	DH,01H
L15F4:	RET
L15B6	ENDP
;
L15F5	PROC	NEAR
	PUSH	DS
	PUSH	ES
	PUSH	SI
	PUSH	DX
	PUSH	BX
	PUSH	CX
	PUSH	AX
	XOR	DX,DX
	MOV	DS,DX
	CLD
	CMP	BYTE PTR DS:[CRT_MODE],04H
	JB	L1612
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L1612
	JMP	SHORT L166B
	NOP
L1612:	MOV	DX,HERC_MONO_PAGE0
	MOV	ES,DX
	MOV	BL,BH
	XOR	BH,BH
	MOV	DX,BX
	SHL	BX,1
	MOV	AX,WORD PTR DS:[CRT_LEN]
	MUL	DX
	MOV	DX,AX
	MOV	BX,[BX+CURSOR_POSN]
	MOV	AL,80
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX
	SHL	BX,1
	ADD	BX,DX
	MOV	DI,BX
	POP	AX
	POP	CX
	POP	BX
	PUSH	BX
	PUSH	CX
	PUSH	AX
	MOV	AH,BL
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L1661
	AND	BL,07H
	CMP	BL,01H
	JNE	L1652
	OR	AH,07H
L1652:	PUSH	DI
	PUSH	CX
	PUSH	ES
	PUSH	AX
	MOV	AX,HERC_MONO_PAGE1
	MOV	ES,AX
	POP	AX
	REPZ	STOSW
	POP	ES
	POP	CX
	POP	DI
L1661:	REPZ	STOSW
	POP	AX
	POP	CX
	POP	BX
	POP	DX
	POP	SI
	POP	ES
	POP	DS
	RET
L166B:	MOV	DX,HERC_MONO_PAGE1
	MOV	ES,DX
	MOV	BX,DS:[CURSOR_POSN]
	MOV	AL,BH
	MUL	BYTE PTR DS:[CRT_COLS]
	SHL	AX,1
	SHL	AX,1
	XOR	BH,BH
	ADD	AX,BX
	MOV	DI,AX
	CMP	BYTE PTR DS:[CRT_MODE],06H
	JNE	L168E
	JMP	L172A
L168E:	SHL	DI,1
	LDS	SI,DWORD PTR DS:[VIDEO_GRAPHICS_IP]
	POP	AX
	POP	CX
	POP	BX
	MOV	DL,BL
	PUSH	BX
	PUSH	CX
	PUSH	AX
	TEST	AL,AL
	JS	L16A6
	LEA	SI,DS:[L07C8]
	PUSH	CS
	POP	DS
L16A6:	AND	AL,7FH
	XOR	AH,AH
	SHL	AX,1
	SHL	AX,1
	SHL	AX,1
	ADD	SI,AX
	AND	BL,03H
	MOV	BH,BL
	SHL	BH,1
	SHL	BH,1
	OR	BL,BH
	MOV	BH,BL
	SHL	BH,1
	SHL	BH,1
	SHL	BH,1
	SHL	BH,1
	OR	BL,BH
	MOV	BH,BL
L16CB:	MOV	DH,04H
	CLD
	PUSH	SI
	PUSH	DI
	TEST	DL,DL
	JNS	L16E8
	CMP	BH,0FFH
	JNE	L16E8
	CMP	BYTE PTR ES:[DI],0AAH
	JE	L16E5
	CMP	BYTE PTR ES:[DI],55H
	JNE	L16E8
L16E5:	MOV	BX,0AAAAH
L16E8:	LODSB
	CALL	L1783
	AND	AX,BX
	XCHG	AH,AL
	TEST	DL,DL
	JNS	L16F7
	XOR	AX,ES:[DI]
L16F7:
	MOV	ES:[DI],AX
	LODSB
	CALL	L1783
	AND	AX,BX
	XCHG	AH,AL
	TEST	DL,DL
	JNS	L170B
	XOR	AX,ES:[DI+2000H]
L170B:
	MOV	ES:[DI+2000H],AX
	MOV	ES:[DI+4000H],AX
	ADD	DI,+80
	DEC	DH
	JNE	L16E8
	POP	DI
	POP	SI
	INC	DI
	INC	DI
	LOOP	L16CB
	POP	AX
	POP	CX
	POP	BX
	POP	DX
	POP	SI
	POP	ES
	POP	DS
	RET
L172A:	LDS	SI,DWORD PTR DS:[VIDEO_GRAPHICS_IP]
	POP	AX
	POP	CX
	POP	BX
	PUSH	BX
	PUSH	CX
	PUSH	AX
	TEST	AL,AL
	JS	L173E
	LEA	SI,DS:[L07C8]
	PUSH	CS
	POP	DS
L173E:	AND	AL,7FH
	XOR	AH,AH
	SHL	AX,1
	SHL	AX,1
	SHL	AX,1
	ADD	SI,AX
L174A:	MOV	DH,04H
	CLD
	PUSH	SI
	PUSH	DI
L174F:	LODSB
	TEST	BL,BL
	JNS	L1757
	XOR	AL,ES:[DI]
L1757:
	MOV	ES:[DI],AL
	LODSB
	TEST	BL,BL
	JNS	L1764
	XOR	AL,ES:[DI+2000H]
L1764:
	MOV	ES:[DI+2000H],AL
	MOV	ES:[DI+4000H],AL
	ADD	DI,+80
	DEC	DH
	JNE	L174F
	POP	DI
	POP	SI
	INC	DI
	INC	DI
	LOOP	L174A
	POP	AX
	POP	CX
	POP	BX
	POP	DX
	POP	SI
	POP	ES
	POP	DS
	RET
L15F5	ENDP
;
L1783	PROC	NEAR
	XOR	AH,AH
	TEST	AL,AL
	JNS	L178C
	OR	AH,0C0H
L178C:	TEST	AL,40H
	JE	L1793
	OR	AH,30H
L1793:	TEST	AL,20H
	JE	L179A
	OR	AH,0CH
L179A:	TEST	AL,10H
	JE	L17A1
	OR	AH,03H
L17A1:	AND	AL,3FH
	TEST	AL,08H
	JE	L17A9
	OR	AL,0C0H
L17A9:	AND	AL,0CFH
	TEST	AL,04H
	JE	L17B1
	OR	AL,30H
L17B1:	AND	AL,0F3H
	TEST	AL,02H
	JE	L17B9
	OR	AL,0CH
L17B9:	AND	AL,0FDH
	TEST	AL,01H
	JE	L17C1
	OR	AL,03H
L17C1:	RET
L1783	ENDP
;
L17C2	PROC	NEAR
	PUSH	DS
	PUSH	ES
	PUSH	SI
	PUSH	DX
	PUSH	BX
	PUSH	CX
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	CMP	BYTE PTR DS:[CRT_MODE],04H
	JB	L17DE
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L17DE
	JMP	L166B
L17DE:	MOV	DX,HERC_MONO_PAGE0
	MOV	ES,DX
	MOV	BL,BH
	XOR	BH,BH
	MOV	DX,BX
	SHL	BX,1
	MOV	AX,WORD PTR DS:[CRT_LEN]
	MUL	DX
	MOV	DX,AX
	MOV	BX,[BX+CURSOR_POSN]
	MOV	AL,80
	MUL	BH
	XOR	BH,BH
	ADD	BX,AX
	SHL	BX,1
	ADD	BX,DX
	MOV	DI,BX
	POP	AX
	POP	CX
	POP	BX
	PUSH	BX
	PUSH	CX
	PUSH	AX
	CLD
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JE	L182B
	TEST	CS:[L010D],0FFH
	JNE	L182B
	PUSH	DI
	PUSH	CX
	PUSH	ES
	PUSH	AX
	MOV	AX,HERC_MONO_PAGE1
	MOV	ES,AX
	POP	AX
L1824:	STOSB
	INC	DI
	LOOP	L1824
	POP	ES
	POP	CX
	POP	DI
L182B:	STOSB
	INC	DI
	LOOP	L182B
	POP	AX
	POP	CX
	POP	BX
	POP	DX
	POP	SI
	POP	ES
	POP	DS
	RET
L1837:	PUSH	BX
	PUSH	AX
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	AL,BYTE PTR DS:[CRT_PALETTE]
	TEST	BH,BH
	JNE	L1853
	AND	BL,1FH
	AND	AL,0E0H
	OR	AL,BL
L184C:	MOV	BYTE PTR DS:[CRT_PALETTE],AL
	POP	DS
	POP	AX
	POP	BX
	RET
L1853:	AND	AL,0DFH
	SHR	BL,1
	JNB	L184C
	OR	AL,20H
	JMP	SHORT L184C
L185D:	PUSH	ES
	PUSH	DS
	PUSH	DI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX
	XOR	BX,BX
	MOV	DS,BX
	MOV	BX,HERC_MONO_PAGE1
	MOV	ES,BX
	CALL	L18C1
	SHR	AL,CL
	AND	AL,AH
	MOV	CL,ES:[DI]
	POP	BX
	PUSH	BX
	TEST	BL,BL
	JS	L1899
	NOT	AH
	AND	CL,AH
	OR	AL,CL
L1883:
	MOV	ES:[DI],AL
	TEST	DI,2000H
	JE	L1891
	MOV	ES:[DI+2000H],AL
L1891:	POP	AX
	POP	BX
	POP	CX
	POP	DX
	POP	DI
	POP	DS
	POP	ES
	RET
L1899:	XOR	AL,CL
	JMP	SHORT L1883
L189D:	PUSH	ES
	PUSH	DS
	PUSH	DI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	XOR	BX,BX
	MOV	DS,BX
	MOV	BX,HERC_MONO_PAGE1
	MOV	ES,BX
	CALL	L18C1
	MOV	AL,ES:[DI]
	AND	AL,AH
	SHL	AL,CL
	MOV	CL,DH
	ROL	AL,CL
	POP	BX
	POP	CX
	POP	DX
	POP	DI
	POP	DS
	POP	ES
	RET
L17C2	ENDP
;
L18C1	PROC	NEAR
	PUSH	BX
	PUSH	AX
	PUSH	DX
	MOV	AL,40
	AND	DL,0FEH
	MUL	DL
	POP	DX
	TEST	DL,01H
	JE	L18D4
	OR	AX,2000H
L18D4:	MOV	DI,AX
	POP	AX
	MOV	DX,CX
	MOV	BX,0180H
	MOV	CX,0703H
	CMP	BYTE PTR DS:[CRT_MODE],06H
	JNB	L18EC
	MOV	BX,02C0H
	MOV	CX,0302H
L18EC:	AND	CH,DL
	SHR	DX,CL
	ADD	DI,DX
	MOV	DH,BH
	XOR	CL,CL
L18F6:	ROR	AL,1
	ADD	CL,CH
	DEC	BH
	JNE	L18F6
	MOV	AH,BL
	SHR	AH,CL
	POP	BX
	RET
L18C1	ENDP
;
L1904	PROC	NEAR
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX
	MOV	AH,DS:[CRT_COLS]
	MOV	AL,BYTE PTR DS:[CRT_MODE]
	MOV	BH,DS:[ACTIVE_PAGE]
	POP	DS
	RET
L1904	ENDP
;
L1916	PROC	NEAR
	PUSH	DS
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	PUSH	BX
	MOV	BL,DS:[ACTIVE_PAGE]
	XOR	BH,BH
	SHL	BX,1
	MOV	DX,[BX+CURSOR_POSN]
	POP	BX
	MOV	BH,DS:[ACTIVE_PAGE]
	MOV	CX,DS:[CURSOR_MODE]
	CMP	AL,07H
	JE	L1994
	CMP	AL,08H
	JE	L1999
	CMP	AL,0AH
	JE	L19A1
	CMP	AL,0DH
	JE	L19A8
	MOV	BH,DS:[ACTIVE_PAGE]
	MOV	CX,0001H
	CALL	L17C2
	INC	DL
	CMP	DL,DS:[CRT_COLS]
	JB	L198F
L1957:	XOR	DL,DL
	CMP	DH,18H
	JNE	L198D
	XOR	BH,BH
	CALL	L10D9
	MOV	BH,00H
	CMP	BYTE PTR DS:[CRT_MODE],04H
	JB	L1973
	CMP	BYTE PTR DS:[CRT_MODE],07H
	JNE	L1978
L1973:	CALL	L14B0
	MOV	BH,AH
L1978:	MOV	AL,01H
	XOR	CX,CX
	MOV	DH,18H
	MOV	DL,DS:[CRT_COLS]
	DEC	DL
	CALL	L1221
L1987:	POP	AX
	POP	BX
	POP	CX
	POP	DX
	POP	DS
	RET
L198D:	INC	DH
L198F:	CALL	L10D9
	JMP	SHORT L1987
L1994:	CALL	L19AC
	JMP	SHORT L1987
L1999:	TEST	DL,DL
	JE	L198F
	DEC	DL
	JMP	SHORT L198F
L19A1:	CMP	DH,18H
	JNE	L198D
	JMP	SHORT L1957
L19A8:	XOR	DL,DL
	JMP	SHORT L198F
L1916	ENDP
;
L19AC	PROC	NEAR
	PUSH	AX
	PUSH	BX
	PUSH	CX
	IN	AL,PORT_B
	MOV	BH,AL
	OR	AL,03H
	OUT	PORT_B,AL
	MOV	BL,02H
L19B9:	MOV	AL,0B6H
	OUT	TIM_CTL,AL
	MOV	AX,0533H
	OUT	42H,AL
	MOV	AL,AH
	OUT	42H,AL
	MOV	CX,8000H
L19C9:	LOOP	L19C9
	MOV	AL,0B6H
	OUT	TIM_CTL,AL
	MOV	AX,0299H
	OUT	42H,AL
	MOV	AL,AH
	OUT	42H,AL
	MOV	CX,8000H
L19DB:	LOOP	L19DB
	DEC	BL
	JNE	L19B9
	MOV	AL,BH
	OUT	PORT_B,AL
	POP	CX
	POP	BX
	POP	AX
	RET
L19AC	ENDP
;
L19E9	PROC	NEAR
	PUSH	ES
	PUSH	BP
	PUSH	DS
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX
	XOR	DI,DI
	MOV	DS,DI
	MOV	AH,AL
	PUSH	DX
L19F7:
	MOV	AL,ES:[BP+00H]
	INC	BP
	CMP	AL,07H
	JE	L1A60
	CMP	AL,08H
	JE	L1A65
	CMP	AL,0AH
	JE	L1A6D
	CMP	AL,0DH
	JE	L1A74
	PUSH	CX
	MOV	CX,0001H
	TEST	AH,02H
	JE	L1A20
	MOV	BL,ES:[BP+00H]
	INC	BP
	CALL	L15F5
	JMP	SHORT L1A23
	NOP
L1A20:	CALL	L17C2
L1A23:	POP	CX
	INC	DL
	CMP	DL,DS:[CRT_COLS]
	JB	L1A4A
L1A2C:	XOR	DL,DL
	CMP	DH,18H
	JNE	L1A4A
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	AL,01H
	XOR	CX,CX
	MOV	DH,18H
	MOV	DL,DS:[CRT_COLS]
	DEC	DL
	MOV	BH,BL
	CALL	L1221
	POP	DX
	POP	CX
	POP	BX
L1A4A:	LOOP	L19F7
	TEST	AH,01H
	JE	L1A54
	CALL	L10D9
L1A54:	POP	AX
	POP	BX
	POP	CX
	POP	DX
	POP	DS
	POP	BP
	POP	ES
	RET
L1A5C:	INC	DH
	JMP	SHORT L1A4A
L1A60:	CALL	L19AC
	JMP	SHORT L1A4A
L1A65:	TEST	DL,DL
	JE	L1A4A
	DEC	DL
	JMP	SHORT L1A4A
L1A6D:	CMP	DH,18H
	JNE	L1A5C
	JMP	SHORT L1A2C
L1A74:	XOR	DL,DL
	JMP	SHORT L1A4A
L1A78:	INC	SI
	SBB	BP,WORD PTR DS:[L06F6]
L1A7A	EQU	$-3
	ADC	AL,[BX+DI]
	PUSH	WORD PTR [SI+1DH]
	PUSH	AX
	PUSH	BX
	MOV	BX,SP
	MOV	AX,CS
	CMP	SS:[BX+06H],AX
	JE	L1A93
	SHR	BYTE PTR CS:[L0112],1
L1A93:
	MOV	WORD PTR CS:[L0117],0400H
	POP	BX
	POP	AX
L1A9C:	INT	08H				;Timer Interrupt
	IRET

L1A9F:	CMP	CS:[L0111],07H
	JE	L1A9C
	TEST	CS:[L0111],80H
	JNE	L1A9C
	CMP	CS:[L0111],04H
	JB	L1AC9
	PUSH	AX
	INC	BYTE PTR CS:[L0114]
	MOV	AL,BYTE PTR CS:[L0114]
	CMP	AL,CS:[L0113]
	POP	AX
	JB	L1A9C
L1AC9:
	MOV	BYTE PTR CS:[L0114],00H
	MOV	BYTE PTR CS:[L0112],0FFH
	STI
	PUSHF
	PUSH	CS
	PUSH	WORD PTR CS:[L1A78]
	JMP	SHORT L1A9C
L19E9	ENDP
;
NEW_INTERRUPT_08H:
	TEST	BYTE PTR CS:[L0112],0FFH
	JE	L1B06
	PUSH	AX
	PUSH	BX
	MOV	BX,SP
	MOV	AX,CS
	CMP	SS:[BX+06H],AX
	JE	L1AF8
	SHR	BYTE PTR CS:[L0112],1
L1AF8:
	MOV	WORD PTR CS:[L0117],0400H
	POP	BX
	POP	AX
OLD_INTERRUPT_08H:
	DB	0EAH				;INSTRUCTION FOR JMP FAR
L1B02	DW	0000H				;IP FOR INTERRUPT 08H FAR JMP
L1B04	DW	0000H				;CS FOR INTERRUPT 08H FAR JMP
;
L1B06:	CMP	CS:[L0111],07H
	JE	OLD_INTERRUPT_08H
	TEST	CS:[L0111],80H
	JNE	OLD_INTERRUPT_08H
	CMP	CS:[L0111],04H
	JB	L1B30
	PUSH	AX
	INC	BYTE PTR CS:[L0114]
	MOV	AL,BYTE PTR CS:[L0114]
	CMP	AL,CS:[L0113]
	POP	AX
	JB	OLD_INTERRUPT_08H
L1B30:
	MOV	BYTE PTR CS:[L0114],00H
	MOV	BYTE PTR CS:[L0112],0FFH
	STI
	PUSHF
	PUSH	CS
	PUSH	WORD PTR CS:[L1A78]
	JMP	SHORT OLD_INTERRUPT_08H
L1B46:	MOV	CS:[L0BCE],AX
	MOV	CS:[L0BD6],ES
	MOV	CS:[L0BD4],DS
	MOV	CS:[L0BD0],SI
	MOV	CS:[L0BD2],DI
	MOV	CS:[L0BD8],CX
	CMP	DX,COLOR_STATUS
	JNE	L1B7B
	MOV	DI,SP
	MOV	SI,SS:[DI]
	MOV	ES,SS:[DI+02H]
	CMP	BYTE PTR ES:[SI],0ECH
	JNE	L1B7B
	MOV	DX,HERC_MONO_DSPSTAT
L1B7B:
	CMP	CS:[L0111],04H
	JB	L1BD7
	MOV	SI,CS:[L0BDB]
	LEA	DI,[SI+2000H]
	MOV	CX,CS:[L0117]
	MOV	AX,0BA00H
	MOV	ES,AX
	MOV	DS,AX
	CLD
	REPZ	MOVSW
	MOV	AL,8AH
	MOV	DI,DX
	MOV	DX,HERC_MONO_DSPMODE
	OUT	DX,AL
	MOV	DX,DI
	CMP	SI,2000H
	JB	L1BAD
	XOR	SI,SI
L1BAD:
	MOV	CS:[L0BDB],SI
	MOV	CX,CS:[L0BD8]
	MOV	DI,CS:[L0BD2]
	MOV	SI,CS:[L0BD0]
	MOV	DS,CS:[L0BD4]
	MOV	ES,CS:[L0BD6]
	MOV	AX,CS:[L0BCE]
	CLI
	MOV	BYTE PTR CS:[L0112],00H
	IRET
L1BD7:	XOR	AX,AX
	MOV	DS,AX
	XCHG	DI,DX
	MOV	DX,HERC_MONO_INDXREG
	MOV	AL,0CH
	OUT	DX,AL
	INC	DX
	XOR	AL,AL
	OUT	DX,AL
	DEC	DX
	MOV	AL,0DH
	OUT	DX,AL
	INC	DX
	XOR	AL,AL
	OUT	DX,AL
	XCHG	DX,DI
	TEST	CS:[L010D],0FFH
	JNE	L1C23
	MOV	SI,DS:[CRT_START]
	MOV	DI,CS:[L0BDB]
	ADD	SI,DI
	MOV	CX,0400H
	MOV	AX,HERC_MONO_PAGE0
	MOV	ES,AX
	MOV	AX,HERC_MONO_PAGE1
	MOV	DS,AX
	CLD
	REPZ	MOVSW
	MOV	SI,DI
	CMP	SI,1000H
	JB	L1C1E
	XOR	SI,SI
L1C1E:
	MOV	CS:[L0BDB],SI
L1C23:
	MOV	CX,CS:[L0BD8]
	MOV	DI,CS:[L0BD2]
	MOV	SI,CS:[L0BD0]
	MOV	DS,CS:[L0BD4]
	MOV	ES,CS:[L0BD6]
	MOV	AX,CS:[L0BCE]
	CLI
	MOV	BYTE PTR CS:[L0112],00H
	IRET
L1C48:	REPZ	STOSW
	INT	20H				;Return to DOS
L1C4C	DB	0E0H,0E0H
L1C4E:	DB	80H,00H,02H,0EH,3EH,0FEH,3EH
	DB	0EH,02H,00H,18H,3CH,7EH,18H
L1C5C:	DB	18H,7EH,3CH,18H,66H,66H,66H,66H
	DB	66H,00H,66H,00H,7FH,0DBH
	DB	0DBH,7BH,1BH,1BH,1BH,00H,3EH,63H
	DB	38H,6CH,6CH,38H,0CCH,78H
	DB	00H,00H,00H,00H,7EH,7EH,7EH,00H
SIMCGA	ENDP
CODE	ENDS
	END	BEGIN
