	PAGE	60,132
	NAME	DISTYPE
	TITLE	DISTYPE - Display Graphics Adapter Type to Error Code
;
CODE	SEGMENT
	ASSUME	CS:CODE,DS:CODE,ES:CODE
DISTYPE	PROC	FAR
	ORG	0100H			;Origin for .COM File
BEGIN:	MOV	AH,0C1H			;Has SIMCGA Been Installed?
	INT	10H			;Perform Video Processing Request
	CMP	AX,0AAAAH		;Check Return Value
	JNE	CONTINUE		;Not Installed - Determine Adapter Type
	MOV	AL,01H			;SIMCGA Installed with Mono Adapter
EXIT:
	MOV	AH,4CH			;Return to DOS with Error Code
	INT	21H			;DOS Function Call
CONTINUE:
	PUSH	DS			;Save Data Segment
	MOV	AX,0C000H		;Code Segment for EGA ROM Addition
	MOV	DS,AX			;Load into Data Segment
	CMP	WORD PTR DS:[0000H],0AA55H ;Is EGA ROM Addition Present?
	POP	DS			;Restore Data Segment
	MOV	AL,03H			;EGA Adapter Installed
	JE	EXIT			;Yes - Return This Code
	PUSH	DS			;Save Data Segment
	XOR	AX,AX			;Clear AX
	MOV	DS,AX			;Set Data Segment to First Page
	CMP	BYTE PTR DS:[0449H],07H	;Is CRT_MODE = 7?
	POP	DS			;Restore Data Segment
	MOV	AL,01H			;SIMCGA Installed with Mono Adapter
	JNE	EXIT			;No - Return This Code
	PUSH	ES			;Store Extra Segment
	MOV	DX,03BFH		;Port Addr. of Hercules Config. Switch
	MOV	AL,03H
	OUT	DX,AL
	MOV	AX,0B000H		;Load Value of Page 0
	MOV	ES,AX			; Into Extra Segment
	MOV	WORD PTR ES:[3FFEH],162EH
	MOV	WORD PTR ES:[7FFEH],04D2H
	CMP	WORD PTR ES:[7FFEH],04D2H
	JNE	L016B
	CMP	WORD PTR ES:[3FFEH],162EH
	JNE	L016B
	MOV	WORD PTR ES:[8FFEH],2694H
	CMP	WORD PTR ES:[8FFEH],2694H
	JE	SIMCGA_NOT_RUN
L016B:
	MOV	DX,03BFH		;Port Addr. of Hercules Config. Switch
	MOV	AL,03H
	CLI
	OUT	DX,AL
	MOV	WORD PTR ES:[3FFEH],162EH
	MOV	WORD PTR ES:[7FFEH],04D2H
	CMP	WORD PTR ES:[7FFEH],04D2H
	JNE	MONO_WO_GRAPHICS
	CMP	WORD PTR ES:[3FFEH],162EH
	JNE	MONO_WO_GRAPHICS
	MOV	AL,83H
	OUT	DX,AL
	MOV	WORD PTR ES:[8FFEH],1538H
	CMP	WORD PTR ES:[8FFEH],1538H
	JNE	MONO_WO_GRAPHICS
	MOV	AL,29H
	OUT	DX,AL
	STI
	JMP	SHORT SIMCGA_NOT_RUN
	NOP
MONO_WO_GRAPHICS:
	MOV	AL,29H
	OUT	DX,AL
	STI
	POP	ES			;Restore Extra Segment
	MOV	AL,00H			;Mono Adapter with No Graphics
	JMP	EXIT
SIMCGA_NOT_RUN:
	POP	ES			;Restore Extra Segment
	MOV	AL,04H			;HGC Available, But SIMCGA Not Run
	JMP	EXIT
DISTYPE	ENDP
CODE	ENDS
	END	BEGIN
