     REM
     REM      WEATHER FORECAST PROGRAM by Phil Baughn
     REM
     REM      This software program is distributed as "SHAREWARE".  You may
     REM      feel free to copy and revise it as you like as long as you do
     REM      not alter or remove the credit information in the program. If
     REM      you find that you have made some significant improvements and
     REM      additions to this package, please upload them to my attention
     REM      either at The MAILROOM RBBS or to Compuserve; User#76044,1535.
     REM      Enjoy!    Phil Baughn
     REM
     REM     Mailing address:          The MAILROOM RBBS-PC
     REM                               c/o COMMUNITRONICS OF LEXINGTON, INC.
     REM                               attn.  Phil Baughn
     REM                               121 Prosperous Place, Suite 6B
     REM                               Lexington, KY  40509
     REM                               Data:  (606)293-5119
     REM                               Voice: (606)263-2737
     REM
     REM     Special Credit to Mssrs. Bernard N. Meisner and Leon F. Graves
     REM     who developed the Heat Index / Apparent Temperature Formula.
     REM
     REM     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     REM
     REM     BELOW TURNS KEYS OFF, SELECTS COLOR OR MONO, TURNS CAPS ON
     REM
     DEF SEG = 0
     POKE 1047, 96
     DEF SEG
TARGET2:
     KEY OFF
     CLS
     LOCATE 10, 23
     INPUT "Do you want Color? (Y)es or (N)o"; CLRANS$
     IF LEFT$(CLRANS$, 1) = "Y" OR LEFT$(CLRANS$, 1) = "y" THEN
         CLRT$ = "Y"
         GOTO TARGET1
     END IF
     IF LEFT$(CLRANS$, 1) <> "N" AND LEFT$(CLRANS$, 1) <> "n" THEN
         GOTO TARGET2
     END IF
     CLRT$ = " "
     REM
     REM
TARGET1:
     GOSUB TARGET3
     REM     GET WELCOME SCREEN AND CREDITS IN ABOVE LINE
     REM     GET MASTER WELCOME DOCUMENT IN FOLLOWING LINE
     GOSUB TARGET4
     REM
     REM     PRINT MAIN MENU
     REM
TARGET15:
     CLS
     IF CLRT$ = "Y" THEN
         COLOR 14
     END IF
     LOCATE 9, 20
     PRINT "1 - WEATHER FORECAST PROGRAM"
     IF CLRT$ = "Y" THEN
         COLOR 11
     END IF
     LOCATE 11, 20
     PRINT "2 - WIND CHILL CALCULATION"
     IF CLRT$ = "Y" THEN
         COLOR 12
     END IF
     LOCATE 13, 20
     PRINT "3 - TEMPERATURE HUMIDITY INDEX"
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     LOCATE 15, 20
     PRINT "4 - HEAT INDEX CALCULATION"
     IF CLRT$ = "Y" THEN
         COLOR 14
     END IF
     LOCATE 17, 20
     PRINT "5 - DEW POINT CALCULATION"
     IF CLRT$ = "Y" THEN
         COLOR 9
     END IF
     LOCATE 5, 5
     INPUT "ENTER THE NUMBER OF THE WEATHER PROGRAM WHICH YOU WISH TO RUN  "; CHOICE
     REM
     REM     GET FORCASTING SUNROUTINE
     REM
     IF CHOICE = 1 THEN
         GOSUB TARGET5
     ELSE
          GOTO TARGET6
     END IF
     GOTO TARGET7
     REM
     REM     GET WIND CHILL SUBROUTINE
     REM
TARGET6:
     IF CHOICE = 2 THEN
         GOSUB TARGET8
     ELSE
          GOTO TARGET9
     END IF
     GOTO TARGET7
     REM
     REM     GET TEMP-HUMIDITY SUBROUTINE
     REM
TARGET9:
     IF CHOICE = 3 THEN
         GOSUB TARGET10
     ELSE
          GOTO TARGET11
     END IF
     GOTO TARGET7
     REM
     REM     GET HEAT INDEX SUBROUTINE
     REM
TARGET11:
     IF CHOICE = 4 THEN
         GOSUB TARGET12
     ELSE
          GOTO TARGET13
     END IF
     GOTO TARGET7
     REM
     REM     GET DEW POINT SUBROUTINE
     REM
TARGET13:
     IF CHOICE = 5 THEN
         GOSUB TARGET14
     ELSE
          GOTO TARGET15
     END IF
     REM
     REM     LOOP OR QUIT
     REM
TARGET7:
     LOCATE 24, 14
     INPUT "DO YOU WISH TO DO A DIFFERENT CALCULATION (Y/N)"; D$
     REM
     REM     LOOP
     REM
     IF D$ = "Y" OR D$ = "y" THEN
         GOTO TARGET15
     END IF
     REM
     REM     QUIT WITH EPILOG SCREEN AND RESET IF CLRT$="Y" THEN COLORS TO NORMAL
     REM     ALSO PLACE CAPS AND NUMBERS LOCK KEYS BACK TO OFF STATUS
     REM
     IF CLRT$ = "Y" THEN
         COLOR 12, 0, 0
     END IF
     CLS
     LOCATE 9, 23
     PRINT "I hope you enjoyed WEATHER and"
     LOCATE 11, 21
     PRINT "that your forecast was a good one."
     LOCATE 15, 20
     PRINT "Let us here from you on The MAILROOM"
     LOCATE 17, 18
     PRINT "Data (606)293-5119 - 9600 Baud Supported"
     LOCATE 19, 37
     PRINT "- Phil Baughn"
     DEF SEG = 0
     POKE 1047, 0
     DEF SEG
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     LOCATE 24, 1
     END
     REM     ~~~~~~~~~~~~~~PROGRAM ENDS HERE~~~~~~~~~~~~~~
     REM
     REM     ~~~~~~~~SUBROUTINE MODULES BEGIN HERE~~~~~~~~
     REM
     REM     WELCOME SCREEN AND CREDITS SUBROUTINE
     REM
TARGET3:
     CLS
     WIDTH 80
     IF CLRT$ = "Y" THEN
         COLOR 11, 0
     END IF
     LOCATE 5, 5
     PRINT CHR$(201)
     LOCATE 5, 75
     PRINT CHR$(187)
     LOCATE 20, 5
     PRINT CHR$(200)
     LOCATE 20, 75
     PRINT CHR$(188)
     FOR N = 6 TO 19
     LOCATE N, 5
     PRINT CHR$(186)
     LOCATE N, 75
     PRINT CHR$(186)
     NEXT N
     FOR N = 6 TO 74
     LOCATE 5, N
     PRINT CHR$(205)
     LOCATE 20, N
     PRINT CHR$(205)
     NEXT N
     IF CLRT$ = "Y" THEN
         COLOR 13, 0
     END IF
     LOCATE 7, 31
     PRINT "WEATHER FORCASTING"
     LOCATE 9, 28
     PRINT "DEVELOPED FOR THE IBM-PC"
     LOCATE 10, 39
     PRINT "BY"
     LOCATE 11, 35
     PRINT "PHIL BAUGHN"
     LOCATE 13, 14
     PRINT "Special Thanks For Module Improvements To Sean Gayle,"
     LOCATE 14, 11
     PRINT "John Fleming, & Brad James - Meteorologist, WTVQ, Lexington"
     LOCATE 16, 20
     PRINT "Distributed Through The MAILROOM RBBS-PC"
     LOCATE 17, 29
     PRINT "In Lexington, Kentucky"
     LOCATE 18, 22
     PRINT "(606)293-5119   24 Hours - 9600 Baud"
     LOCATE 19, 22
     PRINT "Latest Revision [ 6.0 ]; August 1990"
     LOCATE 22, 27
     PRINT "Press any key when ready..."
TARGET16:
     IF INKEY$ = "" GOTO TARGET16
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     CLS
     RETURN
     REM
     REM     MAIN WELCOME DOCUMENT SUBROUTINE
     REM
TARGET4:
     IF CLRT$ = "Y" THEN
         COLOR 14, 1, 1
     END IF
     CLS
     PRINT "  "
     PRINT "  "
     PRINT "    This  program  will provide  you with a very good forcast providing"
     PRINT "    you supply the correct  information  as to barometric  pressure and"
     PRINT "    wind direction.  This method has been used  for ages  by  sailors &"
     PRINT "    the tables  themselves can still be found in  almost  all  editions"
     PRINT "    of The Farmers Almanac."
     PRINT " "
     PRINT "    The other four programs which are included at present;  Wind Chill,"
     PRINT "    Dew Point, Temp/Humidity, & Heat Index; can be especially important"
     PRINT "    when working outdoors.  Wind Chill tells you the true  FEEL  of the"
     PRINT "    temperature  after the wind has it's effect.   It's not always safe"
     PRINT "    to simply  look  at the outdoor thermometer!  Humidity also effects"
     PRINT "    the temperature.   Higher humidity  levels  cause it to effect your"
     PRINT "    body as if it were hotter than the thermometer states."
     PRINT "  "
     PRINT "    Enjoy the program,   please pass along any  improvements  which you"
     PRINT "    may develop  or  additional  modules  which will fit well into  the"
     PRINT "    menu.   Listing  the  first part of the program,  lines 1-20,  will"
     PRINT "    provide you with more detailed contact information."
     PRINT "  "
     PRINT "  "
     PRINT "    Press any key when ready..."
TARGET17:
     IF INKEY$ = "" GOTO TARGET17
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     CLS
     RETURN
     REM
     REM     WIND-BAROMETER FORECASTING SUBROUTINE
     REM
TARGET5:
     CLS
     IF CLRT$ = "Y" THEN
         COLOR 14
     END IF
     LOCATE 2, 25
     PRINT "WEATHER FORECAST PROGRAM"
     IF CLRT$ = "Y" THEN
         COLOR 5
     END IF
     LOCATE 4, 32
     PRINT DATE$
     LOCATE 5, 33
     PRINT TIME$
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
TARGET18:
     KEY OFF
     LOCATE 17, 1
     PRINT "             In inches, between 25.0 & 35.0.  Example:  29.95"
     LOCATE 7, 12
     INPUT "ENTER CURRENT BAROMETRIC PRESSURE                  "; CBP
     IF CBP < 25 THEN
         GOTO TARGET18
     END IF
     IF CBP > 35 THEN
         GOTO TARGET18
     END IF

BEGINING.OF.TRAP.1:
    
     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 17, 1
     PRINT "              Allowable entries are:  N NE E SE S SW W NW"
     LOCATE 8, 12
     INPUT "WIND DIRECTION IS CURRENTLY FROM THE               "; PWD$

     IF PWD$ = "N" THEN GOTO END.OF.TRAP.1
     IF PWD$ = "NE" THEN GOTO END.OF.TRAP.1
     IF PWD$ = "E" THEN GOTO END.OF.TRAP.1
     IF PWD$ = "SE" THEN GOTO END.OF.TRAP.1
     IF PWD$ = "S" THEN GOTO END.OF.TRAP.1
     IF PWD$ = "SW" THEN GOTO END.OF.TRAP.1
     IF PWD$ = "W" THEN GOTO END.OF.TRAP.1
     IF PWD$ = "NW" THEN GOTO END.OF.TRAP.1
    
     BEEP
     GOTO BEGINING.OF.TRAP.1
    
END.OF.TRAP.1:

     IF PWD$ = "SW" THEN
         GOTO TARGET19
     ELSE
         GOTO TARGET20
     END IF
TARGET19:

BEGINING.OF.TRAP.2:

     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 17, 1
     PRINT "              Allowable entries are:  N NE E SE S SW W NW"
     LOCATE 9, 12
     INPUT "PREVIOUS WIND DIRECTION WAS FROM THE               "; PWD$

     IF PWD$ = "N" THEN GOTO END.OF.TRAP.2
     IF PWD$ = "NE" THEN GOTO END.OF.TRAP.2
     IF PWD$ = "E" THEN GOTO END.OF.TRAP.2
     IF PWD$ = "SE" THEN GOTO END.OF.TRAP.2
     IF PWD$ = "S" THEN GOTO END.OF.TRAP.2
     IF PWD$ = "SW" THEN GOTO END.OF.TRAP.2
     IF PWD$ = "W" THEN GOTO END.OF.TRAP.2
     IF PWD$ = "NW" THEN GOTO END.OF.TRAP.2
   
     BEEP
     GOTO BEGINING.OF.TRAP.2
   
END.OF.TRAP.2:

     GOTO TARGET21
TARGET20:
     IF PWD$ = "SE" THEN
         GOTO TARGET22
     ELSE
          GOTO TARGET23
     END IF
TARGET22:

BEGINING.OF.TRAP.3:

     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 17, 1
     PRINT "              Allowable entries are:  N NE E SE S SW W NW"
     LOCATE 9, 12
     INPUT "PREVIOUS WIND DIRECTION WAS FROM THE               "; PWD$

     IF PWD$ = "N" THEN GOTO END.OF.TRAP.3
     IF PWD$ = "NE" THEN GOTO END.OF.TRAP.3
     IF PWD$ = "E" THEN GOTO END.OF.TRAP.3
     IF PWD$ = "SE" THEN GOTO END.OF.TRAP.3
     IF PWD$ = "S" THEN GOTO END.OF.TRAP.3
     IF PWD$ = "SW" THEN GOTO END.OF.TRAP.3
     IF PWD$ = "W" THEN GOTO END.OF.TRAP.3
     IF PWD$ = "NW" THEN GOTO END.OF.TRAP.3
  
     BEEP
     GOTO BEGINING.OF.TRAP.3
  
END.OF.TRAP.3:


     GOTO TARGET24
TARGET23:
     IF PWD$ = "S" THEN
         GOTO TARGET25
     ELSE
          GOTO TARGET26
     END IF
TARGET26:
     IF PWD$ = "N" THEN
         GOTO TARGET25
     ELSE
          GOTO TARGET27
     END IF
TARGET27:
     IF PWD$ = "NW" THEN
         GOTO TARGET25
     ELSE
          GOTO TARGET28
     END IF
TARGET28:
     IF PWD$ = "NE" THEN
         GOTO TARGET25
     ELSE
          GOTO TARGET29
     END IF
TARGET25:
     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 18, 23
     IF CLRT$ = "Y" THEN
         COLOR 9
     END IF
     PRINT "NO IMMEDIATE CHANGE IS FORECAST"
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     GOTO TARGET30
TARGET21:
     IF PWD$ = "S" THEN
         GOTO TARGET31
     ELSE
          GOTO TARGET32
     END IF
TARGET32:
     IF PWD$ = "NW" THEN
         GOTO TARGET33
     ELSE
          GOTO TARGET34
     END IF
TARGET31:
     PWD$ = "M"
     GOTO TARGET35
TARGET33:
     PWD$ = "N"
     GOTO TARGET35
TARGET34:
     PWD$ = "O"
     GOTO TARGET35
TARGET24:
     IF PWD$ = "NE" THEN
         GOTO TARGET36
     ELSE
          GOTO TARGET37
     END IF
TARGET37:
     IF PWD$ = "S" THEN
         GOTO TARGET38
     ELSE
          GOTO TARGET39
     END IF
TARGET36:
     PWD$ = "P"
     GOTO TARGET35
TARGET38:
     PWD$ = "Q"
     GOTO TARGET35
TARGET39:
     PWD$ = "R"
     GOTO TARGET35
TARGET29:
     IF PWD$ = "E" THEN
         GOTO TARGET40
     ELSE
          GOTO TARGET41
     END IF
TARGET41:
     IF PWD$ = "W" THEN
         GOTO TARGET42
     END IF
TARGET40:
     PWD$ = "S"
     GOTO TARGET35
TARGET42:
     PWD$ = "T"
TARGET35:
     IF CLRT$ = "Y" THEN
         COLOR 4
     END IF
     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 13, 12
     PRINT "WIND CONDITION CODE IS ", PWD$;
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
     IF CBP > 30.01 THEN
         GOTO TARGET43
     ELSE
          GOTO TARGET44
     END IF
TARGET44:
     IF CBP < 29.81 THEN
         GOTO TARGET45
     ELSE
          GOTO TARGET46
     END IF
TARGET46:

BEGINING.OF.TRAP.4:

     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 10, 12
     INPUT "IS PRESSURE RISING (R), FALLING (F), OR STEADY (S) "; BM$

     IF BM$ = "F" THEN GOTO END.OF.TRAP.4
     IF BM$ = "R" THEN GOTO END.OF.TRAP.4
     IF BM$ = "S" THEN GOTO END.OF.TRAP.4
 
     BEEP
     GOTO BEGINING.OF.TRAP.4
 
END.OF.TRAP.4:

     IF BM$ = "F" THEN
         GOTO TARGET47
     ELSE
          GOTO TARGET48
     END IF
TARGET47:

BEGINING.OF.TRAP.5:

     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 11, 12
     INPUT "IS IT FALLING RAPIDLY (R) OR SLOWLY (S)            "; BM$

     IF BM$ = "R" THEN GOTO END.OF.TRAP.5
     IF BM$ = "S" THEN GOTO END.OF.TRAP.5

     BEEP
     GOTO BEGINING.OF.TRAP.5

END.OF.TRAP.5:

     IF BM$ = "R" THEN
         GOTO TARGET49
     ELSE
          GOTO TARGET50
     END IF
TARGET49:
     BM$ = "C6"
     GOTO TARGET51
TARGET50:
     BM$ = "C5"
     GOTO TARGET51
TARGET48:
     IF BM$ = "R" THEN
         GOTO TARGET52
     ELSE
          GOTO TARGET53
     END IF
TARGET52:
     BM$ = "C7"
     GOTO TARGET51
TARGET53:
     BM$ = "C0"
     GOTO TARGET51
TARGET43:

BEGINING.OF.TRAP.6:

     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 10, 12
     INPUT "IS PRESSURE RISING (R), FALLING (F), OR STEADY (S) "; BM$

     IF BM$ = "F" THEN GOTO END.OF.TRAP.6
     IF BM$ = "R" THEN GOTO END.OF.TRAP.6
     IF BM$ = "S" THEN GOTO END.OF.TRAP.6

     BEEP
     GOTO BEGINING.OF.TRAP.6

END.OF.TRAP.6:


     IF BM$ = "F" THEN
         GOTO TARGET54
     ELSE
          GOTO TARGET55
     END IF
TARGET54:

BEGINING.OF.TRAP.7:

     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 11, 12
     INPUT "IS IT FALLING RAPIDLY (R) OR SLOWLY (S)            "; BM$

     IF BM$ = "R" THEN GOTO END.OF.TRAP.7
     IF BM$ = "S" THEN GOTO END.OF.TRAP.7

     BEEP
     GOTO BEGINING.OF.TRAP.7

END.OF.TRAP.7:

    
     IF BM$ = "R" THEN
         GOTO TARGET56
     ELSE
          GOTO TARGET57
     END IF
TARGET56:
     BM$ = "C4"
     GOTO TARGET51
TARGET57:
     BM$ = "C3"
     GOTO TARGET51
TARGET55:
     IF BM$ = "S" THEN
         GOTO TARGET58
     ELSE
          GOTO TARGET59
     END IF
TARGET58:
     BM$ = "C1"
     GOTO TARGET51
TARGET59:
     BM$ = "C2"
     GOTO TARGET51
TARGET45:

BEGINING.OF.TRAP.8:

     LOCATE 17, 1
     PRINT "                                                                            "
     LOCATE 10, 12
     INPUT "IS THE PRESSURE RISING (R) OR FALLING (F)          "; BM$

     IF BM$ = "R" THEN GOTO END.OF.TRAP.8
     IF BM$ = "F" THEN GOTO END.OF.TRAP.8

     BEEP
     GOTO BEGINING.OF.TRAP.8

END.OF.TRAP.8:

    
     IF BM$ = "R" THEN
         GOTO TARGET60
     ELSE
          GOTO TARGET61
     END IF
TARGET60:
     BM$ = "C8"
     GOTO TARGET51
TARGET61:
     BM$ = "C9"
     GOTO TARGET51
TARGET51:
     IF CLRT$ = "Y" THEN
         COLOR 4
     END IF
    
     LOCATE 17, 1
     PRINT "                                                                            "

     LOCATE 14, 12
     PRINT "BAROMETRIC CODE IS ", BM$
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
     IF PWD$ = "O" THEN
         GOTO TARGET25
     END IF
     IF PWD$ = "R" THEN
         GOTO TARGET25
     END IF
    
     LOCATE 17, 1
     PRINT "                                                                            "

     LOCATE 17, 18
     PRINT "PLEASE WAIT - FORECAST BEING COMPUTED"
     FOR X = 1 TO 3200
     NEXT X
     LOCATE 17, 18
     PRINT "                                                 "
     IF PWD$ = "T" AND BM$ = "C8" THEN
         GOTO TARGET62
     END IF
     IF PWD$ = "M" AND BM$ = "C7" THEN
         GOTO TARGET63
     END IF
     IF PWD$ = "Q" AND BM$ = "C3" THEN
         GOTO TARGET64
     END IF
     IF PWD$ = "Q" AND BM$ = "C4" THEN
         GOTO TARGET65
     END IF
     IF PWD$ = "Q" AND BM$ = "C9" THEN
         GOTO TARGET66
     END IF
     IF PWD$ = "P" AND BM$ = "C3" THEN
         GOTO TARGET67
     END IF
     IF PWD$ = "P" AND BM$ = "C4" THEN
         GOTO TARGET68
     END IF
     IF PWD$ = "P" AND BM$ = "C5" THEN
         GOTO TARGET69
     END IF
     IF PWD$ = "P" AND BM$ = "C6" THEN
         GOTO TARGET70
     END IF
     IF PWD$ = "P" AND BM$ = "C9" THEN
         GOTO TARGET66
     END IF
     IF PWD$ = "S" AND BM$ = "C3" THEN
         GOTO TARGET71
     END IF
     IF PWD$ = "S" AND BM$ = "C4" THEN
         GOTO TARGET72
     END IF
     IF PWD$ = "S" AND BM$ = "C9" THEN
         GOTO TARGET73
     END IF
     IF PWD$ = "N" AND BM$ = "C1" THEN
         GOTO TARGET74
     END IF
     IF PWD$ = "N" AND BM$ = "C2" THEN
         GOTO TARGET75
     END IF
     IF PWD$ = "N" AND BM$ = "C3" THEN
         GOTO TARGET76
     END IF
     IF PWD$ = "N" AND BM$ = "C7" THEN
         GOTO TARGET63
     END IF
     LOCATE 17, 20
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "WIND INCREASING; RAIN WITHIN 12 HOURS"
     GOTO TARGET30
     GOTO TARGET25
TARGET62:
     LOCATE 17, 30
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "CLEARING AND COLDER"
     GOTO TARGET30
TARGET63:
     LOCATE 17, 20
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "CLEARING WITHIN A FEW HOURS/"
     LOCATE 19, 20
     PRINT "FAIR FOR SEVERAL DAYS"
     GOTO TARGET30
TARGET64:
     LOCATE 17, 30
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "RAIN WITHIN 24 HOURS"
     GOTO TARGET30
TARGET65:
     LOCATE 17, 20
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "WIND INCREASING; RAIN WITHIN 24 HOURS"
     GOTO TARGET30
TARGET66:
     LOCATE 17, 15
     IF CLRT$ = "Y" THEN
         COLOR 15
     END IF
     PRINT "SEVERE STORM IMMIMENT, FOLLOWED WITHIN 24 HOURS"
     LOCATE 19, 15
     PRINT "BY CLEARING. IN WINTER, COLDER TEMPERATURES."
     GOTO TARGET30
TARGET67:
     LOCATE 17, 30
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "RAIN WITHIN 12 TO 18 HOURS"
     GOTO TARGET30
TARGET68:
     LOCATE 17, 20
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
TARGET69:
     LOCATE 17, 20
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "RAIN WILL CONTINUE FOR 1 TO 2 DAYS"
     GOTO TARGET30
TARGET70:
     LOCATE 17, 15
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "RAIN, WITH HIGH WIND, FOLLOWED WITHIN 36 HOURS BY"
     LOCATE 19, 15
     PRINT "CLEARING. IN WINTER - COLDER TEMPERATURES."
     GOTO TARGET30
TARGET71:
     LOCATE 17, 15
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "SUMMER - LIGHT WINDS; RAIN MAY NOT FALL FOR"
     LOCATE 19, 15
     PRINT "SEVERAL DAYS.  WINTER - RAIN WITHIN 24 HOURS"
     GOTO TARGET30
TARGET72:
     LOCATE 17, 15
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "SUMMER RAIN PROBABLE 12/24 HOURS.  WINTER"
     LOCATE 19, 15
     PRINT "RAIN OR SNOW, INCREASING WIND; BAD WEATHER"
     LOCATE 21, 15
     PRINT "OFTEN SETS IN WHEN BAROMETER BEGINS TO FALL AND"
     LOCATE 23, 15
     PRINT "WINDS SET IN FROM THE NORTHEAST."
     GOTO TARGET30
TARGET73:
     LOCATE 17, 15
     IF CLRT$ = "Y" THEN
         COLOR 15
     END IF
     PRINT "SEVERE NORTHEAST GALE AND HEAVY PRECIPITATION,"
     LOCATE 19, 15
     PRINT "IN WINTER - HEAVY SNOW FOLLOWED BY A COLD WAVE"
     GOTO TARGET30
TARGET74:
     LOCATE 17, 20
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "CONTINUED FAIR WEATHER WITH"
     LOCATE 19, 20
     PRINT "NO DECIDED TEMPERATURE CHANGE"
     GOTO TARGET30
TARGET75:
     LOCATE 17, 20
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "FAIR, FOLLOWED WITHIN 2 DAYS BY RAIN"
     GOTO TARGET30
TARGET76:
     LOCATE 17, 15
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     PRINT "FAIR FOR 2 DAYS WITH SLOWLY RISING TEMPERATURES"
TARGET30:
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     LOCATE 24, 17
     INPUT "DO YOU WISH TO RUN ANOTHER FORECAST (Y/N)"; L$
     IF L$ = "Y" OR L$ = "y" THEN
         GOTO TARGET5
     END IF
     RETURN
     REM
     REM     WIND CHILL SUBROUTINE
     REM
TARGET8:
     CLS
     IF CLRT$ = "Y" THEN
         COLOR 11
     END IF
     LOCATE 2, 27
     PRINT "WIND CHILL CALCULATION"
     IF CLRT$ = "Y" THEN
         COLOR 5
     END IF
     LOCATE 4, 34
     PRINT DATE$
     LOCATE 5, 35
     PRINT TIME$
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
     KEY OFF
     LOCATE 7, 12
     INPUT "ENTER TEMPERATURE IN FAHRENHEIT                    "; T
     LOCATE 8, 12
     INPUT "ENTER WIND SPEED IN MILES PER HOUR                 "; V
     IF V <= 4 THEN V = 4
     T1 = T
     V = (V * 1609.35) / (3600)
     TC = 33 - ((T - 32) * (5 / 9))
     H = (10.45 + (SQR(V) * 10) - V) * TC
     X = H - 506.784
     IF X < 0 THEN
         X1 = T1
         GOTO TARGET77
     END IF
     X1 = 50 - (X / 12.3)
     X1 = INT(((X1 * 10) + 5) / 10)
     IF CLRT$ = "Y" THEN
         COLOR 3
     END IF
     LOCATE 11, 19
     PRINT "PLEASE WAIT - WIND CHILL BEING COMPUTED"
     FOR ZZ = 1 TO 1600
     NEXT ZZ
     IF CLRT$ = "Y" THEN
         COLOR 4
     END IF
     LOCATE 13, 17
     PRINT "T1=T:V=(V*1069.35)/3600:TC=33-((T-32)*(5/9))"
     FOR Z = 1 TO 800
     NEXT Z
     LOCATE 14, 20
     PRINT "H=(10.45+(SQR(V)*10)-V)*TC:X=H-506.784"
     FOR ZXC = 1 TO 800
     NEXT ZXC
     LOCATE 15, 21
     PRINT "X1=50-(X/12.3):X1=INT(((X1*10)+5)/10)"
     FOR ZX = 1 TO 1600
     NEXT ZX
TARGET77:
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     LOCATE 19, 15
     PRINT "WIND CHILL TEMPERATURE = "; X1; "DEGREES FAHRENHEIT"
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     LOCATE 24, 19
     INPUT "RUN ANOTHER WIND CHILL FACTOR (Y/N)"; L$
     IF L$ = "Y" OR L$ = "y" THEN
         GOTO TARGET8
     END IF
     RETURN
     REM
     REM     HEAT INDEX SUBROUTINE
     REM
TARGET12:
     CLS
     IF CLRT$ = "Y" THEN
         COLOR 11
     END IF
     LOCATE 2, 27
     PRINT "HEAT INDEX CALCULATION"
     IF CLRT$ = "Y" THEN
         COLOR 5
     END IF
     LOCATE 4, 34
     PRINT DATE$
     LOCATE 5, 35
     PRINT TIME$
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
     KEY OFF
     LOCATE 7, 11
     INPUT "ENTER THE CURRENT TEMPERATURE IN DEGREES FAHRENHEIT "; TA
     U$ = "F"
     LOCATE 8, 11
     INPUT "ENTER THE RELATIVE HUMIDITY  (`50'= 50% )           "; RH
     IF CLRT$ = "Y" THEN
         COLOR 9
     END IF
     LOCATE 11, 18
     PRINT "PLEASE WAIT - HEAT INDEX BEING COMPUTED"
     FOR ZZ = 1 TO 1600
     NEXT ZZ
     IF CLRT$ = "Y" THEN
         COLOR 4
     END IF
     LOCATE 13, 23
     PRINT "Heat Index Is Also Refered To"
     FOR Z = 1 TO 800
     NEXT Z
     LOCATE 14, 17
     PRINT "As The Apparent Temperature.  See The H/I"
     FOR ZXC = 1 TO 800
     NEXT ZXC
     LOCATE 15, 18
     PRINT "Explanation & Danger Table For Details."
     FOR ZX = 1 TO 1600
     NEXT ZX
     GOSUB TARGET78
     IF CLRT$ = "Y" THEN
         COLOR 11
     END IF
     LOCATE 19, 19
     PRINT "APPARENT TEMPERATURE = "; APPTEMP; " "; U$
     IF DF < 0 THEN
         GOTO TARGET79
     END IF
     GOTO TARGET80
TARGET79:
     LOCATE 20, 19
     PRINT "SEVERE SULTRINESS..."
TARGET80:
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     LOCATE 23, 19
     INPUT "RUN ANOTHER HEAT INDEX FACTOR (Y/N)"; L$
     IF L$ = "Y" OR L$ = "y" THEN
         GOTO TARGET12
     END IF
     LOCATE 24, 16
     INPUT "View H/I  Explanation & Danger Table? (Y/N)"; CT$
     IF CT$ = "N" OR CT$ = "n" THEN
         GOTO TARGET81
     END IF
     IF CLRT$ = "Y" THEN
         COLOR 14, 1, 1
     END IF
     CLS
     PRINT "  "
     PRINT "       Your Present Calculated Heat Index Value Is"; APPTEMP; " "; U$; "."
     PRINT "  "
     PRINT "       When the  Heat Index reaches 130 degrees or higher, Heat"
     PRINT "       Strokes or  Sunstrokes are  HIGHLY likely with continued"
     PRINT "       exposure!   When the  Heat Index  ranges from 105 to 130"
     PRINT "       degrees,  sunstroke, heat exhaustion and heat cramps are"
     PRINT "       likely with  prolonged exposure and/or physical activity."
     PRINT "       Heat Index  ranges between 90 and 105 degrees indicate a"
     PRINT "       possibility  of  heat  cramps and  heat  exhaustion with"
     PRINT "       prolonged  exposure and/or physical activity."
     PRINT "  "
     PRINT "       Program calculations assume an adult, wearing long pants"
     PRINT "       and a  short sleeved shirt,  walking in shade at 3.1 MPH"
     PRINT "       with standard sea level air pressure,  a wind  speed  of"
     PRINT "       5.6 MPH, and a vapor pressure of 1.6kPa.  In effect, the"
     PRINT "       calculations  approximate the temperature  that  current"
     PRINT "       conditions feel like to the average person."
     PRINT "  "
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
TARGET81:
     RETURN
TARGET78:
     TC = TA
     IF U$ = "F" OR U$ = "f" THEN
         TC = (TA - 32) * 5 / 9
     END IF
     ES = 6.11 * 10 ^ ((7.567 * TC) / (239.7 + TC))
     E = .01 * RH * ES
     GOTO TARGET82
TARGET84:
     IF DF < 0 THEN
         GOTO TARGET83
     END IF
TARGET86:
     IF U$ = "F" OR U$ = "f" THEN
         APPTEMP = 32 + 1.8 * APPTEMP
     END IF
     RETURN
TARGET82:
     TB = 37
     PB = 5.65
     Q = 180
     RS = .0387
     ZS = .0521
     EHC = 17.4
     PHI2 = .84
     R = .124
     CHC = 11.6
     PINF = .1 * E
     HER = 4.18 + .036 * TC
     ERA = 1 / (EHC + HER)
     QV = Q * (.143 - .00112 * TC - .0168 * PINF)
     EZA = .060606 / EHC
     HR = 3.35 + .049 * TC
     ARA = 1 / (CHC + HR)
     AZA = .060606 / CHC
     Q2U = ((TB - TC) + (PB - PINF) * ERA / (ZS + EZA)) / (RS + ERA)
     QJ = (Q - QV - (1 - PHI2) * Q2U) / PHI2
     K = (RS + ARA) + (ZS + AZA) / R - ((TB - TC) + (PB - PINF) / R) / QJ
     L = (RS + ARA) * (ZS + AZA)
     L = (L - ((TB - TC) * (ZS + AZA) + (PB - PINF) * ARA) / QJ) / R
     F = K * K - 4 * L
     IF F < 0 THEN
         DF = -1
     END IF
     IF F < 0 THEN
         GOTO TARGET84
     END IF
     RF = .5 * (-K + SQR(F))
     DF = 60 * RF
     IF DF < 0 THEN
         GOTO TARGET84
     END IF
     W1 = .2016
     W2 = (1 - PHI2) / (RS + ERA)
     W3 = PHI2 / (RS + RF + ARA)
     W4 = 159.0984
     W5 = 37
     W6 = 4.05 * ERA / (ZS + EZA)
     W7 = 4.05 * (RF + ARA) / (ZS + R * RF + AZA)
     APPTEMP = (-W4 + W2 * (W5 + W6) + W3 * (W5 + W7)) / (W1 + W2 + W3)
     GOTO TARGET84
TARGET83:
     HC = 12.3
     HR = 4.1 + .028 * TC
     RA = 1 / (HC + HR)
     ZA = .060606 / HC
     QU = Q - QV
     FOR IT = 1 TO 10
     ZS = ((PB - PINF) * RA) / (QU * (RS + RA) - (TB - TC)) - ZA
     IF ZS < 0 THEN
         ZS = 0
     END IF
     R3 = (ZS / 600000!) ^ .2
     C = ABS(RS - R3)
     IF C <= .0001 THEN
         GOTO TARGET85
     END IF
     RS = .5 * (RS + R3)
     NEXT IT
TARGET85:
     N1 = 159.0984
     N2 = 37
     N3 = 4.05 * RA / (ZS + ZA)
     N4 = (RS + RA)
     N5 = .2016
     APPTEMP = (-N1 + (N2 + N3) / N4) / (N5 + 1 / N4)
     GOTO TARGET86
     REM
     REM     TEMP-HUMIDITY INDEX SUBROUTINE
     REM
TARGET10:
     CLS
     IF CLRT$ = "Y" THEN
         COLOR 12
     END IF
     LOCATE 2, 26
     PRINT "TEMPERATURE HUMIDITY INDEX"
     IF CLRT$ = "Y" THEN
         COLOR 5
     END IF
     LOCATE 4, 34
     PRINT DATE$
     LOCATE 5, 35
     PRINT TIME$
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
     KEY OFF
     LOCATE 7, 24
     PRINT "THE TEMPERATURE HUMIDITY INDEX"
     LOCATE 8, 21
     PRINT "DETERMINES THE EFFECTIVE TEMPERATURE"
     LOCATE 11, 12
     INPUT "ENTER THE TEMPERATURE IN FAHRENHEIT                 "; T
     LOCATE 12, 12
     INPUT "ENTER THE RELATIVE HUMIDITY  (`50'= 50% )           "; H
     LOCATE 15, 15
     PRINT "PLEASE WAIT - EFFECTIVE TEMPERATURE BEING COMPUTED"
     LOCATE 18, 30
     FOR C = 1 TO 16
     IF CLRT$ = "Y" THEN
         COLOR (C)
         PRINT "!!!!!!!!!!!!!!!!!!!"
     END IF
     LOCATE 18, 30
     C = C + 1
     FOR Z = 1 TO 400
     NEXT Z
     NEXT C
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
     LOCATE 18, 25
     PRINT "                                   "
     IF H > 94 THEN
         A = ((.195 * T) - 15)
     ELSE
          IF H > 89 AND H < 95 THEN
             A = ((.18 * T) - 15)
         END IF
     END IF
     IF H > 79 AND H < 90 THEN
         A = ((.1667 * T) - 15)
     ELSE
          IF H > 69 AND H < 80 THEN
             A = ((.145 * T) - 15)
         END IF
     END IF
     IF H > 59 AND H < 70 THEN
         A = ((.1233 * T) - 15)
     ELSE
          IF H < 60 THEN
             A = ((.085 * T) - 15)
         END IF
     END IF
     TH = (((.8 * T) + 15) + A)
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     LOCATE 20, 10
     PRINT "THE TEMPERATURE HUMIDITY INDEX =  "; TH; "DEGREES FAHRENHEIT"
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     LOCATE 23, 17
     INPUT "ANOTHER TEMPERATURE HUMIDITY INDEX (Y/N)"; L$
     IF L$ = "Y" OR L$ = "y" THEN
         GOTO TARGET10
     END IF
     LOCATE 24, 16
     INPUT "View THI Explanation & Comfort Table? (Y/N)"; CT$
     IF CT$ = "N" OR CT$ = "n" THEN
         GOTO TARGET87
     END IF
     GOTO TARGET88
TARGET87:
     RETURN
TARGET88:
     IF CLRT$ = "Y" THEN
         COLOR 14, 1, 1
     END IF
     CLS
     PRINT "  "
     PRINT "    Your Temperature-Humidity Index reading was "; TH; "."
     PRINT "  "
     PRINT "    Readings in excess of  70  represent the point  where a few people"
     PRINT "    begin  to  feel  uncomfortable.   Over 75, about 1/2 of all people"
     PRINT "    will feel uncomfortable. Nearly all people will feel uncomfortable"
     PRINT "    with  readings  over  79  with rapidly  decreasing work efficiency"
     PRINT "    begining  with  levels  in excess of  84;  and EXTREME DANGER with"
     PRINT "    possibility of heat  exhaustion  and heat stroke begin with levels"
     PRINT "    of 92 and higher."
     PRINT "  "
     PRINT "    The THI number, used to express the  combined temperature-humidity"
     PRINT "    effect provides a fairly good index of equivalent heat stress.  In"
     PRINT "    engineering, this combined index is refered to as `effective temp-"
     PRINT "    erature'. The weather bureau has also been known to refer to it as"
     PRINT "    the Discomfort Index.  It is NOT the same as the `Heat Index' even"
     PRINT "    though they both help to compute `Appearant' Temperatures."
     PRINT "  "
     PRINT "  "
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     RETURN
TARGET14:
     REM
     REM     DEW POINT SUBROUTINE
     REM
TARGET89:
     CLS
     IF CLRT$ = "Y" THEN
         COLOR 10
     END IF
     LOCATE 2, 28
     PRINT "DEW POINT CALCULATION"
     IF CLRT$ = "Y" THEN
         COLOR 5
     END IF
     LOCATE 4, 34
     PRINT DATE$
     LOCATE 5, 35
     PRINT TIME$
     IF CLRT$ = "Y" THEN
         COLOR 3, 0, 0
     END IF
     KEY OFF
     LOCATE 7, 12
     INPUT "ENTER TEMPERATURE IN FAHRENHEIT                    "; T
     LOCATE 8, 12
     INPUT "ENTER THE RELATIVE HUMIDITY (`50' = 50%)           "; DPRH
     T = (T - 32) * 5 / 9
     X = 1 - (.01 * DPRH)
     TD = T - (14.55 + .114 * T) * X - ((2.5 + .007 * T) * X) ^ 3 - (15.9 + .117 * T) * X ^ 14
     TD = (TD * 9 / 5) + 32
     IF CLRT$ = "Y" THEN
         COLOR 3
     END IF
     LOCATE 11, 19
     PRINT "PLEASE WAIT - DEW POINT BEING COMPUTED"
     FOR ZZ = 1 TO 1600
     NEXT ZZ
     IF CLRT$ = "Y" THEN
         COLOR 4
     END IF
     LOCATE 13, 23
     PRINT "TF=(T-32)*5/9:X=1-(.01*DPRH)"
     FOR Z = 1 TO 800
     NEXT Z
     LOCATE 14, 9
     PRINT "TD=T-(14.55+.114*T)*X-((2.5+.007*T)*X)^3-(15.9+.117*T)*X^14"
     FOR ZXC = 1 TO 800
     NEXT ZXC
     LOCATE 15, 30
     PRINT "TD=(TD*9/5)+32"
     FOR ZX = 1 TO 1600
     NEXT ZX
     IF CLRT$ = "Y" THEN
         COLOR 13
     END IF
     LOCATE 19, 21
     PRINT "DEW POINT CALCULATION = "; TD
     IF CLRT$ = "Y" THEN
         COLOR 7, 0, 0
     END IF
     LOCATE 24, 20
     INPUT "CALCULATE ANOTHER DEW POINT (Y/N)"; L$
     IF L$ = "Y" OR L$ = "y" THEN
         GOTO TARGET89
     END IF
     RETURN
     REM     ~~~~~~~~~~LAST LINE OF PROGRAM~~~~~~~~~
:
     

