;
;            Full assembler source code for the ~TESTCARD~ program.
;            ------------------------------------------------------
;
;   Copyright (C)2001 B.Walker, (G0LCU). Email to:-   wisecracker@tesco.net
;   -----------------------------------------------------------------------
;
;      Issued under the ~GPL~ terms and conditions, see ~LICENCE.GPL~.
;
;----------------------------------------------------------------------------
;
;
CALL MAIN_MESSAGE		       ;OPENING MESSAGES + COPYRIGHTS ETC
CALL CH4			       ;TESTCARD TO SETUP USER CONTROLS
RERUN: CALL INTRO_INFO		       ;INTRO MESSAGES
CALL INTRO_SCREEN		       ;FULL BRIGHT WHITE RASTER
CALL INTRO_QUESTIONS		       ;INTRO QUESTIONS
CALL PURITY_INFO		       ;PURITY MESSAGES
CALL PURITY			       ;CHECK COLOUR PURITY
CALL PURITY_QUESTIONS		       ;PURITY QUESTIONS
CALL CONVERGENCE_INFO		       ;CONVERGENCE MESSAGES
CALL CROSS			       ;SET STATIC CONVERGENCE, FOCUS
CALL CROSSHATCH                        ;SET DYNAMIC CONVERGENCE
CALL DOTS			       ;CHECK GUN GEOMETRY
CALL CONVERGENCE_QUESTIONS	       ;CONVERGENCE QUESTIONS
CALL CONVERGENCE_CONT		       ;DITTO
CALL FREQUENCY_INFO		       ;LF HF MESSAGES
CALL LF_TEST			       ;TEST VIDEO LOW FREQUENCY
CALL HF_TEST                           ;TEST VIDEO HIGH FREQUENCY
CALL FREQUENCY_QUESTIONS	       ;FREQUENCY QUESTIONS
CALL CHECKERBOARD_INFO		       ;CHECKERBOARD MESSAGES
CALL CHECKERBOARD		       ;CHECKERBOARD PATTERN
CALL CHECKERBOARD_QUESTIONS	       ;CHECKERBOARD QUESTIONS
CALL RASTER1_INFO		       ;STABILITY MESSAGES 1
CALL RASTER_STABILITY1		       ;CHECK FOR RASTER BOOMING
CALL RASTER_STABILITY2                 ;
CALL RASTER1_QUESTIONS		       ;QUESTIONS 1
CALL RASTER_STABILITY3                 ;
CALL RASTER2_QUESTIONS		       ;QUESTIONS 2
CALL SHADOWMASK_INFO		       ;SHADOW MASK MESSAGES
CALL FRINGE_TEST		       ;CHECK SHADOWMASK FOR FRINGING
CALL GRATING_INFO		       ;CHECK FREQUENCY RESPONSE
CALL FREQUENCY_GRATINGS                ;FREQUENCY RANGE CHECK
CALL COLOURBAR_INFO		       ;COLOUR BAR INFO
CALL COLOURS			       ;COLOUR BAR GENERATOR
CALL EXIT_SCREEN                       ;30 COLOURS ON SCREEN
MOV AH,2                               ;SET INTERRUPT MODE
MOV BH,0                               ;SET VIDEO PAGE
MOV DH,13                              ;SET ROW
MOV DL,29                              ;SET COLUMN
INT 10H                                ;DO IT
LEA DX,RERUN_MESSAGE                   ;MESSAGE TO RERUN PROGRAM
MOV AH,9                               ;SET INTERRUPT MODE
INT 21H                                ;DO IT
END_TEST: MOV AH,7                     ;SET INTERRUPT MODE
INT 21H                                ;WAIT FOR KEY PRESS
CMP AL,"Y"                             ;RERUN IF GOOD
JE RERUN                               ;DITTO
CMP AL,"y"                             ;RERUN IF GOOD
JE RERUN			       ;DITTO
CMP AL,"N"                             ;EXIT IF BAD
JE GETOUT                              ;DITTO
CMP AL,"n"                             ;EXIT IF BAD
JE GETOUT                              ;DITTO
JNE END_TEST                           ;LOOP TO TEST FOR KEYS
GETOUT: CALL CH4_INFO		       ;EXIT SCREEN
CALL CH4			       ;TESTCARD REPEAT
CALL CGA_MODE3			       ;RESET VIDEO MODE 3
MOV AX,04C00H			       ;SET RETURN CODE
INT 21H 			       ;USE DOS EXIT ROUTINE
;
RERUN_MESSAGE: DB "RERUN PROGRAM. (Y/N). ","$"
;
TEXT_OFF: MOV AL,"g"
MOV SI,TEXT_DATA
MOV [SI],AL
RET
;
MAIN_MESSAGE: CALL CGA_MODE3
LEA DX,START_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
INTRO_INFO: CALL CGA_MODE3
LEA DX,INTRO_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
INTRO_QUESTIONS: CALL CGA_MODE3
LEA DX,INTRO_QMESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
PURITY_INFO: CALL CGA_MODE3
LEA DX,PURITY_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
PURITY_QUESTIONS: CALL CGA_MODE3
LEA DX,PURITY_QMESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
CONVERGENCE_INFO: CALL CGA_MODE3
LEA DX,CONVERGENCE_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
CONVERGENCE_QUESTIONS: CALL CGA_MODE3
LEA DX,CONVERGENCE_QMESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
CONVERGENCE_CONT: CALL CGA_MODE3
LEA DX,CONVERGENCE_CONT_INFO
CALL RASTER_INFO
CALL CGA_MODE3
RET
FREQUENCY_INFO: CALL CGA_MODE3
LEA DX,FREQUENCY_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
FREQUENCY_QUESTIONS: CALL CGA_MODE3
LEA DX,FREQUENCY_QMESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
CHECKERBOARD_INFO: CALL CGA_MODE3
LEA DX,CHECKERBOARD_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
CHECKERBOARD_QUESTIONS: CALL CGA_MODE3
LEA DX,CHECKERBOARD_QMESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
RASTER1_INFO: CALL CGA_MODE3
LEA DX,RASTER1_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
RASTER1_QUESTIONS: CALL CGA_MODE3
LEA DX,RASTER1_QMESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
RASTER2_QUESTIONS: CALL CGA_MODE3
LEA DX,RASTER2_QMESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
SHADOWMASK_INFO: CALL CGA_MODE3
LEA DX,SHADOWMASK_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
GRATING_INFO: CALL CGA_MODE3
LEA DX,GRATING_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
COLOURBAR_INFO: CALL CGA_MODE3
LEA DX,COLOURBAR_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
CH4_INFO: CALL CGA_MODE3
LEA DX,CH4_MESSAGE
CALL RASTER_INFO
CALL CGA_MODE3
RET
;
START_MESSAGE: DB "                                   WARNING !!",10,13,10,13
DB "LETHAL POTENTIALS EXIST INSIDE ALL DISPLAYS THAT HAVE A CATHODE RAY TUBE INSIDE."
DB "ADJUSTMENTS  TO SUCH DISPLAYS  SHOULD BE MADE  BY EXPERIENCED  TECHNICIANS ONLY.",10,13
DB "THIS PROGRAM WAS  WRITTEN FOR ALL  MONITORS FROM CGA UPWARDS, AND IT WAS DECIDED"
DB "THAT IF ~FAULTS~ WERE PRESENT AT CGA LEVEL, THEN LOGICALLY THEY WOULD BE PRESENT"
DB "AT  ALL OTHER  RESOLUTIONS.",10,13,10,13
DB "This program was written as a remote, comprehensive check of all the  electronic"
DB "circuits related  ONLY  to a colour monitor running in standard mode  up to VGA."
DB "Copyright goes to  B.WALKER, 70 KING GEORGE ROAD, LOUGHBOROUGH, LEICS, LE11 2PA.",10,13
DB "It is assumed that no fault exists on the video card fitted inside the computer."
DB "Also it is assumed that all video  connections are wired correctly and optimised"
DB "for the highest video mode that will be used on the system currently under test.",10,13
DB "THE FIRST IMAGE IS A TEST CARD.THIS IMAGE CONTAINS ALL THE TESTS YET TO BE DONE."
DB "SET ALL  EXTERNAL USER CONTROLS  TO OBTAIN A GOOD QUALITY,  CENTRALISED DISPLAY.",10,13
DB "Do you wish to have on screen text. (Y/N). ","$"
INTRO_MESSAGE: DB "From now on all  the images that you will see will be simple. Note any anomalies"
DB "down on paper.The text before the image(s) appear will tell you what to observe."
DB "The text after  the image(s) will have questions attached  to them. All you have"
DB "to do is answer these relevant questions.Indivdiual manuals will be required for"
DB "major fault conditions. This software  is for setting up individual monitors but"
DB "it will describe the general area of a (possible design) fault condition.",10,13,10,13
DB "DO NOT ALTER ANY USER CONTROLS UNLESS INSTRUCTED TO DO SO.",10,13,10,13
DB "The first image displayed will be a ~FULL SCREEN~ white raster...",10,13,10,13
DB "NOTE THE BRIGHTNESS AND CONTRAST CONTROLS POSITION, NOW TURN BOTH TO MAXIMUM....",10,13
DB "1) OBSERVE IF RASTER MOMENTARILY ROLLS VERTICALLY.",10,13
DB "2) OBSERVE IF RASTER HAS ANY SLIGHT FOLDOVER ON THE LEFT HAND SIDE.",10,13
DB "3) OBSERVE ANY COLOUR FLARING ON RIGHT HAND SIDE.",10,13
DB "4) OBSERVE IF RASTER BALLOONS, AND THEN SETTLES BACK TO FULL SIZE QUICKLY.",10,13
DB "5) OBSERVE IF RASTER HAS VERTICAL STRIATIONS (RINGING) ON THE LEFT HAND EDGE.",10,13,10,13
DB "WHEN YOU HAVE NOTED ANY ANOMALIES, TURN BRIGHTNESS AND CONTRAST CONTROLS TO GIVE"
DB "A DARK RASTER AND NOTE  AGAIN ANY  ANOMALIES. RESET  BRIGHTNESS AND  CONTRAST TO"
DB "THEIR ORIGONAL POSITIONS....",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
INTRO_QMESSAGE: DB "HIGH BRIGHTNESS CONDITION.",10,13,10,13
DB "Did the raster roll momentarily.(Y/N)?......  If ~YES~ then VERTICAL/FIELD/FRAME"
DB "lock/hold control requires a small adjustment.",10,13
DB "Had the raster any foldover on the left hand side.(Y/N)?...If ~YES~ then suspect"
DB "line linearity, scanning circuits, blanking circuits.",10,13
DB "Had the raster  any colour flaring on the right hand side.(Y/N)?.. If ~YES~ then"
DB "suspect EHT regulation, PSU regulation,  low emission tube, CRT bias control set"
DB "too high, or colour drive control(s) too high.",10,13
DB "Did raster balloon.(Y/N)?. If ~YES~ then suspect,EHT regulation, PSU regulation."
DB "Did raster resettle quickly.(Y/N)?. If ~NO~ then check beam limiting, if any.",10,13
DB "Had the raster any striations on the left hand side.(Y/N)?.If ~YES~ then suspect"
DB "line scanning circuits, (especially width and linearity circuits).",10,13,10,13
DB "LOW BRIGHTNESS CONDITION.",10,13,10,13
DB "Has the raster any foldover on the left hand side.(Y/N)?.. If ~YES~ then suspect"
DB "blanking levels and/or timings.",10,13
DB "Has the raster any striations on the left hand side.(Y/N)?.If ~YES~ then suspect"
DB "line scanning circuits as before.",10,13
DB "Did the raster reduce in size.(Y/N)?. If ~YES~ then suspect EHT regulation. Note"
DB "this may be a design fault and NOT curable.",10,13,10,13
DB "Press SPACR BAR to continue:- ","$"
PURITY_MESSAGE: DB "The next  three screens  are the three  primary colours, RED, GREEN AND BLUE for"
DB "purity checks.The purity of the raster is adjusted by the scancoils and relevant"
DB "circuits to get a uniform RED screen. It is then checked in GREEN and then BLUE.",10,13
DB "DO NOT LOCATE MONITOR NEAR A STRONG MAGNETIC FIELD. (E.G. LOUDSPEAKER).",10,13,10,13
DB "1) OBSERVE IF FIRST COLOUR IS UNIFORMLY RED.",10,13
DB "2) OBSERVE IF RASTER IS RECTANGULAR.",10,13
DB "3) CHECK RASTER USING GREEN SCREEN.",10,13
DB "4) CHECK RASTER USING BLUE SCREEN.",10,13,10,13
DB "NB: MODERN CRT ASSEMBLIES OFTEN HAVE ALL THESE SETTINGS DONE DURING MANUFACTURE.",10,13
DB "Press SPACE BAR to continue:- ","$"
PURITY_QMESSAGE: DB "THE RED, GREEN AND BLUE RASTERS.",10,13,10,13
DB "Did the raster look uniformly RED.(Y/N)?...... If ~NO~ then suspect the scancoil"
DB "assembly, the degaussing circuit, the CRT, the convergence assembly.If raster is"
DB "unable to be made ~PURE~ then external  degaussing may be required. If raster is"
DB "still not ~PURE~ after this then suspect the shadow-mask of the CRT.",10,13
DB "Was the raster rectangular.(Y/N)?.If ~NO~ then suspect scanning yoke geometry or"
DB "barrel/pincushion/trapezoidal correction circuits.",10,13
DB "Did the check colours of GREEN and BLUE look uniform.(Y/N)?..... If ~NO~ then go"
DB "to RED raster and repeat setting up procedure as before.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
CONVERGENCE_MESSAGE: DB "The next three screens are to test static and dynamic convergence and also focus"
DB "circuits. Also a basic check on line and field linearity, pincushion, barrel and"
DB "trapezoidal errors can be observed.",10,13,10,13
DB "FIRST SCREEN. CENTRE CROSS.",10,13,10,13
DB "1) OBSERVE WHETHER CROSS IS AT THE CENTRE OF THE SCREEN.",10,13
DB "2) OBSERVE WHETHER CROSS HAS ANY COLOUR DEFECTS.",10,13
DB "3) OBSERVE WHETHER CROSS IS IN FOCUS.",10,13,10,13
DB "SECOND SCREEN. CROSSHATCH.",10,13,10,13
DB "4) OBSERVE OVERALL LINEARITY.",10,13
DB "5) OBSERVE ANY COLOURS ALONG THE EDGES OF THE LINES.",10,13
DB "6) OBSERVE ANY STRIATIONS ON THE VERTICAL LINES.",10,13
DB "7) CHECK WHETHER SCREEN IS IN FOCUS.",10,13
DB "8) OBSERVE WHETHER THERE IS ANY WAVYNESS OR SHIMMERING ON THE IMAGE.",10,13
DB "9) OBSERVE WHETHER VERTICALS HAVE BENDS OR KINKS IN THEM.",10,13,10,13
DB "THIRD SCREEN. DOT MATRIX.",10,13,10,13
DB "10) OBSERVE WHETHER OPPOSITE CORNERS ARE IN FOCUS.",10,13
DB "11) FINAL CHECK ON LINEARITY.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
CONVERGENCE_QMESSAGE: DB "THE CENTRE CROSS.",10,13,10,13
DB "Was the cross in the centre.(Y/N).If ~NO~ then consult manual for correct setup."
DB "If this is not possible suspect the crt, scanning or convergence circuits.",10,13
DB "Had the cross any colour fringing.(Y/N)..If ~YES~ then adjust static convergence"
DB "magnets or assembly.",10,13
DB "If cross is out of focus  then adjust as  required. If focussing is not possible"
DB "then suspect the focus circuits, EHT, and PSU regulation.",10,13,10,13
DB "THE CROSSHATCH IMAGE.",10,13,10,13
DB "Was raster linear.(Y/N)...If ~NO~ then adjust for best linearity.If linearity is"
DB "not possible then suspect linearity circuits,scanning or convergence assemblies."
DB "Was there any colour fringing on the lines.(Y/N)....If ~YES~ then adjust dynamic"
DB "convergence ciruits. If convergence is not possible then suspect the convergence"
DB "circuits, CRT or scanning geometry.",10,13
DB "Had the raster any vertical striations.(Y/N).....If ~YES~ then suspect the video"
DB "circutis, PSU decoupling and rgeulation.",10,13
DB "Secondary focus check OK.(Y/N).If ~NO~ then readjust to suit dynamic conditions."
DB "Was any wavyness observed.(Y/N).........If ~YES~ then check PSU for mains ~HUM~."
DB "Had the verticals any kinks in them.(Y/N)...If ~YES~ then suspect sync circuits,"
DB "blanking circuits, contrast circuit.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
CONVERGENCE_CONT_INFO: DB "THE DOT IMAGE.",10,13,10,13
DB "Were the extreme corners in focus.(Y/N)....If ~NO~ then try a minor readjustment"
DB "of the focus control. This may be beyond the specifications of the monitor under"
DB "test, so dont persevere with it.",10,13
DB "Secondary linearity check OK.(Y/N).If ~NO~ then do minor adjustments.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
FREQUENCY_MESSAGE: DB "The next two screens check the low frequency  characteristics, sync and blanking"
DB "circuits. A check on vertical ringing can be observed.",10,13,10,13
DB "FIRST SCREEN. LF TEST.",10,13,10,13
DB "1) OBSERVE WHETHER HORIZONTAL LINE IS STRAIGHT.",10,13
DB "2) OBSERVE WHETHER WHITE BLOCK IS RECTANGULAR.",10,13
DB "3) OBSERVE WHETHER HORIZONTAL LINE HAS SHIFTED TO THE RIGHT.",10,13
DB "4) NOTE WHETHER RASTER IS MOMENTARILY OUT OF LOCK VERTICALLY.",10,13
DB "5) OBSERVE WHETHER THERE IS FOLDOVER ON THE LEFT OF THE WHITE BLOCK.",10,13,10,13
DB "SECOND SCREEN. MF TEST.",10,13,10,13
DB "6) OBSERVE WHETHER VERTICAL LINE IS STRAIGHT.",10,13
DB "7) OBSERVE WHETHER WHITE BLOCK IS RECTANGULAR.",10,13
DB "8) OBSERVE WHETHER RASTER LOCKS UP QUICKLY.",10,13
DB "9) OBSERVE ANY STRIATIONS ON THE VERTICAL LINE.",10,13
DB "10) CHECK WHETHER THERE IS ANY FLARING ON THE RIGHT HAND SIDE OF THE BLOCK.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
FREQUENCY_QMESSAGE: DB "THE LOW FREQUENCY TEST.",10,13,10,13
DB "Was the line straight.(Y/N).If ~NO~ then check the dynamic convergence assembly."
DB "Was any wavyness observed.(Y/N).........If ~YES~ then check PSU for mains ~HUM~."
DB "Was the block rectangular.(Y/N).........If ~NO~ then check the scanning assembly"
DB "and also check the beam limiter circuits.",10,13
DB "Had the line shifted to the right.(Y/N)....If ~YES~ then check the sync timings."
DB "Did the raster lock immediately.(Y/N)...If ~NO~ then adjust VERTICAL/FIELD/FRAME"
DB "hold control for best condition.",10,13
DB "Was there any left side foldover.(Y/N).If ~YES~ then suspect line scan circuits.",10,13
DB "THE MEDIUM FREQUENCY TEST.",10,13,10,13
DB "Was the vertical line straight.(Y/N)..If ~NO~ then check dynamic scanning and/or"
DB "convergence circuits, and check sync decoupling circuits.",10,13
DB "Was the white block rectangular.(Y/N)....If ~NO~ then check beam limiter circuit"
DB "and possibly the EHT regulation under dynamic conditions.",10,13
DB "Did raster lock quickly.(Y/N).If ~NO~ then check sync circuits and timings.These"
DB "parameters may not be adjustable.",10,13
DB "Were striations observed.(Y/N)..If ~YES~ then check video circuits and CRT drive"
DB "circuits. Also check the external video connecting cable.",10,13
DB "Was any flaring observed.(Y/N)....If ~YES~ then refer to the bright white raster"
DB "screen, question number ~3~ for possible areas to look.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
CHECKERBOARD_MESSAGE: DB "The next screen is a checkerboard to test sync timings, check linearity and test"
DB "short burst beam limiting.",10,13,10,13
DB "1) OBSERVE WHETHER WHITE BOXES ARE PULLING TO THE RIGHT.",10,13
DB "2) OBSERVE WHETHER THE WHITE AND BLACK BOXES ARE THE SAME SIZE.",10,13
DB "3) OBSERVE WHETHER PICTURE IS LINEAR.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
CHECKERBOARD_QMESSAGE: DB "THE CHECKERBOARD PATTERN.",10,13,10,13
DB "Did the white boxes pull to the right on the right hand side.(Y/N).If ~YES~ then"
DB "check the sync circuits and timings. Also check decoupling circuits.",10,13
DB "Were the white and black boxes the same size.(Y/N)...If ~NO~ and the white boxes"
DB "were bigger than  the black boxes  then the beam limiter is responding to slowly"
DB "so check the beam limiter time constants. Also check EHT and PSU regulation.",10,13
DB "This is a dynamic linearity  check so if there is any maladjustment refer to the"
DB "convergence and linearity screens previously mentioned.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
RASTER1_MESSAGE: DB "The next three screens check dark grey to white purity, beam limiting and raster"
DB "stability, (which is also a check on EHT stability).",10,13,10,13
DB "When  the dark grey  screen appears, mark  each corner  with a dot using  a felt"
DB "tipped pen. View the  screen from  about 3 feet (1 metre) away. Press the RETURN"
DB "key and observe what happens.",10,13,10,13
DB "1) OBSERVE WHETHER THE DARK GREY SCREEN HAS A HINT OF COLOUR IN IT.",10,13
DB "2) PRESS RETURN KEY.",10,13
DB "3) OBSERVE WHETHER WHITE SCREEN HAS A HINT OF COLOUR IN IT.",10,13
DB "4) OBSERVE IF SCREEN SIZE HAS INCREASED BY MORE THAN 3mm.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
RASTER1_QMESSAGE: DB "THE DARK GREY AND WHITE SCREENS.",10,13,10,13
DB "Did the drak grey screen have a hint of colour in it.(Y/N).......If ~Y~ then the"
DB "background colour controls require a small adjustment.",10,13
DB "Did the white screen have a hint of colour in it.(Y/N)....If ~Y~ then the colour"
DB "drive controls require a small adjustment.",10,13
DB "Did the raster increase by more than 3mm.(Y/N).If ~Y~ then suspect the EHT, PSU.",10,13
DB "Now to observe what happens to a bright raster.",10,13,10,13
DB "1) OBSERVE WHETHER THE SCREEN INCREASES BY A FURTHER 2mm.",10,13
DB "2) OBSERVE WHETHER THE SCREEN ~BALLOONS~ IN SIZE AND RESETTLES.",10,13
DB "3) OBSERVE WHETHER THE SCREEN HAS A HINT OF COLOUR IN IT.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
RASTER2_QMESSAGE: DB "THE BRIGHT WHITE SCREEN.",10,13,10,13
DB "Did the screen increase by a further 2mm.(Y/N).If ~Y~ then suspect EHT supplies."
DB "Did the screen ~BALLOON~ and then resettle.(Y/N).If ~Y~ then the beam limiter is"
DB "slow to  respond to sudden heavy  tube current demands. This may not be curable."
DB "Did the raster have a hint of colour in it.(Y/N)....If ~Y~ then suspect that the"
DB "CRT may have low emission especially if retrace lines are observed.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
SHADOWMASK_MESSAGE: DB "THE INTERFERENCE GRATING TEST.",10,13,10,13
DB "The next image tests only for interference patterns, generated by the beam as it"
DB "scans the  tube face with vertical bars 1 pixel wide, every  alternate pixel, to"
DB "give a grating on a 640 pixel wide scan. This gives an indication of shadow mask"
DB "geometry relative  to the scan and the  phosphor on the tube face. Any anomolies"
DB "will NOT be curable at all......  YOU MAY HAVE TO VARY THE BRIGHTNESS TO SEE IT.",10,13
DB "1) OBSERVE THE PATTERNING ON THE SCREEN.",10,13
DB "2) AN IMAGE LIKE THIS ))||(( IS GOOD.",10,13
DB "3) AN IMAGE LIKE THIS ((||)) IS ALSO GOOD.",10,13
DB "4) NO INTERFERNCE PATTERN IS PERFECTION ITSELF.",10,13
DB "5) AN IMAGE LIKE THIS |||||| IS EXCELLENT.",10,13
DB "6) ANY OTHER PATTERN IS POOR.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
GRATING_MESSAGE: DB "THE FREQUENCY RESPONSE TEST.",10,13,10,13
DB "The next  screen is purely a video  frequency response  test up to about 10 Mhz."
DB "The frequencies from top to bottom are approximately 750Khz, 1.5Mhz, 3Mhz, 6Mhz,"
DB "and 12Mhz respectively.",10,13,10,13
DB "1) CHECK THAT THE BOTTOM GRATINGS CAN BE SEEN.",10,13
DB "2) OBSERVE WHETHER THERE IS ANY SMEARING TO THE RIGHT ON THE LOWER FREQUENCIES.",10,13,10,13
DB "If the highest frequency cannot be seen then bandwidth is less than 10Mhz.",10,13
DB "If smearing is observed then this will confirm a low bandwidth monitor.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
COLOURBAR_MESSAGE: DB "The next screen is just a simple colour bar  generator of the  six main  colours"
DB "and four shades of grey. The two outside edges of grey can be ignored.",10,13,10,13
DB "TURN THE BRIGHTNESS AND CONTRAST CONTROLS TO MAXIMUM.",10,13,10,13
DB "1) OBSERVE ANY FLARING TO THE RIGHT ON ANY OF THE COLOURS.",10,13
DB "2) OBSERVE WHETHER RETRACE LINES CAN BE SEEN ON ANY COLOUR.",10,13,10,13
DB "If flaring is observed then the CRT bias control will need adjustment.",10,13
DB "If retrace lines are observed then  suspect the CRT or the bias adjustment also.",10,13
DB "RESET THE BRIGHTNESS AND CONTRAST CONTROLS.",10,13,10,13
DB "Press SPACE BAR to continue:- ","$"
CH4_MESSAGE: DB "The last screen is a repeat of the testcard so as to reset all the user controls"
DB "back to a usable working level.   I trust you found this software usefull and if"
DB "you would like me to include  other video modes then please let me know by mail."
DB "There are some other monitor  ~faults~  that can show themselves in higher video"
DB "modes and scanning rates that may not show up in CGA.",10,13,10,13,10,13
DB "                                    BYE.","$"
;
; FULL SCREEN TO CHECK LEADING EDGE, TRAILING EDGE AND HEIGHT OF PICTURE
;
INTRO_SCREEN: MOV AX,4		       ;SET CGA MODE 4
INT 10H 			       ;DO IT
MOV AH,11			       ;SET INTERRUPT MODE
MOV BX,15			       ;SET VIDEO FORMAT FOR BACKGROUND
INT 10H 			       ;DO IT
CALL ESCAPE_KEY 		       ;EXIT ON ESCAPE
CALL CGA_MODE3			       ;RESET CGA MODE 3
RET				       ;RETURN TO MAIN ROUTINE
;
;	CENTRE CROSS FOR SETTING OF STATIC CONVERGENCE AND FOCUS.
;
CROSS: MOV AX,5			       ;SET CGA MODE 5
INT 10H                                ;GRAPHICS 320x200 CGA
MOV CX,150                             ;SET COLUMN NUMBER
CROSS_VERT: MOV AX,00C0FH	       ;SET GRAPHICS WRITE PIXEL
MOV DX,100			       ;SET ROW NUMBER
INT 10H                                ;PRINT PIXEL
INC CX,1                               ;INCREASE COLUMN BY ONE
CMP CX,171                             ;COMPARE AND KEEP GOING
JNE CROSS_VERT                         ;UNTIL FINSHED
MOV DX,92                              ;SET ROW NUMBER
CROSS_HORIZ: MOV AX,00C0FH	       ;SET GRAPHICS WRITE PIXEL
MOV CX,160			       ;SET COLUMN NUMBER
INT 10H                                ;PRINT PIXEL
INC DX,1                               ;INCREASE ROW BY ONE
CMP DX,109                             ;COMPARE AND KEEP GOING
JNE CROSS_HORIZ                        ;UNTIL FINISHED
CALL ESCAPE_KEY                        ;ESCAPE KEY
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET				       ;RETURN TO MAIN ROUTINE
;
;        CROSSHATCH SCREEN TO CHECK DYNAMIC CONVERGENCE AND FOCUS.
;
CROSSHATCH: MOV AX,5		       ;SET CGA MODE 5
INT 10H                                ;CGA 320x200 GRAPHICS
MOV DX,0                               ;SET ROW START
MOV CX,0                               ;SET COLUMN START
CROSSHATCH_HORIZ: MOV AX,00C0FH	       ;SET GRAPHICS WRITE PIXEL
INT 10H                                ;PRINT PIXEL
INC CX,1                               ;INC COLUMN BY ONE
CMP CX,320                             ;COMPARE AND KEEP GOING
JNE CROSSHATCH_HORIZ                   ;UNTIL FINISHED
MOV CX,0                               ;SET COLUMN START
INC DX,20                              ;NEXT LINE 20 PIXELS AWAY
CMP DX,200                             ;COMPARE AND KEEP GOING
JNE CROSSHATCH_HORIZ                   ;UNTIL FINISHED
MOV CX,0                               ;SET COLUMN START
MOV DX,199                             ;SET LINE TO PRINT
CROSSHATCH_HORIZ_LAST: MOV AX,00C0FH   ;SET GRAPHICS WRITE PIXEL
INT 10H                                ;PRINT PIXEL
INC CX,1                               ;INC COLUMN BY ONE
CMP CX,320                             ;COMPARE AND KEEP GOING
JNE CROSSHATCH_HORIZ_LAST              ;UNTIL FINISHED
MOV DX,0                               ;SET ROW START
MOV CX,0                               ;SET COLUMN START
CROSSHATCH_VERT: MOV AX,00C0FH	       ;SET GRAPHICS WRITE PIXEL
INT 10H                                ;PRINT PIXEL
INC DX,1                               ;INC ROW BY ONE
CMP DX,200                             ;COMPARE AND KEEP GOING
JNE CROSSHATCH_VERT                    ;UNTIL FINISHED
MOV DX,0                               ;SET ROW START
INC CX,20                              ;NEXT LINE 20 PIXELS AWAY
CMP CX,320                             ;COMPARE AND KEEP GOING
JNE CROSSHATCH_VERT                    ;UNTIL FINISHED
MOV CX,319                             ;LAST COLUMN TO PRINT
MOV DX,0                               ;SET ROW START
CROSSHATCH_VERT_LAST: MOV AX,00C0FH    ;SET GRAPHICS WRITE PIXEL
INT 10H                                ;PRINT PIXEL
INC DX,1                               ;INC ROW BY ONE
CMP DX,200                             ;COMPARE AND KEEP GOING
JNE CROSSHATCH_VERT_LAST               ;UNTIL FINISHED
CALL ESCAPE_KEY                        ;ESCAPE KEY PRESS
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET                                    ;RETURN TO MAIN ROUTINE
;
TEXT_DATA: DB "G"
DB "0LCU"
NOP
POP AX
RET
;
;      CLEAR THE SCREEN, SET TO CGA MODE 3, BLACK PAPER, WHITE INK.
;
CGA_MODE3: MOV AX,3		       ;SET VIDEO MODE 3, CGA
INT 10H 			       ;DO IT
RET
;
;       WAIT FOR ESCAPE TO BE PRESSED BEFORE GOING TO NEXT SCREEN.
;
ESCAPE_KEY: MOV AH,7                   ;WAIT FOR KEY, BUT DONT SHOW IT
INT 21H                                ;CALL DOS INTERRUPT
CMP AL,13			       ;IS IT THE ENTER KEY
JNE ESCAPE_KEY                         ;IF IT IS THEN
RET                                    ;RETURN TO CALLING ROUTINE
;
;     "COLOURS" IS A COLOUR BAR GENERATOR TO TEST THIS PROGRAM WITH.
;
COLOURS: CALL CGA_MODE3 	       ;CGA MODE 3
MOV AX,0B800H                          ;SET POINTER TO CGA RAM
MOV BL,25                              ;SET NUMBER OF LINES
COLOUR_BAR_LOOP: CLD                   ;CLEAR DIRECTION FLAG
MOV ES,AX                              ;CREATE ES: SEGMENT
ADD AX,10                              ;PREPARE FOR NEXT ES: POINTER
MOV DX,0                               ;DESTINATION POINTER
MOV SI,COLOUR_BARS                     ;POINTER TO COLOURS
ES:                                    ;WHERE TO GO IN REAL MEMORY
MOV DI,DX                              ;SET DESTINATION INDEX
MOV CX,80                              ;NUMBER OF CHARACTERS PER LINE
REPZ                                   ;KEEP GOING
MOVSW                                  ;UNTIL THE
SUB BL,1                               ;NEXT LINE
CMP BL,0                               ;AND EXIT ONLY
JNE COLOUR_BAR_LOOP                    ;WHEN DONE
CALL ESCAPE_KEY                        ;WAIT FOR ESCAPE KEY
CALL CGA_MODE3                         ;RESET CGA MODE 3 SCREEN
RET                                    ;RETURN TO MAIN PROGRAM
COLOUR_BARS: DB 219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,1,219,1,219,1,219,1,219,1,219,1,219,1,219,1
DB 219,4,219,4,219,4,219,4,219,4,219,4,219,4,219,4
DB 219,5,219,5,219,5,219,5,219,5,219,5,219,5,219,5
DB 219,2,219,2,219,2,219,2,219,2,219,2,219,2,219,2
DB 219,3,219,3,219,3,219,3,219,3,219,3,219,3,219,3
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8
;
;   THIS ROUTINE SETS UP A DARK GREY SCREEN FOR INITIAL SIZING CHECKS.
;
RASTER_STABILITY1: MOV BL,8	       ;SET DARK GREY
CALL RASTER                            ;PRINT BLANK DARK GREY SCREEN
CALL ESCAPE_KEY 		       ;HOLD UNTIL ESCAPE PRESSED
CALL CGA_MODE3			       ;RESET CGA MODE 3
RET
;
RASTER_STABILITY2: MOV BL,7	       ;SET LIGHT GREY
CALL RASTER                            ;PRINT BLANK LIGHT GREY SCREEN
CALL ESCAPE_KEY 		       ;HOLD UNTIL ESCAPE PRESSED
CALL CGA_MODE3			       ;RESET CGA MODE 3
RET
;
RASTER_STABILITY3: MOV BL,15	       ;SET WHITE SCREEN
CALL RASTER                            ;PRINT BLANK WHITE SCREEN
CALL ESCAPE_KEY                        ;HOLD UNTIL ESCAPE PRESSED
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET                                    ;RETURN TO MAIN PROGRAM
;
RASTER: MOV AH,9		       ;SET INTERRUPT MODE
MOV CX,2000                            ;SET NUMBER OF CHARACTERS
MOV BH,0                               ;SET VIDEO PAGE
MOV AL,219                             ;STANDARD IBM BLOCK CHARACTER
INT 10H                                ;VIDEO INTERRUPT
RET                                    ;RETURN TO CALLING ROUTINE
;
RASTER_INFO: MOV AL,[TEXT_DATA]
CMP AL,"G"
JNE REROUTE
MOV AH,9			       ;SET DOS INTERRUPT
INT 21H                                ;PRINT IT ONTO THE SCREEN
SPACE_BAR: MOV AH,7                    ;SET DOS INTERRUPT
INT 21H                                ;NO CHARACTER SHOWN
CMP AL," "			       ;PRESS SPACE BAR
JE REROUTE			       ;FOR TEXT AND EXIT
CMP AL,"y"			       ;y FOR TEXT
JE REROUTE
CMP AL,"Y"			       ;Y FOR TEXT
JE REROUTE
CMP AL,"n"			       ;n FOR NO TEXT
JE TEXT_EXIT
CMP AL,"N"			       ;N FOR NO TEXT
JE TEXT_EXIT
JNE SPACE_BAR
REROUTE: RET			       ;RETURN TO CALLING ROUTINE
TEXT_EXIT: JMP TEXT_OFF 	       ;SWITCH OFF TEXT
;
;   THIS ROUTINE IS FOR REPLACEMENT CRT'S AND INITIAL TUBE SETTING UP
;
PURITY: CALL CGA_MODE3                 ;SET CGA MODE 3
MOV BL,4                               ;SET RED RASTER
CALL RASTER                            ;DISPLAY RED RASTER
CALL ESCAPE_KEY                        ;WAIT UNTIL ESCAPE KEY PRESSED
CALL CGA_MODE3                         ;RESET CGA MODE 3
MOV BL,2                               ;SET GREEN RASTER
CALL RASTER                            ;DSIPLAY GREEN RASTER
CALL ESCAPE_KEY                        ;WAIT UNTIL ESCAPE KEY PRESSED
CALL CGA_MODE3                         ;RESET CGA MODE 3
MOV BL,1                               ;SET BLUE RASTER
CALL RASTER                            ;DISPLAY BLUE RASTER
CALL ESCAPE_KEY                        ;WAIT UNTIL ESCAPE KEY PRESSED
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET                                    ;RETURN TO MAIN LOOP
;
;        THIS ROUTINE IS TO CHECK SYNC CIRCUITS AND LINEARITY.
;
CHECKERBOARD: MOV AX,2		       ;SET VIDEO MODE 2
INT 10H 			       ;DO IT
MOV DI,12			       ;SET NUMBER OF LINES
CHECKERBOARD_LOOP: CALL WHITE_START    ;FIRST LINE START WHITE BLOCKS
CALL BLACK_START                       ;NEXT LINE START BLACK BLOCKS
DEC DI,1                               ;CONTINUE PRINTING
CMP DI,0                               ;UNTIL
JNE CHECKERBOARD_LOOP                  ;FINISHED
MOV DH,19                              ;NUMBER OF BLOCKS FOR
CALL WHITE                             ;LAST LINE TO PRINT
MOV AX,09DBH			       ;SET INTERUPT MODE
MOV BX,7			       ;SET VIDEO PAGE
MOV CX,2			       ;SET TWO CHARACTERS TO PRINT
INT 10H                                ;VIDEO INTERRUPT
CALL ESCAPE_KEY                        ;WAIT UNTIL ESCAPE KEY PRESSED
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET                                    ;RETURN TO MAIN LOOP
WHITE_START: MOV DH,20                 ;SET NUMBER OF MARKS TO SPACES
WHITE: MOV DL,2                        ;SET 2 WHITE BLOCKS
WHITE_LOOP: MOV AX,0EDBH	       ;SET INTERRUPT VALUE
MOV BX,7			       ;WHITE ATTRIBUTE
INT 10H                                ;VIDEO INTERRUPT
DEC DL,1                               ;NEXT CHARACTER
CMP DL,0                               ;CONTINUE UNTIL
JNE WHITE_LOOP                         ;TWO CHARACTERS PRINTED
MOV DL,2                               ;SET 2 BLACK BLOCKS
BLACK_LOOP: MOV AX,0E20H	       ;SET INTERRUPT
MOV BX,0			       ;BLACK ATTRIBUTE
INT 10H                                ;VIDEO INTERRUPT
DEC DL,1                               ;NEXT CHARACTER
CMP DL,0                               ;CONTINUE UNTIL
JNE BLACK_LOOP                         ;TWO SPACES PRINTED
DEC DH,1                               ;NEXT MARK TO SPACE
CMP DH,0                               ;CONTINUE UNTIL
JNE WHITE                              ;LINE DONE
RET                                    ;RETURN TO CALLING ROUTINE
BLACK_START: MOV DH,20                 ;SET SPACE TO MARK
BLACK: MOV DL,2                        ;SET 2 BLACK SPACES
LOOP_BLACK: MOV AX,0E20H	       ;SET INTERRUPT
MOV BX,0			       ;SET BLACK ATTRIBUTE
INT 10H                                ;PRINT CHARACTER
DEC DL,1                               ;CONTINUE PRINTING
CMP DL,0                               ;UNTIL
JNE LOOP_BLACK                         ;TWO CHARACTERS DONE
MOV DL,2                               ;SET TWO WHITE CHARACTERS
LOOP_WHITE: MOV AX,0EDBH	       ;SET INTERRUPT VALUE
MOV BX,7			       ;SET WHITE ATTRIBUTE
INT 10H                                ;PRINT CHARACTER
DEC DL,1                               ;CONTINUE PRINTING
CMP DL,0                               ;UNTIL
JNE LOOP_WHITE                         ;TWO CHARACTERS DONE
DEC DH,1                               ;CONTINUE BLOCKS
CMP DH,0                               ;UNTIL LINE
JNE BLACK                              ;PRINTED
RET                                    ;RETURN TO CALLING ROUTINE
;
;              CGA TEST CARD USING TEXT MODE 3
;
CH4: CALL CGA_MODE3                    ;CALL CGA MODE 3
CLD                                    ;CLEAR DIRECTION FLAG
MOV AX,0B800H                          ;SET CGA WINDOW
MOV ES,AX                              ;SET ES: SEGMENT POINTER
MOV DX,0                               ;SET DX REGISTER
MOV SI,TESTCARD                        ;SET POINTER TO TESTCARD DATA
ES:                                    ;INTO ES: SEGMENT
MOV DI,DX                              ;SET DESTINATION INDEX
MOV CX,2000                            ;2000 BYTES TO MOVE
REPZ                                   ;REPEAT UNTIL
MOVSW                                  ;FINISHED
CALL ESCAPE_KEY                        ;HOLD IMAGE UNTIL ESCAPE KEY
CALL CGA_MODE3                         ;SET CGA MODE 3
RET                                    ;RETURN TO MAIN ROUTINE
; LINE ONE
TESTCARD: DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 219,14,219,14,219,14,219,14,219,4,219,4,219,4,219,4
DB 219,4,219,4,219,4,219,4,219,14,219,14,219,14,219,14
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
; LINE TWO
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 219,14,219,14,219,14,219,14,219,4,219,4,219,4,219,4
DB 219,4,219,4,219,4,219,4,219,14,219,14,219,14,219,14
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
; LINE THREE
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,0,219,0,219,0,179,15
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
; LINE FOUR
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,0,219,0,219,0,179,15
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
; LINE FIVE
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,0,219,0,219,0,179,15
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
; LINE SIX
DB 221,15,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
; LINE SEVEN
DB 221,15,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
DB 219,0,219,0,219,0,219,0,219,0,219,7,219,7,219,7,219,7,219,7
; LINE EIGHT
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,3,219,3
DB 219,3,219,3,219,3,219,3,219,3,219,3,219,3,219,3
DB 219,3,219,3,219,3,219,2,219,2,219,2,219,2,219,2
DB 219,2,219,2,219,2,219,2,219,2,219,2,219,2,219,2
DB 219,5,219,5,219,5,219,5,219,5,219,5,219,5,219,5
DB 219,5,219,5,219,5,219,5,219,5,219,4,219,4,219,4
DB 219,4,219,4,219,4,219,4,219,4,219,4,219,4,219,4
DB 219,4,219,4,219,1,219,1,219,1,219,1,219,1,219,1
DB 219,1,219,1,219,1,219,1,219,1,219,1,219,1,219,1
; LINE NINE
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,3,219,3
DB 219,3,219,3,219,3,219,3,219,3,219,3,219,3,219,3
DB 219,3,219,3,219,3,219,2,219,2,219,2,219,2,219,2
DB 219,2,219,2,219,2,219,2,219,2,219,2,219,2,219,2
DB 219,5,219,5,219,5,219,5,219,5,219,5,219,5,219,5
DB 219,5,219,5,219,5,219,5,219,5,219,4,219,4,219,4
DB 219,4,219,4,219,4,219,4,219,4,219,4,219,4,219,4
DB 219,4,219,4,219,1,219,1,219,1,219,1,219,1,219,1
DB 219,1,219,1,219,1,219,1,219,1,219,1,219,1,219,1
; LINE TEN
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,14,219,14
DB 219,14,219,14,219,14,219,14,219,14,219,14,219,3,219,3
DB 219,3,219,3,219,3,219,3,219,3,219,3,219,3,219,3
DB 219,3,219,3,219,3,219,2,219,2,219,2,219,2,219,2
DB 219,2,219,2,219,2,219,2,219,2,219,2,219,2,219,2
DB 219,5,219,5,219,5,219,5,219,5,219,5,219,5,219,5
DB 219,5,219,5,219,5,219,5,219,5,219,4,219,4,219,4
DB 219,4,219,4,219,4,219,4,219,4,219,4,219,4,219,4
DB 219,4,219,4,219,1,219,1,219,1,219,1,219,1,219,1
DB 219,1,219,1,219,1,219,1,219,1,219,1,219,1,219,1
; LINE ELEVEN
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
; LINE TWELVE
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
; LINE THIRTEEN
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
; LINE FOURTEEN
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
; LINE FIFTEEN
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
; LINE SIXTEEN
DB 219,127,219,127,219,0,219,0,219,127,219,127,219,0,219,0,219,127,219,127
DB 219,0,219,0,219,127,219,127,219,0,219,0,219,127,219,127,219,0,219,0
DB 219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0
DB 219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0
DB 221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15
DB 221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15
DB 186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15
DB 186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15
; LINE SEVENTEEN
DB 219,127,219,127,219,0,219,0,219,127,219,127,219,0,219,0,219,127,219,127
DB 219,0,219,0,219,127,219,127,219,0,219,0,219,127,219,127,219,0,219,0
DB 219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0
DB 219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0
DB 221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15
DB 221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15
DB 186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15
DB 186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15
; LINE EIGHTEEN
DB 219,127,219,127,219,0,219,0,219,127,219,127,219,0,219,0,219,127,219,127
DB 219,0,219,0,219,127,219,127,219,0,219,0,219,127,219,127,219,0,219,0
DB 219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0
DB 219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0,219,127,219,0
DB 221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15
DB 221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15,221,15
DB 186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15
DB 186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15,186,15
; LINE NINETEEN
DB 221,15,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8
DB 219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8
DB 219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7
DB 219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
; LINE TWENTY
DB 221,15,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8
DB 219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8
DB 219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7
DB 219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
; LINE TWENTY ONE
DB 221,15,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0,219,0
DB 219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8
DB 219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8,219,8
DB 219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7
DB 219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7,219,7
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
DB 219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15,219,15
; LINE TWENTY TWO
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 219,127,223,127,223,127,223,127,223,127,223,127,223,127,223,127
DB 196,31,196,31,196,31,196,31,196,31,196,31,196,31,196,31
DB 196,31,196,31,196,31,196,31,196,31,196,31,196,31,196,31
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
DB 223,127,223,127,223,127,223,127,223,127,223,127,223,127,219,127
; LINE TWENTY THREE
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,1,67,31,71,31,65,31,219,1,84,31,69,31,83,31
DB 84,31,45,31,67,31,65,31,82,31,68,31,46,31,219,1
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
; LINE TWENTY FOUR
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,127,196,127,196,127,196,127,196,127,196,127,196,127,196,127
DB 219,1,66,31,46,31,87,31,65,31,76,31,75,31,69,31
DB 82,31,219,1,71,31,48,31,76,31,67,31,85,31,219,1
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
DB 196,127,196,127,196,127,196,127,196,127,196,127,196,127,219,127
; LINE TWENTY FIVE
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 219,127,220,127,220,127,220,127,220,127,220,127,220,127,220,127
DB 196,31,196,31,196,31,196,31,196,31,196,31,196,31,196,31
DB 196,31,196,31,196,31,196,31,196,31,196,31,196,31,196,31
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
DB 220,127,220,127,220,127,220,127,220,127,220,127,220,127,219,127
;
;        PULSE AND BAR FOR LOW FREQUENCY TESTS, HORIZONTAL PLANE.
;
LF_TEST: MOV AX,1		       ;SET VIDEO INTERUPT
INT 10H                                ;CGA MODE 0
MOV AH,2                               ;SET INTERRUPT MODE, CURSOR
MOV DX,0500H			       ;SET ROW,COLUMN
MOV BH,0                               ;SET VIDEO PAGE
INT 10H                                ;MOVE CURSOR POSITION
MOV AX,09C4H			       ;SET INTERRUPT MODE, PRINT
MOV BX,7			       ;SET VIDEO PAGE
MOV CX,40                              ;NUMBER OF CHARACTERS TO PRINT
INT 10H                                ;PRINT THEM
MOV AH,2                               ;SET INTERUPT MODE, CURSOR
MOV DX,0D00H			       ;SET ROW,COLUMN
MOV BH,0                               ;SET VIDEO PAGE
INT 10H                                ;MOVE CURSOR POSITION
MOV AX,09DBH			       ;SET INTERRUPT MODE, PRINT
MOV BX,7			       ;SET VIDEO PAGE
MOV CX,480                             ;NUMBER OF CHARACTERS TO PRINT
INT 10H                                ;PRINT THEM
CALL ESCAPE_KEY                        ;CALL ESCAPE KEY
CALL CGA_MODE3                         ;RESET CGA_MODE 3
RET                                    ;RETURN TO MAIN ROUTINE
;
;      PULSE AND BAR FOR MID TO HIGH FREQUENCY TESTS, VERTICAL PLANE
;
HF_TEST: MOV AX,1		       ;SET CGA MODE 0
INT 10H                                ;CGA MODE 0
MOV CL,24                              ;SET PRINT COUNT
PULSE_LOOP: LEA DX,PULSE_BAR           ;SET PRINT POINTER
MOV AH,9                               ;SET INTERRUPT MODE
INT 21H                                ;DOS INTERRUPT
DEC CL,1                               ;CONTINUE PRINTING
CMP CL,0                               ;UNTIL
JNE PULSE_LOOP                         ;FINISHED
LEA DX,PULSE_BAR1                      ;POINT TO LAST LINE
MOV AH,9                               ;SET INTERRUPT MODE
INT 21H                                ;DOS INTERRUPT
MOV AX,09DBH			       ;SET INTERRUPT MODE
MOV BX,7			       ;SET VIDEO MODE
INT 10H                                ;PRINT CHARACTER
CALL ESCAPE_KEY                        ;CALL ESCAPE KEY
CALL CGA_MODE3                         ;RESET CGA MODE_3
RET                                    ;RETURN TO MAIN ROUTINE
PULSE_BAR: DB 179,"                    ",219,219,219,219,219
DB 219,219,219,219,219,219,219,219,219,219,219,219,219,219,"$"
PULSE_BAR1: DB 179,"                    ",219,219,219,219,219
DB 219,219,219,219,219,219,219,219,219,219,219,219,219,"$"
;
;   CHECK FOCUS IN EXTREMITIES, ALSO CHECK CONVERGENC USING DOT MATRIX.
;
DOTS: MOV AX,0			       ;SET INTERRUPT VALUE
INT 10H                                ;GO TO VIDEO MODE 0
MOV AX,092EH			       ;SET INTERRUPT
MOV BX,7			       ;SET VIDEO PAGE
MOV CX,1000                            ;NUMBER OF CHARACTERS
INT 10H                                ;TO PRINT
MOV AH,1                               ;SET INTERRUPT MODE
MOV CX,02000H			       ;SET CURSOR LINE START
INT 10H                                ;REMOVE CURSOR
CALL ESCAPE_KEY                        ;ESCAPE KEY EXIT
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET                                    ;RETURN TO MAIN ROUTINE
;
;            FREQUENCY GRATINGS IN CGA MODE 6, 640 x 200.
;
FREQUENCY_GRATINGS: MOV AX,6	       ;SET INTERRUPT MODE
INT 10H                                ;DO IT
MOV CX,0                               ;GRAPHICS MODE, SET COLUMN
MOV DX,0                               ;SET LINE
MOV BP,20                              ;SET COUNTER
FREQ1: CALL FIRST_BLOCK_LOOP           ;DRAW
INC CX,1                               ;LINES
CALL FIRST_BLOCK_LOOP                  ;AS
INC CX,1                               ;REQUIRED
CALL FIRST_BLOCK_LOOP                  ;UNTIL
INC CX,1                               ;FINISHED
CALL FIRST_BLOCK_LOOP                  ;LF GRATINGS
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,1
CALL FIRST_BLOCK_LOOP
INC CX,17
DEC BP,1
CMP BP,0
JNE FREQ1
MOV CX,0                               ;GRAPHICS MODE, SET COLUMN
MOV DX,40                              ;SET LINE
MOV BP,40                              ;SET COUNTER
FREQ2: CALL SECOND_BLOCK_LOOP          ;DRAW
INC CX,1                               ;LINES
CALL SECOND_BLOCK_LOOP                 ;UNTIL
INC CX,1                               ;FINISHED
CALL SECOND_BLOCK_LOOP                 ;LF1 GRATINGS
INC CX,1
CALL SECOND_BLOCK_LOOP
INC CX,1
CALL SECOND_BLOCK_LOOP
INC CX,1
CALL SECOND_BLOCK_LOOP
INC CX,1
CALL SECOND_BLOCK_LOOP
INC CX,1
CALL SECOND_BLOCK_LOOP
INC CX,9
DEC BP,1
CMP BP,0
JNE FREQ2
MOV CX,0                               ;GRAPHICS MODE, SET COLUMN
MOV DX,80                              ;SET LINE
MOV BP,80                              ;SET COUNTER
FREQ3: CALL THIRD_BLOCK_LOOP           ;DRAW
INC CX,1                               ;LINES
CALL THIRD_BLOCK_LOOP                  ;UNTIL
INC CX,1                               ;FINISHED
CALL THIRD_BLOCK_LOOP                  ;MF GRATINGS
INC CX,1
CALL THIRD_BLOCK_LOOP
INC CX,5
DEC BP,1
CMP BP,0
JNE FREQ3
MOV CX,0                               ;GRAPHICS MODE, SET COLUMN
MOV DX,120                             ;SET LINE
MOV BP,160                             ;SET COUNTER
FREQ4: CALL FOURTH_BLOCK_LOOP          ;DRAW LINES
INC CX,1                               ;AS REQUIRED UNTIL
CALL FOURTH_BLOCK_LOOP                 ;MF1 GRATINGS
INC CX,3                               ;HAVE BEEN
DEC BP,1                               ;DRAWN ONTO
CMP BP,0                               ;THE
JNE FREQ4                              ;SCREEN
MOV CX,0                               ;GRAPHICS MODE, SET COLUMN
MOV DX,160                             ;SET LINE
MOV BP,320                             ;SET COUNTER
FREQ5: CALL FIFTH_BLOCK_LOOP           ;DRAW LINES
INC CX,2                               ;UNTIL HF GRATINGS
DEC BP,1                               ;HAVE BEEN DRAWN
CMP BP,0                               ;ONTO THE
JNE FREQ5                              ;SCREEN
CALL ESCAPE_KEY                        ;EXIT ON ESCAPE
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET                                    ;RETURN TO MAIN ROUTINE
FIRST_BLOCK_LOOP: MOV AX,0C0FH	       ;LF IN CGA 600 X 200
INT 10H                                ;WRITE PIXEL
INC DX,1                               ;INC PIXEL
CMP DX,40                              ;MODE 6
JNE FIRST_BLOCK_LOOP                   ;ONE LINE ONLY
MOV DX,0                               ;SET LINE
RET                                    ;RETURN TO CALLING ROUTINE
SECOND_BLOCK_LOOP: MOV AX,0C0FH	       ;LF1 IN CGA
INT 10H                                ;WRITE PIXEL
INC DX,1                               ;INC PIXEL
CMP DX,80                              ;MODE 6
JNE SECOND_BLOCK_LOOP                  ;ONE LINE ONLY
MOV DX,40                              ;SET LINE
RET                                    ;RETURN TO CALLING ROUTINE
THIRD_BLOCK_LOOP: MOV AX,0C0FH	       ;MF IN CGA
INT 10H                                ;WRITE PIXEL
INC DX,1                               ;INC PIXEL
CMP DX,120                             ;MODE 6
JNE THIRD_BLOCK_LOOP                   ;ONE LINE ONLY
MOV DX,80                              ;SET LINE
RET                                    ;RETURN TO CALLING ROUTINE
FOURTH_BLOCK_LOOP: MOV AX,0C0FH	       ;MF1 IN CGA
INT 10H                                ;WRITE PIXEL
INC DX,1                               ;INC PIXEL
CMP DX,160                             ;MODE 6
JNE FOURTH_BLOCK_LOOP                  ;ONE LINE ONLY
MOV DX,120                             ;SET LINE
RET                                    ;RETURN TO CALLING ROUTINE
FIFTH_BLOCK_LOOP: MOV AX,0C0FH	       ;HF IN CGA
INT 10H                                ;WRITE PIXEL
INC DX,1                               ;INC PIXEL
CMP DX,200                             ;MODE 6
JNE FIFTH_BLOCK_LOOP                   ;ONE LINE ONLY
MOV DX,160                             ;SET LINE
RET                                    ;RETURN TO CALLING ROUTINE
;
;  THIS SCREEN TEST FOR FRINGING INTERFERENCE EFFECTS DUE TO THE SHADOWMASK.
;
FRINGE_TEST: MOV AX,6		       ;SET INTERRUPT MODE
INT 10H                                ;DO IT
MOV CX,0                               ;SET TOP CORNER COLUMN
MOV DX,0                               ;SET TOP CORNER LINE
MOV BP,320                             ;SET COUNTER
SHADOW_MASK: CALL MASK_LOOP            ;CALL LINE DRAW ROUTINE
INC CX,2                               ;INC COLUMN COUNTER
DEC BP,1                               ;KEEP GOING
CMP BP,0                               ;UNTIL
JNE SHADOW_MASK                        ;FINISHED
CALL ESCAPE_KEY                        ;ESCAPE TO EXIT
CALL CGA_MODE3                         ;RESET CGA MODE 3
RET                                    ;RETURN TO MAIN ROUTINE
MASK_LOOP: MOV AX,0C07H		       ;SET INTERRUPT MODE
INT 10H                                ;DO IT
INC DX,1                               ;KEEP PLOTTING
CMP DX,200                             ;UNTIL
JNE MASK_LOOP                          ;VERTICAL LINE PLOTTED
MOV DX,0                               ;SET LINE TO TOP
RET                                    ;RETURN TO CALLING ROUTINE
;
;        STIPPLED BLOCK GRAPHICS TO OBTAIN 30 COLOURS ON SCREEN.
;
EXIT_SCREEN: CALL CGA_MODE3            ;SET CGA MODE 3
MOV AX,0B800H                          ;SET VIDEO
MOV BL,5                               ;TO CGA
CGA_COLOURS_LOOP: CLD                  ;MEMORY
MOV ES,AX                              ;AREA
ADD AX,10                              ;TO GIVE
MOV DX,0                               ;30 COLOURS
MOV SI,ALL_COLOURS                     ;ON SCREEN
ES:                                    ;TO EXIT
MOV DI,DX                              ;BEFORE
MOV CX,80                              ;RUNNING
REPZ                                   ;VGA AND MCGA
MOVSW                                  ;MODES
SUB BL,1                               ;USING A
CMP BL,0                               ;DIFFERENT
JNE CGA_COLOURS_LOOP                   ;PROGRAM
RET                                    ;RETURN TO MAIN ROUTINE
ALL_COLOURS: DB 32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0
DB 32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0
DB 177,16,219,1,177,25,219,9,177,57
DB 219,3,177,59,219,11,177,35,219,2,177,42,219,10
DB 219,14,177,110,219,6,177,70
DB 219,4,177,76,219,12,219,13,177,93,219,5,177,5
DB 219,0,177,8,219,8,177,120,219,7,177,127,219,15
DB 32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0
DB 32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0,32,0
