/*  del.c
    ====================================================================
    del command for CS-DOS
    ====================================================================
    del has the advantage of allowing wildcard filespecs, so things like

        del *.arc

    will work as expected. findfirst() and findnext(), however, do not
    match 1581 subdirectories or splat files, so thay cannot be deleted.
    ( use >s0:splatfile instead )
*/

#include <stream.hpp>
#include <string.h>
#include <ctype.h>
#include <dos.h>


void main(int argc, char ** argv)
{
    int     count = 0;
    FIND *  info;
    char    path[20], * cp;

    for (int arg=1; arg<argc; arg++) {

        strcpy(path, argv[arg]);

        if (path[1] == ':')
            cp = &path[2];
        else
            cp = path;

        info = findfirst(argv[arg],0);

        while(info != 0) {

            strcpy(cp,info->name);

            if (info->filetype >= FA_SEQ && info->filetype <= FA_REL) {

                cout << str(path,-20);

                if (unlink(path))
                    cout << "Delete failed.\n";
                else {
                    cout << "Deleted.\n";
                    count++;
                }
            }

            info = findnext();
        }
        arg++;
    }

    cout << count << " file(s) deleted.\n";

    exit(0);
}




