/**************************************************************************

            Main include file for word-tachistoscope

**************************************************************************/

#define MIN_ARG_CNT 1
#define FILENAMELEN 30

#define SMALL_TEXT_SIZE 1

#define INCREMENT 1
#define BIG_INCREMENT 10
#define MAXINTERVAL 10000
#define FREQ2PERIOD 1000.0

#define X_COORD 320
#define Y_COORD 240
/*******position of displayed words*****/
#define X_FREQ_COORD 600
#define Y_FREQ_COORD 10
/*******position of refresh freq.******/

/**********Top Display*****************/
#define TOP_COLOR LIGHTGREEN
#define TX1 0
#define TX2 639
#define TY1 45
#define TY2 TY1

#define TLX 33
#define TLY 15
#define TMX 311
#define TMY TLY
#define TRX 526
#define TRY TLY
#define TOFFSET 30
#define TROFFSET 8
#define TCOMPOFFSET 19
#define TMWORD "words"
#define TRWORD "Speed Units"
/*************************************/

/********Bottom Display***************/
#define BOTTOM_COLOR LIGHTGREEN
#define BX1 0
#define BX2 639
#define BY1 455
#define BY2 BY1

#define BLX 8
#define BLY 455
#define BMX 269
#define BMY BLY
#define BRX 550
#define BRY BLY
#define LWORD "[f] [F] Faster"
#define MWORD "[s] [S] Slower"
#define RWORD "[ESC] Quit"
/************************************/

#define DEFAULT_INTERVAL 333
/*******How long word is displayed******/
/***** 333 ~~ 1/3 second ********/
/****** 95 also try *************/

#define TEXT_SIZE 4
/********size of displayed words*******/

#define MAXWORDLEN 40
/***Max Length of word fetched from file***/

#define BACKGROUND_COLOR WHITE

#define ESC 27
/*******ESCAPE key*****/

#define NUMLEN 11

#define FFACTOR .01

#define DEFAULT1 'd'
#define DEFAULT2 'D'

#define QUIT 10

#define FFSYMBOL ">>"
#define ADVANCEDIST 2500
/****500 words forward (approx.)****/
#define PAST_EOF -1L

typedef enum { FALSE, TRUE } Boolean;

struct Stats
       {
        long wds;
        int interval;
        float frequency;
        float requested_freq;
        unsigned total_seconds;
        unsigned minutes;
        unsigned seconds;
        };

void display_word( char *Word );
void graphics_setup( int Background_color );
void exit__( struct Stats sta_ );
void opening_screen( void );
void top_display( void );
char *top_stats( struct Stats tstats );
void bottom_display( void );
struct Stats getword( struct Parameters p );
void erase( char *text, int font_name, int font_size, int xc, int yc );
void countdown_screen( void );
