/***************************************************************************
                                       W A K
                              WORD "TACHISTOSCOPE"

                                     M\Cooper
                                    PO Box 237
                              St. David, AZ 85630-0237
                           -------------------------------
                           E-mail: thegrendel@theriver.com

****************************************************************************/


#include <stdio.h>
#include <time.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <graphics.h>
#include <ctype.h>
#include <dos.h>
#include "scrn2.h"
#include "wak.h"


void main( int argc, char **argv )
{
   char Filename [FILENAMELEN ],
        av = 'X';
   struct Stats stats;
   struct Parameters dParams;

      randomize();
      opening_screen();


      if( argc > MIN_ARG_CNT )
         av = *( *(argv + 1) );

      if( av == DEFAULT1 || av == DEFAULT2 )
             {
             dParams = set_defaults();
             strcpy( Filename, dParams.filename );
             }
       else
         { 
         dParams = param_screen();
         strcpy( Filename, dParams.filename );
         }

      if( dParams.cdnscr )
         countdown_screen();

      graphics_setup( WHITE );
      top_display();
      bottom_display();

      stats = getword( dParams );

      exit__( stats );
}

void display_word( char *word )
{

      settextstyle( SANS_SERIF_FONT, HORIZ_DIR, TEXT_SIZE );
      settextjustify( CENTER_TEXT, TOP_TEXT );

      setcolor( LIGHTRED );
      outtextxy( X_COORD, Y_COORD, word );

      return;
}


void erase( char *txt, int fontname, int fontsize, int xcoord, int ycoord )
{

      settextstyle( fontname, HORIZ_DIR, fontsize );
      settextjustify( CENTER_TEXT, TOP_TEXT );
//                    ===========
      setcolor( BACKGROUND_COLOR ); //BLUE for debug
      outtextxy( xcoord, ycoord, txt );

      return;
}

void exit__( struct Stats st )
{
   float freq;

      closegraph();

      printf( "\nSTATISTICS FOR THIS RUN\n" );
      printf( "\nYou looked at %ld words.", st.wds );
      printf( "\nTime elapsed is %d:", st.minutes );
      printf( "%02d.", st.seconds );

      printf( "\n\nThe final \"time delay constant\" was %d/1000 sec.",
              st.interval );
      freq = (float)st.wds / (float)st.total_seconds;
      printf( "\nInitial display speed setting was %4.2f \"speed units\".",
              st.requested_freq );
      printf( "\n*Final* display speed setting was %4.2f \"speed units\".",
              st.frequency );
      printf( "\nThe final display =frequency= was %4.2f words/second.\n\n", 
               freq );

      exit( QUIT );
}


struct Stats getword( struct Parameters params )
{
   char word [MAXWORDLEN],
        ch;
   FILE *wfp;      
   struct Stats statistics;
   time_t starting_time;
   Boolean Adv_Flag = FALSE;

      statistics.wds = 0L;
      statistics.interval = FREQ2PERIOD / params.frequency;
      statistics.total_seconds = 0;
      statistics.requested_freq = params.frequency;
      starting_time = time( NULL ); //Start clock.

      wfp = fopen( params.filename, "r" );

      

      while( !feof( wfp)
             && statistics.wds < params.maxwords
             && statistics.total_seconds < params.maxtime ) 
         {
         if( kbhit() )
            {
            ch = getch();

            if( ch == ESC )
                break;
            if( ch == 'f' && statistics.interval > INCREMENT )
               statistics.interval -= INCREMENT;
            if( ch == 'F' && statistics.interval > BIG_INCREMENT )
               statistics.interval -= BIG_INCREMENT;
            if( ch == 's' && statistics.interval < MAXINTERVAL )
               statistics.interval += INCREMENT;
            if( ch == 'S' && statistics.interval < MAXINTERVAL )
               statistics.interval += BIG_INCREMENT;
            if( ch == '>'  || ch == '.' || ch == ' ' ) //FF Keys
               Adv_Flag = TRUE;  // Fast Forward!

            statistics.frequency = FREQ2PERIOD / statistics.interval;
            }    

         fgets( word, MAXWORDLEN - 1, wfp );
         strupr( word );          //Convert to u/c
         if( Adv_Flag ) //Fast Forward?
            {
            Adv_Flag = FALSE; //Turn off FF     ZZZZZZZZZZ
            fseek( wfp, ADVANCEDIST, SEEK_CUR );
            if( ftell( wfp) == PAST_EOF )
               break;  // Don't wanna go past EOF, ha, ha.
            fgets( word, MAXWORDLEN, wfp );     //Discard word fragment
            if( feof( wfp ) )
               break; // Got the "last word" in?
            strcpy( word, FFSYMBOL );
            }
         display_word( word );
         delay( statistics.interval );       //How long to display word
         erase( word, SANS_SERIF_FONT, TEXT_SIZE, X_COORD, Y_COORD );
         statistics.frequency = FREQ2PERIOD / statistics.interval;
         statistics.total_seconds = time( NULL) - starting_time;
         statistics.minutes = statistics.total_seconds / 60;
         statistics.seconds = statistics.total_seconds % 60;
         statistics.wds++;

         top_stats( statistics );
         }

      fclose( wfp );

      return( statistics );
}


void top_display()
{
      setcolor( TOP_COLOR );
      line( TX1, TY1, TX2, TY2 );

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, SMALL_TEXT_SIZE );
      settextjustify( LEFT_TEXT, TOP_TEXT );

      outtextxy( TMX, TMY, TMWORD );
      outtextxy( TRX, TRY, TRWORD );

      return;
}

void bottom_display()
{
      setcolor( BOTTOM_COLOR );
      line( BX1, BY1, BX2, BY2 );

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, SMALL_TEXT_SIZE );
      settextjustify( LEFT_TEXT, TOP_TEXT );

      outtextxy( BLX, BLY, LWORD );
      outtextxy( BMX, BMY, MWORD );
      outtextxy( BRX, BRY, RWORD );

      return;
}

char *top_stats( struct Stats topstats )
{
   static char words      [NUMLEN],
          frequency       [NUMLEN],
          time            [NUMLEN];

   static float prev_freq;
   static time_t prev_time;

      if( topstats.wds ) //If number of words > 0, only...
         {
         erase( words,
                TRIPLEX_FONT, SMALL_TEXT_SIZE, TMX - TOFFSET, TMY );
         if( topstats.frequency != prev_freq )
            erase( frequency,
                TRIPLEX_FONT, SMALL_TEXT_SIZE, TRX - TOFFSET - TROFFSET, TMY );

         if( topstats.total_seconds != prev_time )
            {
            if( topstats.total_seconds > 1 && ( topstats.seconds % 10 ) )
               erase( time + 4,
                      TRIPLEX_FONT, SMALL_TEXT_SIZE, TLX + TCOMPOFFSET, TLY );
            else
               erase( time,
                      TRIPLEX_FONT, SMALL_TEXT_SIZE, TLX, TLY );
            }

         setcolor( TOP_COLOR ); 

         settextstyle( TRIPLEX_FONT, HORIZ_DIR, SMALL_TEXT_SIZE );
         settextjustify( CENTER_TEXT, TOP_TEXT );

         sprintf( words, "%ld", topstats.wds );
         outtextxy( TMX - TOFFSET, TMY, words );

         if( topstats.frequency != prev_freq )
            {
            sprintf( frequency, "%3.2f", topstats.frequency );
            outtextxy( TRX - TOFFSET - TROFFSET, TRY, frequency );
            }

         if( topstats.total_seconds != prev_time )
            {
            sprintf( time, "%02d:%02d", topstats.minutes, topstats.seconds );

            if( topstats.total_seconds > 1 && ( topstats.seconds % 10 ) )
               outtextxy( TLX + TCOMPOFFSET, TLY, time + 4 );
            else
               outtextxy( TLX, TLY, time );
            }

         }

      prev_freq = topstats.frequency;
      prev_time = topstats. total_seconds;

      return ( words );
}
