/****************************** Chess clock program ************************
      FULL-FEATURED CHESS CLOCK
      Large digital displays of clocks
			   Move counter
			   White and Black clocks separately settable
			   Times from 1 minute to 9 hours
			   Low-time warning (optional)
			   Flashing "tick" indicator (optional)
      Flag for active player's clock
      Audible player changeover indicator
      Pause control
      NEW: Optional "overtime" tracking in Word Game Mode
****************************************************************************/
// M\Cooper, PO Box 237, St. David, AZ 85630-0237
// E-mail: thegrendel@theriver.com
// Web:  http://personal.riverusers.com/~thegrendel/


#include <stdio.h>
#include <time.h>
#include <conio.h>
#include <stdlib.h>
#include <graphics.h>
#include <dos.h>
#include "oscr.hpp"
#include "chessclk.hpp"

#define XXPOS 60
#define YYPOS 37
// Base coordinates for time display

#define PX   197
#define PY   130
// Coordinates for "pause" message

#define XWIDTH 580
#define YHEIGHT 25
#define XXMARGIN 50
#define LXMARGIN 26
// *Whose_clock_is_running* flag coordinates

#define DEFAULT_TIME 2
#define DEFAULT_TEST() if( hrs==0 && min == 0 ) hrs = DEFAULT_TIME

//Word Game Mode Indicator Message
#define X_m 260
#define Y_m 30
#define wgm_color MAGENTA
char wgm_message [] = "Word Game Mode";

   FLAG ScrabFLAG = OFF;
   int wpsecs = 0,
       bpsecs = 0;
     

void main( int argc, char **argv )
{
      if( argc > 1 && ( *( *(argv+1) ) == 's' || *( *(argv+1) ) == 'S' ) )
          ScrabFLAG = ON; //Wanna play wordgames?

   randomize();
   opening_screen();
   play();
}

void CountdownTimer::clock_on()
{
   time_t prev_sec;
   int ch;

   toFLAG = OFF;
   pause_t = 0;

      if( p == WHITE_ )
	 text_color = LIGHTBLUE;
      else
	 text_color = DARKGRAY;

      setcolor( text_color );
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 5 );
      settextjustify( LEFT_TEXT, TOP_TEXT );

	 ShowFlag();


      /**************INITIALIZE**********************/
      startn_t = time ( NULL );  //Click on stopwatch.
      /**********************************************/

      gotoxy( XXPOS * p + 1, YYPOS );
      outtextxy( NAME_POS * p, 100, player [p] );
      display_time();  //Otherwise initial time not displayed...

      while( !( ch = kbhit() ) )
         {
/**************************(1)***************************/

	 prev_sec = seconds;
	 if( running_flag ) //Is this 2nd or later lap?
	    interval_t = time( NULL ) - startn_t;
	 else
	    interval_t = time( NULL ) - start_t;

/**********************XXXXX**********PAUSE-TIME**********************/
    if( !overtime_flag )
      running_t = total_seconds - interval_t - pause_t;
    else //if overtime
      {
      running_t =  interval_t - total_seconds - pause_t;
      text_color = LIGHTRED;
      }
//                                              ^^^^^^^

    if( overtime_flag && running_flag )
      running_t = interval_t + total_seconds - pause_t;
//            
	 convert( running_t );

	 if( seconds - prev_sec )
	    {
	    display_time();

	    if( !seconds )
	       if( minutes == warning )
		  if( !hours )
		     if( time_warning_flag )
			blatt();

	    if( visual_ticking_flag ) // Show blinking box ticks?
	       {
	       setfillstyle( random ( PATTERNS ), random ( COLORS ) );
	       setcolor ( random ( COLORS ) );
	       setlinestyle( SOLID_LINE, 0xFFF, NORM_WIDTH );
	       bar( X_C - RADIUS, Y_C - RADIUS,
		    X_C + RADIUS, Y_C + RADIUS );
	       }
	    }

	 if( timeout() && !ScrabFLAG )
	    exit_();
  
/******************(2)******************/
  if( timeout() && ScrabFLAG && !toFLAG )
     {
     overtime_flag = ON;

     startn_t = time( NULL );
     toFLAG = ON;

     if( running_flag)
        total_seconds = 0; /*********reset******/

     erase_numbers();
     }

	 }

      total_seconds = hours * 3600 + minutes * 60 + seconds;
      running_flag = ON;  // Remember that clock was already running.

      
      ch = getch(); //Retrieve keypress.
      if( ch == ESC )
          {
           if( overtime_flag && p == WHITE_ )
               wpsecs = total_seconds; 
           if( overtime_flag && p == BLACK_ )
               bpsecs = total_seconds;

           exit__(); //Quit.
          }
           

      if( ch == 'p' || ch == 'P' )
         {
           if( overtime_flag && p == WHITE_ )
               wpsecs = total_seconds; 
           if( overtime_flag && p == BLACK_ )
               bpsecs = total_seconds;

         pause();
          }


           if( overtime_flag && p == WHITE_ )
               wpsecs = total_seconds; 
           if( overtime_flag && p == BLACK_ )
               bpsecs = total_seconds;


      return;

}

void CountdownTimer::display_moves()
{
   char buf[ 5 ];
   static char ebuf[ 5 ];

      if( moves > 1 )
	 {
	 setcolor( WHITE );
	 settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
	 settextjustify( CENTER_TEXT, TOP_TEXT );
	 outtextxy( MOVES_X, MOVES_Y, ebuf );
	 }

      sprintf( buf, "%003d", moves );
      sprintf( ebuf, buf );
      setcolor( GREEN );
      settextstyle( TRIPLEX_FONT, HORIZ_DIR, 1 );
      settextjustify( CENTER_TEXT, TOP_TEXT );
      outtextxy( MOVES_X, MOVES_Y, buf );
      
      return;
}

void graphics_setup( int background_color )
{
   int grdriver = VGA,
       grmode = VGAHI;

       registerfarbgidriver( EGAVGA_driver_far );
       registerfarbgifont( gothic_font_far );
       registerfarbgifont( triplex_font_far );
       initgraph( &grdriver, &grmode, "" );
       setbkcolor( background_color );

// Note: Borland BGI graphics drivers are completely
//       incompatible with Microsloth Wimpdows.
//       ============

}


/*************************FINAL STATS?**************************/
void exit__()
{
      closegraph();

      if( ScrabFLAG )
         {
           printf( "White has %d minute(s) and %d second(s) of overtime.\n",
                    wpsecs/60, wpsecs%60 );
           printf( "Penalty points for White = %d.\n\n",
                     wpsecs/6 );

           printf( "Black has %d minute(s) and %d second(s) of overtime.\n",
                    bpsecs/60, bpsecs%60 );
           printf( "Penalty points for Black = %d.\n\n",
                     bpsecs/6 );
         }
     
      exit( QUIT );
}

	/***************Routine to erase old numbers*************/
void CountdownTimer::erase_numbers()
{
      setcolor ( WHITE ); 

      if( seconds == 59 || ( seconds == 0 && ScrabFLAG ) )
	 outtextxy( p * BLK_TIME, Y_TIMEPOS, line_clear );
      else
	 if( seconds == 9 || seconds == 19 || seconds == 29
	     || seconds == 39 || seconds == 49
      || ( seconds == 10 && ScrabFLAG )
      || ( seconds == 20 && ScrabFLAG )
      || ( seconds == 30 && ScrabFLAG )
      || ( seconds == 40 && ScrabFLAG )
      || ( seconds == 50 && ScrabFLAG )  )
		outtextxy( p * BLK_TIME + POS1_OFFSET, Y_TIMEPOS,
			   line_clear + 6 );
	  else
	     outtextxy( p * BLK_TIME + POS_OFFSET, Y_TIMEPOS,
			line_clear + 7 ); 

	 return;

}


void play()
{
   int hrs,
       min;
   char inputstr[ MAXLEN ],
	inp;

      clrscr();

      textcolor ( LIGHTCYAN );
      cprintf( "\n                              WHITE hours: " );
      gets( inputstr );
      hrs = atoi( inputstr );
      cprintf( "                              WHITE minutes: " );
      gets( inputstr );
      min = atoi( inputstr );
      DEFAULT_TEST();
      CountdownTimer t1( hrs, min, WHITE_ );

      textcolor( RED );
      cprintf( "\n                              BLACK hours: " );
      gets( inputstr );
      hrs = atoi( inputstr );
      cprintf( "                              BLACK minutes: " );
      gets( inputstr );
      min = atoi( inputstr );
      DEFAULT_TEST();
      CountdownTimer t2( hrs, min, BLACK_ );

      textcolor( YELLOW );
      cprintf( "\n\n                         Enable flashing clock ticks? " );
      inp = getche();
      if( inp == 'y' || inp == 'Y' )
	 t1.visual_ticking_flag = t2.visual_ticking_flag = ON;
      else
	 t1.visual_ticking_flag = t2.visual_ticking_flag = OFF;

      cprintf( "\n                                                      Enable time warning? " );
      inp = getche();
      if( inp == 'y' || inp == 'Y' )
	 {
	 t1.time_warning_flag = t2.time_warning_flag = ON;
	 cprintf( "                                                          At how many minutes? " );
	 gets( inputstr );
	 t1.warning = t2.warning = atoi( inputstr );
	 }
      else
	 t1.time_warning_flag = t2.time_warning_flag = OFF;

      textcolor( GREEN | BLINK );
      _setcursortype( _NOCURSOR );
      printf( "\n\n\n\n\n\n\n\n\n\n\n\n" );
      cprintf( "                             PRESS A KEY TO BEGIN" );
      while ( !getch() );  //Wait for keypress - to begin play.
      beep1();  //BEEP

      graphics_setup( WHITE );

      /***************************888DISPLAY SCRAB MSG*********************/
      if( ScrabFLAG )
          t1.Write_Message( X_m, Y_m, wgm_message , MAGENTA );
     /*********************************************************************/





      t1.initialize_clock();
      t1.moves++;
      t1.display_moves();
      t1.clock_on();
      beep1();

      t2.initialize_clock();
      t2.clock_on();
      beep2();

      while ( PLAY )
	 {
	 t1.moves++;  
	 t1.display_moves();
	 t1.clock_on();
      beep1();
	 t2.clock_on(); 
      beep2();
	 }
  

} // End play()


void opening_screen()
{
   char topline[] = "Chess Clock",
	by_line[] = "by",
	name_line[] = "M\\Cooper",
email_line[] = "thegrendel@theriver.com",
	endline[] = "PRESS A KEY";

      graphics_setup( CYAN );
      settextstyle( GOTHIC_FONT, HORIZ_DIR, HEADLINE_SIZE );
      settextjustify( CENTER_TEXT, CENTER_TEXT );
      setcolor( LIGHTRED );
      outtextxy( TOPX, TOPY, topline );

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, BY_LINE_SIZE );
      setcolor( BLUE );
      outtextxy( BY_LINE_X, BY_LINE_Y, by_line );

      setfillstyle( BAR_PATTERN, BAR_COLOR );
      bar3d( BAR_LEFT, BAR_TOP, BAR_RIGHT, BAR_BOTTOM, BAR_DEPTH, BAR_TOPFLAG );

      setfillstyle( PIE_PATTERN, PIE_COLOR );
      pieslice( PIE1_X, PIE_Y, PIE_STARTANGLE, PIE_ENDANGLE, PIE_RADIUS );
      pieslice( PIE2_X, PIE_Y, PIE_STARTANGLE, PIE_ENDANGLE, PIE_RADIUS );
      circle( PIE1_X, PIE_Y, CIRC_RAD );
      circle( PIE2_X, PIE_Y, CIRC_RAD );
      line( LINE1_X, LINE_Y1, LINE1_X, LINE_Y2 );
      line( LINE2_X, LINE_Y1, LINE2_X, LINE2_Y2 );
      setfillstyle( PIE_PATTERN, WHITE );
      bar( B1_LEFT, B1_TOP, B1_RIGHT, B_BOTTOM );
      bar( B2_LEFT, B2_TOP, B2_RIGHT, B_BOTTOM );


      settextstyle( TRIPLEX_FONT, HORIZ_DIR, NAME_LINE_SIZE );
      setcolor( BLUE );
      outtextxy( NAME_LINE_X, NAME_LINE_Y, name_line );

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, ENDLINE_SIZE ); 
      setcolor( BROWN );
      outtextxy( EMLINE_X, EMLINE_Y, email_line ); 

      sleep( DELAY );

      settextstyle( TRIPLEX_FONT, HORIZ_DIR, ENDLINE_SIZE );
      setcolor( RED );
      outtextxy( ENDLINE_X, ENDLINE_Y, endline );

      getch();
      closegraph();

      return;
}

void CountdownTimer::ShowFlag()
{
	 //Show flag over clock in use.
	 setfillstyle( INTERLEAVE_FILL, LIGHTRED );
	 bar( XXPOS * p + LXMARGIN, YYPOS,
		 XXPOS * p + XWIDTH - LXMARGIN, YYPOS + YHEIGHT );

	 //Erase flag over clock *not* in use.
	 setfillstyle( SOLID_FILL, WHITE );
	 if( p == WHITE_ ) pp = BLACK_;
	 else pp = WHITE_;
	 bar( XXPOS * pp + LXMARGIN, YYPOS,
		 XXPOS * pp + XWIDTH - LXMARGIN, YYPOS + YHEIGHT );

	 return;
}

void CountdownTimer::pause()
{
//Pause clock when [p] key is pressed.

   time_t interim_time = 0;


      beep2();   beep1();   //Sound for pause.

      pause_start_t = time( NULL );

      Write_Message( PX, PY, PauseMessage, LIGHTMAGENTA );  //Pause message.

      while( !getch() );   //Wait for keypress.

      interim_time = time( NULL );
      pause_t = interim_time - pause_start_t;

      Write_Message( PX, PY, PauseMessage, WHITE );  //Erase message.

      return;

}

void CountdownTimer::Write_Message( int Px, int Py, char *Pmessage, int Pcolor )
{
      setcolor( Pcolor);
      outtextxy( Px, Py, Pmessage );

      return;

}
