/**************************************************************************/
/*                            High Probability Bingos                     */
/*                                                                        */
/*                                     M\Cooper                           */
/*                                    PO Box 237                          */
/*                            St. David, AZ 85630-0237                    */
/*                        -------------------------------                 */
/*                        Email:  thegrendel@theriver.com                 */
/*                Web:  http://personal.riverusers.com/~thegrendel/       */
/*                                                                        */
/*                   $2.00 to register the entire WORDY package           */
/*                                                                        */
/**************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define FILE_OPENING_ERROR 3
#define FILENAME_MAXLEN 50
#define CR "\n"
#define MAXLEN 40
#define LINE_LEN 80
#define NOARGS 1
#define INCREMENT 1
#define SPACE ' '
#define WD 12
#define BUFFERSIZE 8192
#define TFILESUFFIX ".hpr"
#define WLN 8

#define SCALEFACTOR 100.0
#define FUDGEFACTOR 30.0
#define CUTOFF 713
/**** 713 ~= 10% of OSPD3 ****/


void getword( char *filename );
int word_eval( char *strg );

typedef enum { FALSE, TRUE } Boolean;

void main( int argc, char **argv )
{

   char fname[ MAXLEN ];

	 if( argc == NOARGS )
	    {
	    puts("Enter the name of the file to work on ");
	    gets( fname );
	    }
	 else
	    strcpy( fname, *( argv + 1 ) );

	 getword( fname );
}

int word_eval( char *word )
{

   int value [] =
   { 9, 2, 2, 4, 12, 2, 3, 2, 9, 1, 1, 4, 2, 6, 8, 2, 1, 6, 4,
     6, 4, 2, 2, 1, 2, 1 };

   int totalval = 0,
       index,
       slen;
   double normval;


     slen = strlen( word ) - 1; /*** Length of word less CR ***/

     while ( *word && *word != '\n' )
       {
       index = *word++ - 'a';
       totalval += value [index]--;
       }

     normval = (double)totalval/(double)slen;
     normval *= SCALEFACTOR;
     normval += FUDGEFACTOR;

     totalval = (int)normval;


      return ( totalval );

}





/*************************************************************/
void getword( char *filename )
{

           char word [ MAXLEN ],
                tfilename [ MAXLEN ],
                Wd [ WLN ];

	FILE *fptr,
             *tfile;
        int  i;
	long wcount = 0L;

	   /*********************************************************/

	   if( !( fptr = fopen( filename, "rt" ) ) )
		 {
		 printf( "\7\7\7Cannot open Wordfile!" );
		 exit( FILE_OPENING_ERROR );
		 }
      if( setvbuf( fptr, NULL, _IOFBF, BUFFERSIZE * 2 ) )
         exit ( FILE_OPENING_ERROR );  /*Extra buffering.*/


 
      /*******Create target file name******/
      *tfilename = *filename;
      *( tfilename + 1 ) = NULL;
      strcat( tfilename, TFILESUFFIX );
      /************************************/ 

             if( !( tfile = fopen( tfilename, "wt" ) ) )
                   {
                   printf( "\7\7\7Cannot open Targetfile!" );
                   exit( FILE_OPENING_ERROR );
                   }
      if( setvbuf( tfile, NULL, _IOFBF, BUFFERSIZE * 2 ) )
         exit ( FILE_OPENING_ERROR );  /*Extra buffering.*/


		 /*********************Main Loop*************/	 
		  while( fgets( word, MAXLEN, fptr ) != NULL )
                           {
                           if( word_eval( word ) >= CUTOFF )
                              {
			      fprintf( tfile, "%s", word );
			      wcount++;
                              }
                           } 
		  /*******************************************/

                 if( wcount == 1 )
                     strcpy( Wd, "word" );
                 else
                     strcpy( Wd, "words" );


                  printf( "\n%ld %s copied to file %s\n\n",
                           wcount, Wd, strupr( tfilename ) );

          fclose( fptr );      
          fclose( tfile );

}



